/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.logging;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.jdbc.logging.FormatBasedRemoteQueryModifierConfig;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFormatBasedRemoteQueryModifierConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FormatBasedRemoteQueryModifierConfig)ConfigAssertions.recordDefaults(FormatBasedRemoteQueryModifierConfig.class)).setFormat(""));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"query.comment-format", (Object)"format").buildOrThrow();
        FormatBasedRemoteQueryModifierConfig expected = new FormatBasedRemoteQueryModifierConfig().setFormat("format");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testInvalidFormatValue() {
        Assertions.assertThat((boolean)this.configWithFormat("*").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("(").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat(")").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("[").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("]").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("{").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("}").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("&").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("@").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("!").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("#").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("%").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("^").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("$").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("\\").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("/").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("?").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat(">").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("<").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat(";").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("\"").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat(":").isFormatValid()).isFalse();
        Assertions.assertThat((boolean)this.configWithFormat("|").isFormatValid()).isFalse();
    }

    @Test
    public void testValidFormatWithPredefinedValues() {
        Assertions.assertThat((boolean)new FormatBasedRemoteQueryModifierConfig().setFormat("$QUERY_ID $USER $SOURCE $TRACE_TOKEN").isFormatValid()).isTrue();
    }

    @Test
    public void testValidFormatWithDuplicatedPredefinedValues() {
        Assertions.assertThat((boolean)new FormatBasedRemoteQueryModifierConfig().setFormat("$QUERY_ID $QUERY_ID $USER $USER $SOURCE $SOURCE $TRACE_TOKEN $TRACE_TOKEN").isFormatValid()).isTrue();
    }

    private FormatBasedRemoteQueryModifierConfig configWithFormat(String format) {
        return new FormatBasedRemoteQueryModifierConfig().setFormat(format);
    }
}

