/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class BaseJdbcConfig {
    private static final String METADATA_CACHE_TTL = "metadata.cache-ttl";
    private static final String METADATA_SCHEMAS_CACHE_TTL = "metadata.schemas.cache-ttl";
    private static final String METADATA_TABLES_CACHE_TTL = "metadata.tables.cache-ttl";
    private static final String METADATA_STATISTICS_CACHE_TTL = "metadata.statistics.cache-ttl";
    private static final String METADATA_CACHE_MAXIMUM_SIZE = "metadata.cache-maximum-size";
    private static final long DEFAULT_METADATA_CACHE_SIZE = 10000L;
    private String connectionUrl;
    private Set<String> jdbcTypesMappedToVarchar = ImmutableSet.of();
    private Duration metadataCacheTtl = new Duration(0.0, TimeUnit.SECONDS);
    private Optional<Duration> schemaNamesCacheTtl = Optional.empty();
    private Optional<Duration> tableNamesCacheTtl = Optional.empty();
    private Optional<Duration> statisticsCacheTtl = Optional.empty();
    private boolean cacheMissing;
    private Optional<Long> cacheMaximumSize = Optional.empty();

    @NotNull
    @Pattern(regexp="^jdbc:[a-z0-9]+:(?s:.*)$", flags={Pattern.Flag.CASE_INSENSITIVE})
    public @NotNull @Pattern(regexp="^jdbc:[a-z0-9]+:(?s:.*)$", flags={Pattern.Flag.CASE_INSENSITIVE}) String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Config(value="connection-url")
    public BaseJdbcConfig setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public Set<String> getJdbcTypesMappedToVarchar() {
        return this.jdbcTypesMappedToVarchar;
    }

    @Config(value="jdbc-types-mapped-to-varchar")
    public BaseJdbcConfig setJdbcTypesMappedToVarchar(Set<String> jdbcTypesMappedToVarchar) {
        this.jdbcTypesMappedToVarchar = ImmutableSet.copyOf(jdbcTypesMappedToVarchar);
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @Config(value="metadata.cache-ttl")
    @ConfigDescription(value="Determines how long meta information will be cached")
    public BaseJdbcConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    @NotNull
    public Duration getSchemaNamesCacheTtl() {
        return this.schemaNamesCacheTtl.orElse(this.metadataCacheTtl);
    }

    @Config(value="metadata.schemas.cache-ttl")
    @ConfigDescription(value="Determines how long schema names list information will be cached")
    public BaseJdbcConfig setSchemaNamesCacheTtl(Duration schemaNamesCacheTtl) {
        this.schemaNamesCacheTtl = Optional.ofNullable(schemaNamesCacheTtl);
        return this;
    }

    @NotNull
    public Duration getTableNamesCacheTtl() {
        return this.tableNamesCacheTtl.orElse(this.metadataCacheTtl);
    }

    @Config(value="metadata.tables.cache-ttl")
    @ConfigDescription(value="Determines how long table names list information will be cached")
    public BaseJdbcConfig setTableNamesCacheTtl(Duration tableNamesCacheTtl) {
        this.tableNamesCacheTtl = Optional.ofNullable(tableNamesCacheTtl);
        return this;
    }

    @NotNull
    public Duration getStatisticsCacheTtl() {
        return this.statisticsCacheTtl.orElse(this.metadataCacheTtl);
    }

    @Config(value="metadata.statistics.cache-ttl")
    @ConfigDescription(value="Determines how long table statistics information will be cached")
    public BaseJdbcConfig setStatisticsCacheTtl(Duration statisticsCacheTtl) {
        this.statisticsCacheTtl = Optional.ofNullable(statisticsCacheTtl);
        return this;
    }

    public boolean isCacheMissing() {
        return this.cacheMissing;
    }

    @Config(value="metadata.cache-missing")
    @ConfigDescription(value="Determines if missing information will be cached")
    public BaseJdbcConfig setCacheMissing(boolean cacheMissing) {
        this.cacheMissing = cacheMissing;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getCacheMaximumSize() {
        return this.cacheMaximumSize.orElse(10000L);
    }

    @Config(value="metadata.cache-maximum-size")
    @ConfigDescription(value="Maximum number of objects stored in the metadata cache")
    public BaseJdbcConfig setCacheMaximumSize(long cacheMaximumSize) {
        this.cacheMaximumSize = Optional.of(cacheMaximumSize);
        return this;
    }

    @AssertTrue(message="metadata.cache-ttl or metadata.statistics.cache-ttl must be set to a non-zero value when metadata.cache-maximum-size is set")
    public @AssertTrue(message="metadata.cache-ttl or metadata.statistics.cache-ttl must be set to a non-zero value when metadata.cache-maximum-size is set") boolean isCacheMaximumSizeConsistent() {
        return !this.metadataCacheTtl.isZero() || this.statisticsCacheTtl.isPresent() && !this.statisticsCacheTtl.get().isZero() || this.cacheMaximumSize.isEmpty();
    }

    @AssertTrue(message="metadata.schemas.cache-ttl must not be set when metadata.cache-ttl is not set")
    public @AssertTrue(message="metadata.schemas.cache-ttl must not be set when metadata.cache-ttl is not set") boolean isSchemaNamesCacheTtlConsistent() {
        return !this.metadataCacheTtl.isZero() || this.schemaNamesCacheTtl.isEmpty();
    }

    @AssertTrue(message="metadata.tables.cache-ttl must not be set when metadata.cache-ttl is not set")
    public @AssertTrue(message="metadata.tables.cache-ttl must not be set when metadata.cache-ttl is not set") boolean isTableNamesCacheTtlConsistent() {
        return !this.metadataCacheTtl.isZero() || this.tableNamesCacheTtl.isEmpty();
    }
}

