/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.slice.SizeOf;
import io.trino.plugin.jdbc.CaseSensitivity;
import java.util.Objects;
import java.util.Optional;

public record JdbcTypeHandle(int jdbcType, Optional<String> jdbcTypeName, Optional<Integer> columnSize, Optional<Integer> decimalDigits, Optional<Integer> arrayDimensions, Optional<CaseSensitivity> caseSensitivity) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(JdbcTypeHandle.class);

    public JdbcTypeHandle {
        Objects.requireNonNull(jdbcTypeName, "jdbcTypeName is null");
        Objects.requireNonNull(columnSize, "columnSize is null");
        Objects.requireNonNull(decimalDigits, "decimalDigits is null");
        Objects.requireNonNull(arrayDimensions, "arrayDimensions is null");
        Objects.requireNonNull(caseSensitivity, "caseSensitivity is null");
    }

    public int requiredColumnSize() {
        return this.columnSize().orElseThrow(() -> new IllegalStateException("column size not present"));
    }

    public int requiredDecimalDigits() {
        return this.decimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Integer)this.jdbcType) + SizeOf.sizeOf(this.jdbcTypeName, SizeOf::estimatedSizeOf) + SizeOf.sizeOf(this.columnSize, SizeOf::sizeOf) + SizeOf.sizeOf(this.decimalDigits, SizeOf::sizeOf) + SizeOf.sizeOf(this.arrayDimensions, SizeOf::sizeOf) + SizeOf.sizeOf(this.caseSensitivity, caseSensitivity -> 0L);
    }
}

