/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.inject.Inject;
import dev.failsafe.RetryPolicy;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ForRetrying;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.RetryingModule;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;

public class RetryingJdbcClient
implements JdbcClient {
    private final JdbcClient delegate;
    private final RetryPolicy<Object> policy;

    @Inject
    public RetryingJdbcClient(@ForRetrying JdbcClient delegate, RetryPolicy<Object> policy) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.policy = Objects.requireNonNull(policy, "policy is null");
    }

    @Override
    public boolean schemaExists(ConnectorSession session, String schema) {
        return (Boolean)RetryingModule.retry(this.policy, () -> this.delegate.schemaExists(session, schema));
    }

    @Override
    public Set<String> getSchemaNames(ConnectorSession session) {
        return (Set)RetryingModule.retry(this.policy, () -> this.delegate.getSchemaNames(session));
    }

    @Override
    public List<SchemaTableName> getTableNames(ConnectorSession session, Optional<String> schema) {
        return (List)RetryingModule.retry(this.policy, () -> this.delegate.getTableNames(session, schema));
    }

    @Override
    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        return (Optional)RetryingModule.retry(this.policy, () -> this.delegate.getTableHandle(session, schemaTableName));
    }

    @Override
    public JdbcTableHandle getTableHandle(ConnectorSession session, PreparedQuery preparedQuery) {
        return (JdbcTableHandle)RetryingModule.retry(this.policy, () -> this.delegate.getTableHandle(session, preparedQuery));
    }

    @Override
    public JdbcProcedureHandle getProcedureHandle(ConnectorSession session, JdbcProcedureHandle.ProcedureQuery procedureQuery) {
        return (JdbcProcedureHandle)RetryingModule.retry(this.policy, () -> this.delegate.getProcedureHandle(session, procedureQuery));
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        return (List)RetryingModule.retry(this.policy, () -> this.delegate.getColumns(session, tableHandle));
    }

    @Override
    public Iterator<RelationColumnsMetadata> getAllTableColumns(ConnectorSession session, Optional<String> schema) {
        return (Iterator)RetryingModule.retry(this.policy, () -> this.delegate.getAllTableColumns(session, schema));
    }

    @Override
    public List<RelationCommentMetadata> getAllTableComments(ConnectorSession session, Optional<String> schema) {
        return (List)RetryingModule.retry(this.policy, () -> this.delegate.getAllTableComments(session, schema));
    }

    @Override
    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        return this.delegate.toColumnMapping(session, connection, typeHandle);
    }

    @Override
    public List<ColumnMapping> toColumnMappings(ConnectorSession session, List<JdbcTypeHandle> typeHandles) {
        return (List)RetryingModule.retry(this.policy, () -> this.delegate.toColumnMappings(session, typeHandles));
    }

    @Override
    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        return (WriteMapping)RetryingModule.retry(this.policy, () -> this.delegate.toWriteMapping(session, type));
    }

    @Override
    public Optional<Type> getSupportedType(ConnectorSession session, Type type) {
        return this.delegate.getSupportedType(session, type);
    }

    @Override
    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return this.delegate.supportsAggregationPushdown(session, table, aggregates, assignments, groupingSets);
    }

    @Override
    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.delegate.implementAggregation(session, aggregate, assignments);
    }

    @Override
    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.delegate.convertPredicate(session, expression, assignments);
    }

    @Override
    public Optional<JdbcExpression> convertProjection(ConnectorSession session, JdbcTableHandle handle, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.delegate.convertProjection(session, handle, expression, assignments);
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcTableHandle tableHandle) {
        return (ConnectorSplitSource)RetryingModule.retry(this.policy, () -> this.delegate.getSplits(session, tableHandle));
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcProcedureHandle procedureHandle) {
        return (ConnectorSplitSource)RetryingModule.retry(this.policy, () -> this.delegate.getSplits(session, procedureHandle));
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split, JdbcTableHandle tableHandle) throws SQLException {
        return this.delegate.getConnection(session, split, tableHandle);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split, JdbcProcedureHandle procedureHandle) throws SQLException {
        return this.delegate.getConnection(session, split, procedureHandle);
    }

    @Override
    public void abortReadConnection(Connection connection, ResultSet resultSet) throws SQLException {
        this.delegate.abortReadConnection(connection, resultSet);
    }

    @Override
    public PreparedQuery prepareQuery(ConnectorSession session, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, ParameterizedExpression> columnExpressions) {
        return this.delegate.prepareQuery(session, table, groupingSets, columns, columnExpressions);
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        return this.delegate.buildSql(session, connection, split, table, columns);
    }

    @Override
    public CallableStatement buildProcedure(ConnectorSession session, Connection connection, JdbcSplit split, JdbcProcedureHandle procedureHandle) throws SQLException {
        return this.delegate.buildProcedure(session, connection, split, procedureHandle);
    }

    @Override
    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions, JoinStatistics statistics) {
        return this.delegate.implementJoin(session, joinType, leftSource, leftProjections, rightSource, rightProjections, joinConditions, statistics);
    }

    @Override
    public Optional<PreparedQuery> legacyImplementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        return this.delegate.legacyImplementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics);
    }

    @Override
    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        return this.delegate.supportsTopN(session, handle, sortOrder);
    }

    @Override
    public boolean isTopNGuaranteed(ConnectorSession session) {
        return this.delegate.isTopNGuaranteed(session);
    }

    @Override
    public boolean supportsLimit() {
        return this.delegate.supportsLimit();
    }

    @Override
    public boolean isLimitGuaranteed(ConnectorSession session) {
        return this.delegate.isLimitGuaranteed(session);
    }

    @Override
    public Optional<String> getTableComment(ResultSet resultSet) throws SQLException {
        return this.delegate.getTableComment(resultSet);
    }

    @Override
    public void setTableComment(ConnectorSession session, JdbcTableHandle handle, Optional<String> comment) {
        RetryingModule.retry(this.policy, () -> this.delegate.setTableComment(session, handle, comment));
    }

    @Override
    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        RetryingModule.retry(this.policy, () -> this.delegate.setColumnComment(session, handle, column, comment));
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        this.delegate.addColumn(session, handle, column);
    }

    @Override
    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        this.delegate.dropColumn(session, handle, column);
    }

    @Override
    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        this.delegate.renameColumn(session, handle, jdbcColumn, newColumnName);
    }

    @Override
    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        this.delegate.setColumnType(session, handle, column, type);
    }

    @Override
    public void dropNotNullConstraint(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        this.delegate.dropNotNullConstraint(session, handle, column);
    }

    @Override
    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        this.delegate.renameTable(session, handle, newTableName);
    }

    @Override
    public void setTableProperties(ConnectorSession session, JdbcTableHandle handle, Map<String, Optional<Object>> properties) {
        this.delegate.setTableProperties(session, handle, properties);
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.delegate.createTable(session, tableMetadata);
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.delegate.beginCreateTable(session, tableMetadata);
    }

    @Override
    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle, Set<Long> pageSinkIds) {
        this.delegate.commitCreateTable(session, handle, pageSinkIds);
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        return this.delegate.beginInsertTable(session, tableHandle, columns);
    }

    @Override
    public void finishInsertTable(ConnectorSession session, JdbcOutputTableHandle handle, Set<Long> pageSinkIds) {
        this.delegate.finishInsertTable(session, handle, pageSinkIds);
    }

    @Override
    public void dropTable(ConnectorSession session, JdbcTableHandle jdbcTableHandle) {
        this.delegate.dropTable(session, jdbcTableHandle);
    }

    @Override
    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.delegate.rollbackCreateTable(session, handle);
    }

    @Override
    public boolean supportsRetries() {
        return this.delegate.supportsRetries();
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        return this.delegate.buildInsertSql(handle, columnWriters);
    }

    @Override
    public Connection getConnection(ConnectorSession session) throws SQLException {
        return this.delegate.getConnection(session);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        return this.delegate.getConnection(session, handle);
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql, Optional<Integer> columnCount) throws SQLException {
        return this.delegate.getPreparedStatement(connection, sql, columnCount);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        return (TableStatistics)RetryingModule.retry(this.policy, () -> this.delegate.getTableStatistics(session, handle));
    }

    @Override
    public void createSchema(ConnectorSession session, String schemaName) {
        this.delegate.createSchema(session, schemaName);
    }

    @Override
    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        this.delegate.dropSchema(session, schemaName, cascade);
    }

    @Override
    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        this.delegate.renameSchema(session, schemaName, newSchemaName);
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.delegate.getSystemTable(session, tableName);
    }

    @Override
    public String quoted(String name) {
        return this.delegate.quoted(name);
    }

    @Override
    public String quoted(RemoteTableName remoteTableName) {
        return this.delegate.quoted(remoteTableName);
    }

    @Override
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        return (Map)RetryingModule.retry(this.policy, () -> this.delegate.getTableProperties(session, tableHandle));
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> getTableScanRedirection(ConnectorSession session, JdbcTableHandle tableHandle) {
        return (Optional)RetryingModule.retry(this.policy, () -> this.delegate.getTableScanRedirection(session, tableHandle));
    }

    @Override
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        return this.delegate.delete(session, handle);
    }

    @Override
    public void truncateTable(ConnectorSession session, JdbcTableHandle handle) {
        this.delegate.truncateTable(session, handle);
    }

    @Override
    public OptionalLong update(ConnectorSession session, JdbcTableHandle handle) {
        return this.delegate.update(session, handle);
    }

    @Override
    public OptionalInt getMaxWriteParallelism(ConnectorSession session) {
        return (OptionalInt)RetryingModule.retry(this.policy, () -> this.delegate.getMaxWriteParallelism(session));
    }

    @Override
    public OptionalInt getMaxColumnNameLength(ConnectorSession session) {
        return (OptionalInt)RetryingModule.retry(this.policy, () -> this.delegate.getMaxColumnNameLength(session));
    }
}

