/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.Session;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.sql.SqlExecutor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public abstract class BaseJdbcCastPushdownTest
extends AbstractTestQueryFramework {
    protected abstract String leftTable();

    protected abstract String rightTable();

    protected abstract SqlExecutor onRemoteDatabase();

    protected abstract List<CastTestCase> supportedCastTypePushdown();

    protected abstract List<CastTestCase> unsupportedCastTypePushdown();

    protected abstract List<InvalidCastTestCase> invalidCast();

    @Test
    public void testProjectionPushdownWithCast() {
        for (CastTestCase testCase : this.supportedCastTypePushdown()) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(%s AS %s) FROM %s".formatted(testCase.sourceColumn(), testCase.castType(), this.leftTable())))).isFullyPushedDown();
        }
        for (CastTestCase testCase : this.unsupportedCastTypePushdown()) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(%s AS %s) FROM %s".formatted(testCase.sourceColumn(), testCase.castType(), this.leftTable())))).isNotFullyPushedDown(ProjectNode.class, new Class[0]);
        }
    }

    @Test
    public void testJoinPushdownWithCast() {
        for (CastTestCase testCase : this.supportedCastTypePushdown()) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT l.id FROM %s l JOIN %s r ON CAST(l.%s AS %s) = r.%s".formatted(this.leftTable(), this.rightTable(), testCase.sourceColumn(), testCase.castType(), testCase.targetColumn())))).isFullyPushedDown();
        }
        for (CastTestCase testCase : this.unsupportedCastTypePushdown()) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT l.id FROM %s l JOIN %s r ON CAST(l.%s AS %s) = r.%s".formatted(this.leftTable(), this.rightTable(), testCase.sourceColumn(), testCase.castType(), testCase.targetColumn())))).joinIsNotFullyPushedDown();
        }
    }

    @Test
    public void testInvalidCast() {
        this.assertInvalidCast(this.leftTable(), this.invalidCast());
    }

    protected void assertInvalidCast(String tableName, List<InvalidCastTestCase> invalidCastTestCases) {
        Session withoutPushdown = Session.builder((Session)this.getSession()).setSystemProperty("allow_pushdown_into_connectors", "false").build();
        for (InvalidCastTestCase testCase : invalidCastTestCases) {
            if (testCase.pushdownErrorMessage().isPresent()) {
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(%s AS %s) FROM %s".formatted(testCase.sourceColumn(), testCase.castType(), tableName)))).failure().hasMessageMatching(testCase.pushdownErrorMessage().get());
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(withoutPushdown, "SELECT CAST(%s AS %s) FROM %s".formatted(testCase.sourceColumn(), testCase.castType(), tableName)))).failure().hasMessageMatching(testCase.errorMessage());
                continue;
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(%s AS %s) FROM %s".formatted(testCase.sourceColumn(), testCase.castType(), tableName)))).failure().hasMessageMatching(testCase.errorMessage());
        }
    }

    public record CastTestCase(String sourceColumn, String castType, String targetColumn) {
        public CastTestCase {
            Objects.requireNonNull(sourceColumn, "sourceColumn is null");
            Objects.requireNonNull(castType, "castType is null");
            Objects.requireNonNull(targetColumn, "targetColumn is null");
        }
    }

    public record InvalidCastTestCase(String sourceColumn, String castType, String errorMessage, Optional<String> pushdownErrorMessage) {
        public InvalidCastTestCase(String sourceColumn, String castType) {
            this(sourceColumn, castType, "(.*)Cannot cast (.*) to (.*)");
        }

        public InvalidCastTestCase(String sourceColumn, String castType, String errorMessage) {
            this(sourceColumn, castType, errorMessage, Optional.empty());
        }

        public InvalidCastTestCase(String sourceColumn, String castType, String errorMessage, @Language(value="RegExp") String pushdownErrorMessage) {
            this(sourceColumn, castType, errorMessage, Optional.of(pushdownErrorMessage));
        }

        public InvalidCastTestCase {
            Objects.requireNonNull(sourceColumn, "sourceColumn is null");
            Objects.requireNonNull(castType, "castType is null");
            Objects.requireNonNull(errorMessage, "errorMessage is null");
            Objects.requireNonNull(pushdownErrorMessage, "pushdownErrorMessage is null");
        }
    }
}

