/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.operator.RetryPolicy;
import io.trino.testing.BaseFailureRecoveryTest;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class BaseJdbcFailureRecoveryTest
extends BaseFailureRecoveryTest {
    public BaseJdbcFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    @Test
    protected void testAnalyzeTable() {
        Assertions.assertThatThrownBy(() -> super.testAnalyzeTable()).hasMessageMatching("This connector does not support analyze");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testDelete() {
        Optional<String> setupQuery = Optional.of("CREATE TABLE <table> AS SELECT * FROM orders");
        String testQuery = "DELETE FROM <table> WHERE orderkey = 1";
        Optional<String> cleanupQuery = Optional.of("DROP TABLE <table>");
        this.assertThatQuery(testQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).isCoordinatorOnly();
    }

    @Test
    protected void testDeleteWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testDeleteWithSubquery()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testRefreshMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testRefreshMaterializedView()).hasMessageContaining("This connector does not support creating materialized views");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testUpdate() {
        Assertions.assertThatThrownBy(() -> super.testUpdate()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testUpdateWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testUpdateWithSubquery()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    @Test
    protected void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessageContaining("This connector does not support modifying table rows");
        Assumptions.abort((String)"skipped");
    }

    protected boolean areWriteRetriesSupported() {
        return true;
    }
}

