/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.jdbc.BaseJdbcConnectorTest;
import io.trino.plugin.jdbc.H2QueryRunner;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.sql.JdbcSqlExecutor;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestJdbcConnectorTest
extends BaseJdbcConnectorTest {
    private Map<String, String> properties;

    protected QueryRunner createQueryRunner() throws Exception {
        this.properties = ImmutableMap.builder().putAll(TestingH2JdbcModule.createProperties()).buildOrThrow();
        return H2QueryRunner.createH2QueryRunner(REQUIRED_TPCH_TABLES, this.properties);
    }

    @Override
    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_COMMENT, TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_ARRAY, TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN, TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE, TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT, TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT, TestingConnectorBehavior.SUPPORTS_LIMIT_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_MAP_TYPE, TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS, TestingConnectorBehavior.SUPPORTS_ROW_TYPE, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testLargeIn() {
    }

    protected TestTable createTableWithDefaultColumns() {
        return new TestTable((SqlExecutor)this.onRemoteDatabase(), "tpch.table", "(col_required BIGINT NOT NULL,col_nullable BIGINT,col_default BIGINT DEFAULT 43,col_nonnull_default BIGINT NOT NULL DEFAULT 42,col_required2 BIGINT NOT NULL)");
    }

    @Override
    protected TestTable createTableWithUnsupportedColumn() {
        return new TestTable((SqlExecutor)this.onRemoteDatabase(), "tpch.test_unsupported_column_present", "(one bigint, two geometry, three varchar(10))");
    }

    protected Optional<BaseConnectorTest.DataMappingTestSetup> filterDataMappingSmokeTestData(BaseConnectorTest.DataMappingTestSetup dataMappingTestSetup) {
        String typeBaseName;
        switch (typeBaseName = dataMappingTestSetup.getTrinoTypeName().replaceAll("\\([^()]*\\)", "")) {
            case "boolean": 
            case "decimal": 
            case "varbinary": 
            case "time": 
            case "timestamp": 
            case "timestamp with time zone": {
                return Optional.of(dataMappingTestSetup.asUnsupported());
            }
        }
        return Optional.of(dataMappingTestSetup);
    }

    @Test
    public void testDeleteWithLike() {
        Assertions.assertThatThrownBy(() -> super.testDeleteWithLike()).hasStackTraceContaining("TrinoException: This connector does not support modifying table rows");
    }

    @Test
    public void testUnknownTypeAsIgnored() {
        try (TestTable table = new TestTable((SqlExecutor)this.onRemoteDatabase(), "tpch.test_failure_on_unknown_type_as_ignored", "(int_column int, geometry_column GEOMETRY)", (List)ImmutableList.of((Object)"1, NULL", (Object)"2, 'POINT(7 52)'"));){
            Session ignoreUnsupportedType = this.unsupportedTypeHandling(UnsupportedTypeHandling.IGNORE);
            this.assertQuery(ignoreUnsupportedType, "SELECT int_column FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery(ignoreUnsupportedType, "SELECT * FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery(ignoreUnsupportedType, "SELECT column_name, data_type FROM information_schema.columns WHERE table_name LIKE 'test_failure_on_unknown_type_as_ignored%'", "VALUES ('int_column', 'integer')");
            this.assertQuery(ignoreUnsupportedType, "DESCRIBE " + table.getName(), "VALUES ('int_column', 'integer', '', '')");
            this.assertUpdate(ignoreUnsupportedType, String.format("INSERT INTO %s (int_column) VALUES (3)", table.getName()), 1L);
            this.assertQuery(ignoreUnsupportedType, "SELECT * FROM " + table.getName(), "VALUES 1, 2, 3");
        }
    }

    @Test
    public void testUnknownTypeAsVarchar() {
        try (TestTable table = new TestTable((SqlExecutor)this.onRemoteDatabase(), "tpch.test_failure_on_unknown_type_as_varchar", "(int_column int, geometry_column GEOMETRY)", (List)ImmutableList.of((Object)"1, NULL", (Object)"2, 'POINT(7 52)'"));){
            Session convertToVarcharUnsupportedTypes = this.unsupportedTypeHandling(UnsupportedTypeHandling.CONVERT_TO_VARCHAR);
            this.assertQuery(convertToVarcharUnsupportedTypes, "SELECT int_column FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery(convertToVarcharUnsupportedTypes, "SELECT * FROM " + table.getName(), "VALUES (1, NULL), (2, 'POINT (7 52)')");
            this.assertQuery(convertToVarcharUnsupportedTypes, String.format("SELECT int_column FROM %s WHERE geometry_column = 'POINT (7 52)'", table.getName()), "VALUES 2");
            this.assertQuery(convertToVarcharUnsupportedTypes, String.format("SELECT int_column FROM %s WHERE geometry_column = 'invalid data'", table.getName()), "SELECT 1 WHERE false");
            this.assertQuery(convertToVarcharUnsupportedTypes, "SELECT column_name, data_type FROM information_schema.columns WHERE table_name LIKE 'test_failure_on_unknown_type_as_varchar%'", "VALUES ('int_column', 'integer'), ('geometry_column', 'varchar')");
            this.assertQuery(convertToVarcharUnsupportedTypes, "DESCRIBE " + table.getName(), "VALUES ('int_column', 'integer', '', ''), ('geometry_column', 'varchar', '','')");
            this.assertUpdate(convertToVarcharUnsupportedTypes, String.format("INSERT INTO %s (int_column) VALUES (3)", table.getName()), 1L);
            this.assertQueryFails(convertToVarcharUnsupportedTypes, String.format("INSERT INTO %s (int_column, geometry_column) VALUES (3, 'POINT (7 52)')", table.getName()), "Underlying type that is mapped to VARCHAR is not supported for INSERT: GEOMETRY");
            this.assertQuery(convertToVarcharUnsupportedTypes, "SELECT * FROM " + table.getName(), "VALUES (1, NULL), (2, 'POINT (7 52)'), (3, NULL)");
        }
    }

    @Test
    public void testTableWithOnlyUnsupportedColumns() {
        Session session = Session.builder((Session)this.getSession()).setSchema("public").build();
        try (TestTable table = new TestTable((SqlExecutor)this.onRemoteDatabase(), "unsupported_table", "(geometry_column GEOMETRY)", (List)ImmutableList.of((Object)"NULL", (Object)"'POINT(7 52)'"));){
            Assertions.assertThat((Stream)this.getQueryRunner().execute("SELECT table_name FROM information_schema.tables").getOnlyColumn()).contains(new Object[]{table.getName()});
            this.assertQuery(String.format("SELECT count(*) FROM information_schema.tables WHERE table_name = '%s'", table.getName()), "SELECT 1");
            this.assertQuery(String.format("SELECT count(*) FROM information_schema.columns WHERE table_name = '%s'", table.getName()), "SELECT 0");
            this.assertQuery(session, String.format("SHOW TABLES LIKE '%s'", table.getName()), String.format("SELECT '%s'", table.getName()));
            String unsupportedTableErrorMessage = "Table 'public.*' has no supported columns.*";
            this.assertQueryFails(session, "SELECT * FROM " + table.getName(), unsupportedTableErrorMessage);
            this.assertQueryFails(session, "SHOW CREATE TABLE " + table.getName(), unsupportedTableErrorMessage);
            this.assertQueryFails(session, "SHOW COLUMNS FROM " + table.getName(), unsupportedTableErrorMessage);
            this.assertQueryFails(session, "DESCRIBE " + table.getName(), unsupportedTableErrorMessage);
        }
    }

    @Override
    @Test
    public void testNativeQueryColumnAlias() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT region_name FROM TABLE(system.query(query => 'SELECT name AS region_name FROM %s.region WHERE regionkey = 0'))", this.getSession().getSchema().orElseThrow())))).matches("VALUES CAST('AFRICA' AS VARCHAR(25))");
    }

    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        return String.format("NULL not allowed for column \"%s\"(?s).*", columnName.toUpperCase(Locale.ENGLISH));
    }

    protected void verifyAddNotNullColumnToNonEmptyTableFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageContaining("NULL not allowed for column");
    }

    @Test
    public void testAddColumnConcurrently() {
        Assumptions.abort((String)"TODO: Enable this test after finding the failure cause");
    }

    protected void verifySetColumnTypeFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("(?s).*(Data conversion error converting|value out of range).*");
    }

    protected JdbcSqlExecutor onRemoteDatabase() {
        return new JdbcSqlExecutor(this.properties.get("connection-url"), new Properties());
    }

    private Session unsupportedTypeHandling(UnsupportedTypeHandling unsupportedTypeHandling) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("jdbc", "unsupported_type_handling", unsupportedTypeHandling.name()).build();
    }

    protected void verifyColumnNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("(?s)(.*The name that starts with .* is too long\\..*)");
    }

    protected void verifySchemaNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("(?s)(.*The name that starts with .* is too long\\..*)");
    }

    protected void verifyTableNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("(?s)(.*The name that starts with .* is too long\\..*)");
    }

    protected OptionalInt maxColumnNameLength() {
        return OptionalInt.of(256);
    }

    protected OptionalInt maxSchemaNameLength() {
        return OptionalInt.of(256);
    }

    protected OptionalInt maxTableNameLength() {
        return OptionalInt.of(256);
    }
}

