/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.base.mapping.RuleBasedIdentifierMappingUtils;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcPlugin;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.TestingConnectorContext;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

public class TestJdbcPlugin {
    @Test
    public void testCreateConnector() {
        TestJdbcPlugin.getConnectorFactory().create("test", TestingH2JdbcModule.createProperties(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testRuleBasedIdentifierCanBeUsedTogetherWithCacheBased() throws Exception {
        TestJdbcPlugin.getConnectorFactory().create("test", (Map)ImmutableMap.builder().putAll(TestingH2JdbcModule.createProperties()).put((Object)"case-insensitive-name-matching", (Object)"true").put((Object)"case-insensitive-name-matching.config-file", (Object)RuleBasedIdentifierMappingUtils.createRuleBasedIdentifierMappingFile().toFile().getAbsolutePath()).buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @RepeatedTest(value=100)
    void testConfigurationDoesNotLeakBetweenCatalogs() {
        TestingJdbcPlugin plugin = new TestingJdbcPlugin("test_jdbc", (Supplier<Module>)((Supplier)TestingJdbcModule::new));
        ConnectorFactory connectorFactory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        try (ExecutorService executor = Executors.newFixedThreadPool(2);){
            Future<Connector> pushDownEnabledFuture = executor.submit(() -> connectorFactory.create("catalogWithPushDownEnabled", (Map)ImmutableMap.of((Object)"connection-url", (Object)TestingH2JdbcModule.createH2ConnectionUrl(), (Object)"join-pushdown.enabled", (Object)"true"), (ConnectorContext)new TestingConnectorContext()));
            Future<Connector> pushDownDisabledFuture = executor.submit(() -> connectorFactory.create("catalogWithPushDownDisabled", (Map)ImmutableMap.of((Object)"connection-url", (Object)TestingH2JdbcModule.createH2ConnectionUrl(), (Object)"join-pushdown.enabled", (Object)"false"), (ConnectorContext)new TestingConnectorContext()));
            AtomicReference catalogWithPushDownEnabled = new AtomicReference();
            AtomicReference catalogWithPushDownDisabled = new AtomicReference();
            Assertions.assertThatCode(() -> {
                catalogWithPushDownEnabled.set((Connector)pushDownEnabledFuture.get());
                catalogWithPushDownDisabled.set((Connector)pushDownDisabledFuture.get());
            }).doesNotThrowAnyException();
            ((Connector)catalogWithPushDownEnabled.get()).shutdown();
            ((Connector)catalogWithPushDownDisabled.get()).shutdown();
        }
    }

    private static ConnectorFactory getConnectorFactory() {
        JdbcPlugin plugin = new JdbcPlugin("jdbc", TestingH2JdbcModule::new);
        return (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
    }

    private static class TestingJdbcPlugin
    extends JdbcPlugin {
        public TestingJdbcPlugin(String name, Supplier<Module> module) {
            super(name, module);
        }
    }

    private static class TestingJdbcModule
    extends AbstractConfigurationAwareModule {
        public static final String CATALOG_WITH_PUSH_DOWN_ENABLED = "catalogWithPushDownEnabled";
        public static final String CATALOG_WITH_PUSH_DOWN_DISABLED = "catalogWithPushDownDisabled";

        private TestingJdbcModule() {
        }

        protected void setup(Binder binder) {
            this.install(ConditionalModule.conditionalModule(JdbcMetadataConfig.class, JdbcMetadataConfig::isJoinPushdownEnabled, (Module)new ModuleCheckingThatPushDownCanBeEnabled()));
            this.install(new TestingH2JdbcModule());
        }
    }

    private static class PushDownCanBeEnabledChecker {
        @Inject
        public PushDownCanBeEnabledChecker(CatalogName catalogName) {
            if (!"catalogWithPushDownEnabled".equals(catalogName.toString())) {
                throw new RuntimeException("Catalog '%s' should not have push-down enabled".formatted(catalogName));
            }
        }
    }

    private static class ModuleCheckingThatPushDownCanBeEnabled
    implements Module {
        private ModuleCheckingThatPushDownCanBeEnabled() {
        }

        public void configure(Binder binder) {
            binder.bind(PushDownCanBeEnabledChecker.class).in(Scopes.SINGLETON);
        }
    }
}

