/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import dev.failsafe.function.CheckedRunnable;
import io.airlift.log.Logger;
import io.trino.plugin.base.TemporaryTables;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.mapping.RemoteIdentifiers;
import io.trino.plugin.jdbc.CaseSensitivity;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.JdbcAssignmentItem;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcQueryRelationHandle;
import io.trino.plugin.jdbc.JdbcRemoteIdentifiers;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.JdbcWriteSessionProperties;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnPosition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseJdbcClient
implements JdbcClient {
    private static final Logger log = Logger.get(BaseJdbcClient.class);
    static final Type TRINO_PAGE_SINK_ID_COLUMN_TYPE = BigintType.BIGINT;
    protected final ConnectionFactory connectionFactory;
    protected final QueryBuilder queryBuilder;
    protected final String identifierQuote;
    protected final Set<String> jdbcTypesMappedToVarchar;
    protected final RemoteQueryModifier queryModifier;
    private final IdentifierMapping identifierMapping;
    private final boolean supportsRetries;
    private final JdbcRemoteIdentifiers.JdbcRemoteIdentifiersFactory jdbcRemoteIdentifiersFactory = new JdbcRemoteIdentifiers.JdbcRemoteIdentifiersFactory(this);
    private Integer maxColumnNameLength;

    public BaseJdbcClient(String identifierQuote, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, Set<String> jdbcTypesMappedToVarchar, IdentifierMapping identifierMapping, RemoteQueryModifier remoteQueryModifier, boolean supportsRetries) {
        this.identifierQuote = Objects.requireNonNull(identifierQuote, "identifierQuote is null");
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
        this.queryBuilder = Objects.requireNonNull(queryBuilder, "queryBuilder is null");
        this.jdbcTypesMappedToVarchar = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).addAll((Iterable)Objects.requireNonNull(jdbcTypesMappedToVarchar, "jdbcTypesMappedToVarchar is null")).build();
        this.identifierMapping = Objects.requireNonNull(identifierMapping, "identifierMapping is null");
        this.queryModifier = Objects.requireNonNull(remoteQueryModifier, "remoteQueryModifier is null");
        this.supportsRetries = supportsRetries;
    }

    protected IdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public final Set<String> getSchemaNames(ConnectorSession session) {
        Set set;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                set = (Set)this.listSchemas(connection).stream().map(arg_0 -> ((IdentifierMapping)this.identifierMapping).fromRemoteSchemaName(arg_0)).collect(ImmutableSet.toImmutableSet());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return set;
    }

    public Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getSchemas(connection.getCatalog(), null);
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_SCHEM");
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    protected boolean filterSchema(String schemaName) {
        return !schemaName.equalsIgnoreCase("information_schema");
    }

    @Override
    public List<SchemaTableName> getTableNames(ConnectorSession session, Optional<String> schema) {
        return (List)this.getAllTableComments(session, schema).stream().map(RelationCommentMetadata::name).collect(ImmutableList.toImmutableList());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RelationCommentMetadata> getAllTableComments(ConnectorSession session, Optional<String> schema) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block17: {
                ConnectorIdentity identity = session.getIdentity();
                Optional<String> remoteSchema = schema.map(schemaName -> this.identifierMapping.toRemoteSchemaName(this.getRemoteIdentifiers(connection), identity, schemaName));
                if (remoteSchema.isPresent() && !this.filterSchema(remoteSchema.get())) {
                    ImmutableList immutableList2 = ImmutableList.of();
                    return immutableList2;
                }
                ResultSet resultSet = this.getTables(connection, remoteSchema, Optional.empty());
                try {
                    ImmutableList.Builder list = ImmutableList.builder();
                    while (resultSet.next()) {
                        String remoteSchemaFromResultSet = this.getTableSchemaName(resultSet);
                        String tableSchema = this.identifierMapping.fromRemoteSchemaName(remoteSchemaFromResultSet);
                        String tableName = this.identifierMapping.fromRemoteTableName(remoteSchemaFromResultSet, resultSet.getString("TABLE_NAME"));
                        if (!this.filterSchema(tableSchema)) continue;
                        list.add((Object)RelationCommentMetadata.forRelation((SchemaTableName)new SchemaTableName(tableSchema, tableName), this.getTableComment(resultSet)));
                    }
                    immutableList = list.build();
                    if (resultSet == null) break block17;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Optional<JdbcTableHandle> optional;
            block20: {
                ArrayList<JdbcTableHandle> tableHandles;
                ResultSet resultSet;
                block18: {
                    Optional<JdbcTableHandle> optional2;
                    block19: {
                        ConnectorIdentity identity = session.getIdentity();
                        RemoteIdentifiers remoteIdentifiers = this.getRemoteIdentifiers(connection);
                        String remoteSchema = this.identifierMapping.toRemoteSchemaName(remoteIdentifiers, identity, schemaTableName.getSchemaName());
                        String remoteTable = this.identifierMapping.toRemoteTableName(remoteIdentifiers, identity, remoteSchema, schemaTableName.getTableName());
                        resultSet = this.getTables(connection, Optional.of(remoteSchema), Optional.of(remoteTable));
                        try {
                            tableHandles = new ArrayList<JdbcTableHandle>();
                            while (resultSet.next()) {
                                tableHandles.add(new JdbcTableHandle(schemaTableName, BaseJdbcClient.getRemoteTable(resultSet), this.getTableComment(resultSet)));
                            }
                            if (!tableHandles.isEmpty()) break block18;
                            optional2 = Optional.empty();
                            if (resultSet == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return optional2;
                }
                if (tableHandles.size() > 1) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Multiple tables matched: " + String.valueOf(schemaTableName));
                }
                optional = Optional.of((JdbcTableHandle)Iterables.getOnlyElement(tableHandles));
                if (resultSet == null) break block20;
                resultSet.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public JdbcTableHandle getTableHandle(ConnectorSession session, PreparedQuery preparedQuery) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            JdbcTableHandle jdbcTableHandle;
            block15: {
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement(this, session, connection, preparedQuery, Optional.empty());
                try {
                    ResultSetMetaData metadata = preparedStatement.getMetaData();
                    if (metadata == null) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Query not supported: ResultSetMetaData not available for query: " + preparedQuery.query());
                    }
                    jdbcTableHandle = new JdbcTableHandle(new JdbcQueryRelationHandle(preparedQuery), (TupleDomain<ColumnHandle>)TupleDomain.all(), (List<ParameterizedExpression>)ImmutableList.of(), Optional.empty(), OptionalLong.empty(), Optional.of(this.getColumns(session, connection, metadata)), Optional.empty(), 0, Optional.empty(), (List<JdbcAssignmentItem>)ImmutableList.of());
                    if (preparedStatement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return jdbcTableHandle;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to get table handle for prepared query. " + String.valueOf(MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    @Override
    public JdbcProcedureHandle getProcedureHandle(ConnectorSession session, JdbcProcedureHandle.ProcedureQuery procedureQuery) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Procedure is not supported");
    }

    protected List<JdbcColumnHandle> getColumns(ConnectorSession session, Connection connection, ResultSetMetaData metadata) throws SQLException {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (int column = 1; column <= metadata.getColumnCount(); ++column) {
            String name = metadata.getColumnLabel(column);
            JdbcTypeHandle jdbcTypeHandle = new JdbcTypeHandle(metadata.getColumnType(column), Optional.ofNullable(metadata.getColumnTypeName(column)), Optional.of(metadata.getPrecision(column)), Optional.of(metadata.getScale(column)), Optional.empty(), Optional.of(metadata.isCaseSensitive(column) ? CaseSensitivity.CASE_SENSITIVE : CaseSensitivity.CASE_INSENSITIVE));
            Type type = this.toColumnMapping(session, connection, jdbcTypeHandle).orElseThrow(() -> new UnsupportedOperationException(String.format("Unsupported type: %s of column: %s", jdbcTypeHandle, name))).getType();
            columns.add((Object)new JdbcColumnHandle(name, jdbcTypeHandle, type));
        }
        return columns.build();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, SchemaTableName schemaTableName, RemoteTableName remoteTableName) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block16: {
                ResultSet resultSet = this.getColumns(remoteTableName, connection.getMetaData());
                try {
                    Map<String, CaseSensitivity> caseSensitivityMapping = this.getCaseSensitivityForColumns(session, connection, schemaTableName, remoteTableName);
                    int allColumns = 0;
                    ArrayList columns = new ArrayList();
                    while (resultSet.next()) {
                        if (!Objects.equals(remoteTableName, BaseJdbcClient.getRemoteTable(resultSet))) continue;
                        ++allColumns;
                        String columnName = resultSet.getString("COLUMN_NAME");
                        JdbcTypeHandle typeHandle = new JdbcTypeHandle(BaseJdbcClient.getInteger(resultSet, "DATA_TYPE").orElseThrow(() -> new IllegalStateException("DATA_TYPE is null")), Optional.ofNullable(resultSet.getString("TYPE_NAME")), BaseJdbcClient.getInteger(resultSet, "COLUMN_SIZE"), BaseJdbcClient.getInteger(resultSet, "DECIMAL_DIGITS"), Optional.empty(), Optional.ofNullable(caseSensitivityMapping.get(columnName)));
                        Optional<ColumnMapping> columnMapping = this.toColumnMapping(session, connection, typeHandle);
                        log.debug("Mapping data type of '%s' column '%s': %s mapped to %s", new Object[]{schemaTableName, columnName, typeHandle, columnMapping});
                        boolean nullable = resultSet.getInt("NULLABLE") != 0;
                        Optional<String> comment = Optional.ofNullable(Strings.emptyToNull((String)resultSet.getString("REMARKS")));
                        columnMapping.ifPresent(mapping -> columns.add(JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(typeHandle).setColumnType(mapping.getType()).setNullable(nullable).setComment(comment).build()));
                        if (!columnMapping.isEmpty()) continue;
                        UnsupportedTypeHandling unsupportedTypeHandling = TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling(session);
                        Verify.verify((unsupportedTypeHandling == UnsupportedTypeHandling.IGNORE ? 1 : 0) != 0, (String)"Unsupported type handling is set to %s, but toColumnMapping() returned empty for %s", (Object)((Object)unsupportedTypeHandling), (Object)typeHandle);
                    }
                    if (columns.isEmpty()) {
                        throw new TableNotFoundException(schemaTableName, String.format("Table '%s' has no supported columns (all %s columns are not supported)", schemaTableName, allColumns));
                    }
                    immutableList = ImmutableList.copyOf(columns);
                    if (resultSet == null) break block16;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public Iterator<RelationColumnsMetadata> getAllTableColumns(ConnectorSession session, Optional<String> schema) {
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            Connection connectionFinal = connection = this.connectionFactory.openConnection(session);
            Optional<String> remoteSchema = schema.map(name -> {
                RemoteIdentifiers remoteIdentifiers = this.getRemoteIdentifiers(connectionFinal);
                return this.identifierMapping.toRemoteSchemaName(remoteIdentifiers, session.getIdentity(), name);
            });
            if (remoteSchema.isPresent() && !this.filterSchema(remoteSchema.get())) {
                return Collections.emptyIterator();
            }
            ImmutableSet.Builder visibleTables = ImmutableSet.builder();
            try (ResultSet tablesResultSet = this.getTables(connection, remoteSchema, Optional.empty());){
                while (tablesResultSet.next()) {
                    if (!this.filterSchema(this.getTableSchemaName(tablesResultSet))) continue;
                    visibleTables.add((Object)BaseJdbcClient.getRemoteTable(tablesResultSet));
                }
            }
            resultSet = this.getAllTableColumns(connection, remoteSchema);
            return new IterateTableColumns(session, connection, (Set<RemoteTableName>)visibleTables.build(), resultSet);
        }
        catch (RuntimeException | SQLException e) {
            if (resultSet != null) {
                ResultSet resultSetFinal = resultSet;
                Connection connectionFinal = connection;
                BaseJdbcClient.cleanupSuppressing(e, () -> this.abortReadConnection(connectionFinal, resultSetFinal));
                BaseJdbcClient.cleanupSuppressing(e, resultSet::close);
            }
            if (connection != null) {
                BaseJdbcClient.cleanupSuppressing(e, connection::close);
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static void cleanupSuppressing(Throwable inflight, CheckedRunnable cleanup) {
        block3: {
            try {
                cleanup.run();
            }
            catch (Throwable cleanupException) {
                if (cleanupException instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (inflight == cleanupException) break block3;
                inflight.addSuppressed(cleanupException);
            }
        }
    }

    protected Map<String, CaseSensitivity> getCaseSensitivityForColumns(ConnectorSession session, Connection connection, SchemaTableName schemaTableName, RemoteTableName remoteTableName) {
        return ImmutableMap.of();
    }

    protected static Optional<Integer> getInteger(ResultSet resultSet, String columnLabel) throws SQLException {
        int value = resultSet.getInt(columnLabel);
        if (resultSet.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    protected ResultSet getColumns(RemoteTableName remoteTableName, DatabaseMetaData metadata) throws SQLException {
        return metadata.getColumns(remoteTableName.getCatalogName().orElse(null), this.escapeObjectNameForMetadataQuery(remoteTableName.getSchemaName(), metadata.getSearchStringEscape()).orElse(null), this.escapeObjectNameForMetadataQuery(remoteTableName.getTableName(), metadata.getSearchStringEscape()), null);
    }

    protected ResultSet getAllTableColumns(Connection connection, Optional<String> remoteSchemaName) throws SQLException {
        if (Boolean.TRUE.booleanValue()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The requested column listing mode is not supported");
        }
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getColumns(metadata.getConnection().getCatalog(), this.escapeObjectNameForMetadataQuery(remoteSchemaName, metadata.getSearchStringEscape()).orElse(null), null, null);
    }

    @Override
    public List<ColumnMapping> toColumnMappings(ConnectorSession session, List<JdbcTypeHandle> typeHandles) {
        List list;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                list = (List)typeHandles.stream().map(typeHandle -> this.toColumnMapping(session, connection, (JdbcTypeHandle)typeHandle).orElseThrow(() -> new VerifyException(String.format("Unsupported type handle %s", typeHandle)))).collect(ImmutableList.toImmutableList());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return list;
    }

    protected Optional<ColumnMapping> getForcedMappingToVarchar(JdbcTypeHandle typeHandle) {
        if (typeHandle.jdbcTypeName().isPresent() && this.jdbcTypesMappedToVarchar.contains(typeHandle.jdbcTypeName().get())) {
            return BaseJdbcClient.mapToUnboundedVarchar(typeHandle);
        }
        return Optional.empty();
    }

    protected static Optional<ColumnMapping> mapToUnboundedVarchar(JdbcTypeHandle typeHandle) {
        VarcharType unboundedVarcharType = VarcharType.createUnboundedVarcharType();
        return Optional.of(ColumnMapping.sliceMapping((Type)unboundedVarcharType, StandardColumnMappings.varcharReadFunction(unboundedVarcharType), (statement, index, value) -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Underlying type that is mapped to VARCHAR is not supported for INSERT: " + typeHandle.jdbcTypeName().get());
        }, PredicatePushdownController.DISABLE_PUSHDOWN));
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcTableHandle tableHandle) {
        return new FixedSplitSource((ConnectorSplit)new JdbcSplit(Optional.empty()));
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcProcedureHandle procedureHandle) {
        return new FixedSplitSource((ConnectorSplit)new JdbcSplit(Optional.empty()));
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split, JdbcTableHandle tableHandle) throws SQLException {
        Verify.verify((boolean)tableHandle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(tableHandle), (Object[])new Object[0]);
        return this.getConnection(session);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split, JdbcProcedureHandle procedureHandle) throws SQLException {
        return this.getConnection(session);
    }

    @Override
    public Connection getConnection(ConnectorSession session) throws SQLException {
        Connection connection = this.connectionFactory.openConnection(session);
        try {
            connection.setReadOnly(true);
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    @Override
    public PreparedQuery prepareQuery(ConnectorSession session, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, ParameterizedExpression> columnExpressions) {
        PreparedQuery preparedQuery;
        block8: {
            Verify.verify((boolean)table.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(table), (Object[])new Object[0]);
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                preparedQuery = this.prepareQuery(session, connection, table, groupingSets, columns, columnExpressions, Optional.empty());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return preparedQuery;
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        PreparedQuery preparedQuery = this.prepareQuery(session, connection, table, Optional.empty(), columns, (Map<String, ParameterizedExpression>)ImmutableMap.of(), Optional.of(split));
        return this.queryBuilder.prepareStatement(this, session, connection, preparedQuery, Optional.of(columns.size()));
    }

    @Override
    public CallableStatement buildProcedure(ConnectorSession session, Connection connection, JdbcSplit split, JdbcProcedureHandle procedureHandle) throws SQLException {
        return this.queryBuilder.callProcedure(this, session, connection, procedureHandle.getProcedureQuery());
    }

    protected PreparedQuery prepareQuery(ConnectorSession session, Connection connection, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, ParameterizedExpression> columnExpressions, Optional<JdbcSplit> split) {
        return this.applyQueryTransformations(table, this.queryBuilder.prepareSelectQuery(this, session, connection, table.getRelationHandle(), groupingSets, columns, columnExpressions, table.getConstraint(), BaseJdbcClient.getAdditionalPredicate(table.getConstraintExpressions(), split.flatMap(JdbcSplit::getAdditionalPredicate))));
    }

    protected static Optional<ParameterizedExpression> getAdditionalPredicate(List<ParameterizedExpression> constraintExpressions, Optional<String> splitPredicate) {
        if (constraintExpressions.isEmpty() && splitPredicate.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ParameterizedExpression(Stream.concat(constraintExpressions.stream().map(ParameterizedExpression::expression), splitPredicate.stream()).collect(Collectors.joining(") AND (", "(", ")")), (List)constraintExpressions.stream().flatMap(expressionRewrite -> expressionRewrite.parameters().stream()).collect(ImmutableList.toImmutableList())));
    }

    @Override
    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions, JoinStatistics statistics) {
        Optional<PreparedQuery> optional;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                optional = Optional.of(this.queryBuilder.prepareJoinQuery(this, session, connection, joinType, leftSource, leftProjections, rightSource, rightProjections, joinConditions));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return optional;
    }

    @Override
    @Deprecated
    public Optional<PreparedQuery> legacyImplementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        Optional<PreparedQuery> optional;
        block9: {
            for (JdbcJoinCondition joinCondition : joinConditions) {
                if (this.isSupportedJoinCondition(session, joinCondition)) continue;
                return Optional.empty();
            }
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                optional = Optional.of(this.queryBuilder.legacyPrepareJoinQuery(this, session, connection, joinType, leftSource, rightSource, joinConditions, leftAssignments, rightAssignments));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return optional;
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        return false;
    }

    protected PreparedQuery applyQueryTransformations(JdbcTableHandle tableHandle, PreparedQuery query) {
        PreparedQuery preparedQuery = query;
        if (tableHandle.getLimit().isPresent()) {
            preparedQuery = tableHandle.getSortOrder().isPresent() ? preparedQuery.transformQuery(this.applyTopN(tableHandle.getSortOrder().get(), tableHandle.getLimit().getAsLong())) : preparedQuery.transformQuery(this.applyLimit(tableHandle.getLimit().getAsLong()));
        }
        return preparedQuery;
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            if (this.shouldUseFaultTolerantExecution(session)) {
                this.createTable(session, tableMetadata);
                ColumnMetadata pageSinkIdColumn = BaseJdbcClient.getPageSinkIdColumn(tableMetadata.getColumns().stream().map(ColumnMetadata::getName).toList());
                return this.createTable(session, tableMetadata, TemporaryTables.generateTemporaryTableName((ConnectorSession)session), Optional.of(pageSinkIdColumn));
            }
            return this.createTable(session, tableMetadata, TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected JdbcOutputTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, String targetTableName) throws SQLException {
        return this.createTable(session, tableMetadata, targetTableName, Optional.empty());
    }

    protected JdbcOutputTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, String targetTableName, Optional<ColumnMetadata> pageSinkIdColumn) throws SQLException {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        ConnectorIdentity identity = session.getIdentity();
        if (!this.getSchemaNames(session).contains(schemaTableName.getSchemaName())) {
            throw new SchemaNotFoundException(schemaTableName.getSchemaName());
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            RemoteIdentifiers remoteIdentifiers = this.getRemoteIdentifiers(connection);
            String remoteSchema = this.identifierMapping.toRemoteSchemaName(remoteIdentifiers, identity, schemaTableName.getSchemaName());
            String remoteTable = this.identifierMapping.toRemoteTableName(remoteIdentifiers, identity, remoteSchema, schemaTableName.getTableName());
            String remoteTargetTableName = this.identifierMapping.toRemoteTableName(remoteIdentifiers, identity, remoteSchema, targetTableName);
            String catalog = connection.getCatalog();
            this.verifyTableName(connection.getMetaData(), remoteTargetTableName);
            JdbcOutputTableHandle jdbcOutputTableHandle = this.createTable(session, connection, tableMetadata, remoteIdentifiers, catalog, remoteSchema, remoteTable, remoteTargetTableName, pageSinkIdColumn);
            return jdbcOutputTableHandle;
        }
    }

    protected JdbcOutputTableHandle createTable(ConnectorSession session, Connection connection, ConnectorTableMetadata tableMetadata, RemoteIdentifiers remoteIdentifiers, String catalog, String remoteSchema, String remoteTable, String remoteTargetTableName, Optional<ColumnMetadata> pageSinkIdColumn) throws SQLException {
        List columns = tableMetadata.getColumns();
        ImmutableList.Builder columnNames = ImmutableList.builderWithExpectedSize((int)columns.size());
        ImmutableList.Builder columnTypes = ImmutableList.builderWithExpectedSize((int)columns.size());
        ImmutableList.Builder columnList = ImmutableList.builderWithExpectedSize((int)(columns.size() + (pageSinkIdColumn.isPresent() ? 1 : 0)));
        for (ColumnMetadata column : columns) {
            String columnName = this.identifierMapping.toRemoteColumnName(remoteIdentifiers, column.getName());
            this.verifyColumnName(connection.getMetaData(), columnName);
            columnNames.add((Object)columnName);
            columnTypes.add((Object)column.getType());
            columnList.add((Object)this.getColumnDefinitionSql(session, column, columnName));
        }
        Optional<String> pageSinkIdColumnName = Optional.empty();
        if (pageSinkIdColumn.isPresent()) {
            String columnName = this.identifierMapping.toRemoteColumnName(remoteIdentifiers, pageSinkIdColumn.get().getName());
            pageSinkIdColumnName = Optional.of(columnName);
            this.verifyColumnName(connection.getMetaData(), columnName);
            columnList.add((Object)this.getColumnDefinitionSql(session, pageSinkIdColumn.get(), columnName));
        }
        RemoteTableName remoteTableName = new RemoteTableName(Optional.ofNullable(catalog), Optional.ofNullable(remoteSchema), remoteTargetTableName);
        for (String sql : this.createTableSqls(remoteTableName, (List<String>)columnList.build(), tableMetadata)) {
            this.execute(session, connection, sql);
        }
        return new JdbcOutputTableHandle(new RemoteTableName(Optional.ofNullable(catalog), Optional.ofNullable(remoteSchema), remoteTable), (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.empty(), Optional.of(remoteTargetTableName), pageSinkIdColumnName);
    }

    protected List<String> createTableSqls(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        if (tableMetadata.getComment().isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with table comment");
        }
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        return ImmutableList.of((Object)String.format("CREATE TABLE %s (%s)", this.quoted(remoteTableName), String.join((CharSequence)", ", columns)));
    }

    protected String getColumnDefinitionSql(ConnectorSession session, ColumnMetadata column, String columnName) {
        if (column.getComment() != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with column comment");
        }
        StringBuilder sb = new StringBuilder().append(this.quoted(columnName)).append(" ").append(this.toWriteMapping(session, column.getType()).getDataType());
        if (!column.isNullable()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        JdbcOutputTableHandle jdbcOutputTableHandle;
        block8: {
            SchemaTableName schemaTableName = tableHandle.asPlainTable().getSchemaTableName();
            ConnectorIdentity identity = session.getIdentity();
            Verify.verify((boolean)tableHandle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(tableHandle), (Object[])new Object[0]);
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                Verify.verify((boolean)connection.getAutoCommit());
                RemoteIdentifiers remoteIdentifiers = this.getRemoteIdentifiers(connection);
                String remoteSchema = this.identifierMapping.toRemoteSchemaName(remoteIdentifiers, identity, schemaTableName.getSchemaName());
                String remoteTable = this.identifierMapping.toRemoteTableName(remoteIdentifiers, identity, remoteSchema, schemaTableName.getTableName());
                String catalog = connection.getCatalog();
                jdbcOutputTableHandle = this.beginInsertTable(session, connection, remoteIdentifiers, catalog, remoteSchema, remoteTable, columns);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return jdbcOutputTableHandle;
    }

    protected JdbcOutputTableHandle beginInsertTable(ConnectorSession session, Connection connection, RemoteIdentifiers remoteIdentifiers, String catalog, String remoteSchema, String remoteTable, List<JdbcColumnHandle> columns) throws SQLException {
        ConnectorIdentity identity = session.getIdentity();
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        ImmutableList.Builder jdbcColumnTypes = ImmutableList.builder();
        for (JdbcColumnHandle column2 : columns) {
            columnNames.add((Object)column2.getColumnName());
            columnTypes.add((Object)column2.getColumnType());
            jdbcColumnTypes.add((Object)column2.getJdbcTypeHandle());
        }
        if (JdbcWriteSessionProperties.isNonTransactionalInsert(session)) {
            return new JdbcOutputTableHandle(new RemoteTableName(Optional.ofNullable(catalog), Optional.ofNullable(remoteSchema), remoteTable), (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.of(jdbcColumnTypes.build()), Optional.empty(), Optional.empty());
        }
        String remoteTemporaryTableName = this.identifierMapping.toRemoteTableName(remoteIdentifiers, identity, remoteSchema, TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
        this.copyTableSchema(session, connection, catalog, remoteSchema, remoteTable, remoteTemporaryTableName, (List<String>)columnNames.build());
        Optional<Object> pageSinkIdColumn = Optional.empty();
        if (this.shouldUseFaultTolerantExecution(session)) {
            pageSinkIdColumn = Optional.of(BaseJdbcClient.getPageSinkIdColumn((List<String>)columnNames.build()));
            this.addColumn(session, connection, new RemoteTableName(Optional.ofNullable(catalog), Optional.ofNullable(remoteSchema), remoteTemporaryTableName), (ColumnMetadata)pageSinkIdColumn.get());
        }
        return new JdbcOutputTableHandle(new RemoteTableName(Optional.ofNullable(catalog), Optional.ofNullable(remoteSchema), remoteTable), (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.of(jdbcColumnTypes.build()), Optional.of(remoteTemporaryTableName), pageSinkIdColumn.map(column -> this.identifierMapping.toRemoteColumnName(remoteIdentifiers, column.getName())));
    }

    protected void copyTableSchema(ConnectorSession session, Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String sql = String.format("CREATE TABLE %s AS SELECT %s FROM %s WHERE 0 = 1", this.quoted(catalogName, schemaName, newTableName), columnNames.stream().map(this::quoted).collect(Collectors.joining(", ")), this.quoted(catalogName, schemaName, tableName));
        try {
            this.execute(session, connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle, Set<Long> pageSinkIds) {
        if (handle.getPageSinkIdColumnName().isPresent()) {
            this.finishInsertTable(session, handle, pageSinkIds);
        } else {
            this.renameTable(session, handle.getRemoteTableName().getCatalogName().orElse(null), handle.getRemoteTableName().getSchemaName().orElse(null), handle.getTemporaryTableName().orElseThrow(() -> new IllegalStateException("Temporary table name missing")), handle.getRemoteTableName().getSchemaTableName());
        }
    }

    @Override
    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        this.renameTable(session, remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName(), newTableName);
    }

    protected void renameTable(ConnectorSession session, String catalogName, String remoteSchemaName, String remoteTableName, SchemaTableName newTable) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            String newSchemaName = newTable.getSchemaName();
            String newTableName = newTable.getTableName();
            this.verifyTableName(connection.getMetaData(), newTableName);
            ConnectorIdentity identity = session.getIdentity();
            RemoteIdentifiers remoteIdentifiers = this.getRemoteIdentifiers(connection);
            String newRemoteSchemaName = this.identifierMapping.toRemoteSchemaName(remoteIdentifiers, identity, newSchemaName);
            String newRemoteTableName = this.identifierMapping.toRemoteTableName(remoteIdentifiers, identity, newRemoteSchemaName, newTableName);
            this.renameTable(session, connection, catalogName, remoteSchemaName, remoteTableName, newRemoteSchemaName, newRemoteTableName);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void renameTable(ConnectorSession session, Connection connection, String catalogName, String remoteSchemaName, String remoteTableName, String newRemoteSchemaName, String newRemoteTableName) throws SQLException {
        this.execute(session, connection, String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, remoteSchemaName, remoteTableName), this.quoted(catalogName, newRemoteSchemaName, newRemoteTableName)));
    }

    private RemoteTableName constructPageSinkIdsTable(ConnectorSession session, Connection connection, JdbcOutputTableHandle handle, Set<Long> pageSinkIds, Closer closer) throws SQLException {
        Verify.verify((boolean)handle.getPageSinkIdColumnName().isPresent(), (String)"Output table handle's pageSinkIdColumn is empty", (Object[])new Object[0]);
        RemoteTableName pageSinkTable = new RemoteTableName(handle.getRemoteTableName().getCatalogName(), handle.getRemoteTableName().getSchemaName(), TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
        int maxBatchSize = JdbcWriteSessionProperties.getWriteBatchSize(session);
        String pageSinkIdColumnName = handle.getPageSinkIdColumnName().get();
        String pageSinkTableSql = String.format("CREATE TABLE %s (%s)", this.quoted(pageSinkTable), this.getColumnDefinitionSql(session, new ColumnMetadata(pageSinkIdColumnName, TRINO_PAGE_SINK_ID_COLUMN_TYPE), pageSinkIdColumnName));
        String pageSinkInsertSql = String.format("INSERT INTO %s (%s) VALUES (?)", this.quoted(pageSinkTable), pageSinkIdColumnName);
        pageSinkInsertSql = this.queryModifier.apply(session, pageSinkInsertSql);
        LongWriteFunction pageSinkIdWriter = (LongWriteFunction)this.toWriteMapping(session, TRINO_PAGE_SINK_ID_COLUMN_TYPE).getWriteFunction();
        this.execute(session, connection, pageSinkTableSql);
        closer.register(() -> this.dropTable(session, pageSinkTable, true));
        try (PreparedStatement statement = connection.prepareStatement(pageSinkInsertSql);){
            int batchSize = 0;
            for (Long pageSinkId : pageSinkIds) {
                pageSinkIdWriter.set(statement, 1, pageSinkId);
                statement.addBatch();
                if (++batchSize < maxBatchSize) continue;
                statement.executeBatch();
                batchSize = 0;
            }
            if (batchSize > 0) {
                statement.executeBatch();
            }
        }
        return pageSinkTable;
    }

    @Override
    public void finishInsertTable(ConnectorSession session, JdbcOutputTableHandle handle, Set<Long> pageSinkIds) {
        if (JdbcWriteSessionProperties.isNonTransactionalInsert(session)) {
            Preconditions.checkState((boolean)handle.getTemporaryTableName().isEmpty(), (Object)"Unexpected use of temporary table when non transactional inserts are enabled");
            return;
        }
        RemoteTableName temporaryTable = new RemoteTableName(handle.getRemoteTableName().getCatalogName(), handle.getRemoteTableName().getSchemaName(), handle.getTemporaryTableName().orElseThrow());
        Closer closer = Closer.create();
        closer.register(() -> this.dropTable(session, temporaryTable, true));
        try (Connection connection = this.getConnection(session, handle);){
            Verify.verify((boolean)connection.getAutoCommit());
            String columns = handle.getColumnNames().stream().map(this::quoted).collect(Collectors.joining(", "));
            Object insertSql = String.format("INSERT INTO %s (%s) SELECT %s FROM %s temp_table", this.postProcessInsertTableNameClause(session, this.quoted(handle.getRemoteTableName())), columns, columns, this.quoted(temporaryTable));
            if (handle.getPageSinkIdColumnName().isPresent()) {
                RemoteTableName pageSinkTable = this.constructPageSinkIdsTable(session, connection, handle, pageSinkIds, closer);
                insertSql = (String)insertSql + String.format(" WHERE EXISTS (SELECT 1 FROM %s page_sink_table WHERE page_sink_table.%s = temp_table.%s)", this.quoted(pageSinkTable), handle.getPageSinkIdColumnName().get(), handle.getPageSinkIdColumnName().get());
            }
            this.execute(session, connection, (String)insertSql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
            }
        }
    }

    protected String postProcessInsertTableNameClause(ConnectorSession session, String tableName) {
        return tableName;
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column, ColumnPosition position) {
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        ColumnPosition columnPosition = position;
        Objects.requireNonNull(columnPosition);
        ColumnPosition columnPosition2 = columnPosition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ColumnPosition.First.class, ColumnPosition.After.class, ColumnPosition.Last.class}, (ColumnPosition)columnPosition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with FIRST clause");
            }
            case 1: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with AFTER clause");
            }
            case 2: 
        }
        this.addColumn(session, handle.asPlainTable().getRemoteTableName(), column);
    }

    private void addColumn(ConnectorSession session, RemoteTableName table, ColumnMetadata column) {
        if (column.getComment() != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with comments");
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            this.addColumn(session, connection, table, column);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void addColumn(ConnectorSession session, Connection connection, RemoteTableName table, ColumnMetadata column) throws SQLException {
        String columnName = column.getName();
        this.verifyColumnName(connection.getMetaData(), columnName);
        String remoteColumnName = this.identifierMapping.toRemoteColumnName(this.getRemoteIdentifiers(connection), columnName);
        String sql = String.format("ALTER TABLE %s ADD %s", this.quoted(table), this.getColumnDefinitionSql(session, column, remoteColumnName));
        this.execute(session, connection, sql);
    }

    @Override
    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            String newRemoteColumnName = this.identifierMapping.toRemoteColumnName(this.getRemoteIdentifiers(connection), newColumnName);
            this.verifyColumnName(connection.getMetaData(), newRemoteColumnName);
            this.renameColumn(session, connection, handle.asPlainTable().getRemoteTableName(), jdbcColumn.getColumnName(), newRemoteColumnName);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void renameColumn(ConnectorSession session, Connection connection, RemoteTableName remoteTableName, String remoteColumnName, String newRemoteColumnName) throws SQLException {
        this.execute(session, connection, String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(remoteTableName), this.quoted(remoteColumnName), this.quoted(newRemoteColumnName)));
    }

    @Override
    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            String remoteColumnName = this.identifierMapping.toRemoteColumnName(this.getRemoteIdentifiers(connection), column.getColumnName());
            String sql = String.format("ALTER TABLE %s DROP COLUMN %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(remoteColumnName));
            this.execute(session, connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            String remoteColumnName = this.identifierMapping.toRemoteColumnName(this.getRemoteIdentifiers(connection), column.getColumnName());
            String sql = String.format("ALTER TABLE %s ALTER COLUMN %s SET DATA TYPE %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(remoteColumnName), this.toWriteMapping(session, type).getDataType());
            this.execute(session, connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropNotNullConstraint(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            String remoteColumnName = this.identifierMapping.toRemoteColumnName(this.getRemoteIdentifiers(connection), column.getColumnName());
            String sql = String.format("ALTER TABLE %s ALTER COLUMN %s DROP NOT NULL", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(remoteColumnName));
            this.execute(session, connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void dropTable(ConnectorSession session, JdbcTableHandle handle) {
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        this.dropTable(session, handle.asPlainTable().getRemoteTableName(), false);
    }

    protected void dropTable(ConnectorSession session, RemoteTableName remoteTableName, boolean temporaryTable) {
        String sql = "DROP TABLE " + this.quoted(remoteTableName);
        this.execute(session, sql);
    }

    @Override
    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        if (handle.getTemporaryTableName().isPresent()) {
            this.dropTable(session, new RemoteTableName(handle.getRemoteTableName().getCatalogName(), handle.getRemoteTableName().getSchemaName(), handle.getTemporaryTableName().get()), true);
        }
    }

    @Override
    public boolean supportsRetries() {
        return this.supportsRetries;
    }

    private boolean shouldUseFaultTolerantExecution(ConnectorSession session) {
        return this.supportsRetries() && !JdbcWriteSessionProperties.isNonTransactionalInsert(session);
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        boolean hasPageSinkIdColumn = handle.getPageSinkIdColumnName().isPresent();
        Preconditions.checkArgument((handle.getColumnNames().size() == columnWriters.size() ? 1 : 0) != 0, (String)"handle and columnWriters mismatch: %s, %s", (Object)handle, columnWriters);
        return String.format("INSERT INTO %s (%s%s) VALUES (%s%s)", this.quoted(handle.getRemoteTableName().getCatalogName().orElse(null), handle.getRemoteTableName().getSchemaName().orElse(null), handle.getTemporaryTableName().orElseGet(() -> handle.getRemoteTableName().getTableName())), handle.getColumnNames().stream().map(this::quoted).collect(Collectors.joining(", ")), hasPageSinkIdColumn ? ", " + this.quoted(handle.getPageSinkIdColumnName().get()) : "", columnWriters.stream().map(WriteFunction::getBindExpression).collect(Collectors.joining(",")), hasPageSinkIdColumn ? ", ?" : "");
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        return this.connectionFactory.openConnection(session);
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql, Optional<Integer> columnCount) throws SQLException {
        return connection.prepareStatement(sql);
    }

    public ResultSet getTables(Connection connection, Optional<String> remoteSchemaName, Optional<String> remoteTableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(connection.getCatalog(), this.escapeObjectNameForMetadataQuery(remoteSchemaName, metadata.getSearchStringEscape()).orElse(null), this.escapeObjectNameForMetadataQuery(remoteTableName, metadata.getSearchStringEscape()).orElse(null), this.getTableTypes().map(types -> (String[])types.toArray(String[]::new)).orElse(null));
    }

    protected Optional<List<String>> getTableTypes() {
        return Optional.of(ImmutableList.of((Object)"TABLE", (Object)"VIEW"));
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_SCHEM");
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        return TableStatistics.empty();
    }

    @Override
    public void createSchema(ConnectorSession session, String schemaName) {
        ConnectorIdentity identity = session.getIdentity();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            schemaName = this.identifierMapping.toRemoteSchemaName(this.getRemoteIdentifiers(connection), identity, schemaName);
            this.verifySchemaName(connection.getMetaData(), schemaName);
            this.createSchema(session, connection, schemaName);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void createSchema(ConnectorSession session, Connection connection, String remoteSchemaName) throws SQLException {
        this.execute(session, connection, "CREATE SCHEMA " + this.quoted(remoteSchemaName));
    }

    @Override
    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        ConnectorIdentity identity = session.getIdentity();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            schemaName = this.identifierMapping.toRemoteSchemaName(this.getRemoteIdentifiers(connection), identity, schemaName);
            this.dropSchema(session, connection, schemaName, cascade);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void dropSchema(ConnectorSession session, Connection connection, String remoteSchemaName, boolean cascade) throws SQLException {
        String dropSchema = "DROP SCHEMA " + this.quoted(remoteSchemaName);
        if (cascade) {
            dropSchema = dropSchema + " CASCADE";
        }
        this.execute(session, connection, dropSchema);
    }

    @Override
    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        ConnectorIdentity identity = session.getIdentity();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            RemoteIdentifiers remoteIdentifiers = this.getRemoteIdentifiers(connection);
            String remoteSchemaName = this.identifierMapping.toRemoteSchemaName(remoteIdentifiers, identity, schemaName);
            String newRemoteSchemaName = this.identifierMapping.toRemoteSchemaName(remoteIdentifiers, identity, newSchemaName);
            this.verifySchemaName(connection.getMetaData(), newRemoteSchemaName);
            this.renameSchema(session, connection, remoteSchemaName, newRemoteSchemaName);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void renameSchema(ConnectorSession session, Connection connection, String remoteSchemaName, String newRemoteSchemaName) throws SQLException {
        this.execute(session, connection, "ALTER SCHEMA " + this.quoted(remoteSchemaName) + " RENAME TO " + this.quoted(newRemoteSchemaName));
    }

    protected void execute(ConnectorSession session, String query) {
        try (Connection connection = this.connectionFactory.openConnection(session);){
            this.execute(session, connection, query);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void execute(ConnectorSession session, Connection connection, String query) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String modifiedQuery = this.queryModifier.apply(session, query);
            log.debug("Execute: %s", new Object[]{modifiedQuery});
            statement.execute(modifiedQuery);
        }
        catch (SQLException e) {
            e.addSuppressed(new RuntimeException("Query: " + query));
            throw e;
        }
    }

    protected static boolean preventTextualTypeAggregationPushdown(List<List<ColumnHandle>> groupingSets) {
        if (!groupingSets.isEmpty()) {
            for (List<ColumnHandle> groupingSet : groupingSets) {
                boolean hasCaseSensitiveGroupingSet = groupingSet.stream().map(columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnType()).anyMatch(type -> type instanceof VarcharType || type instanceof CharType);
                if (!hasCaseSensitiveGroupingSet) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        if (this.topNFunction().isEmpty()) {
            return false;
        }
        throw new UnsupportedOperationException("topNFunction() implemented without implementing supportsTopN()");
    }

    protected Optional<TopNFunction> topNFunction() {
        return Optional.empty();
    }

    private Function<String, String> applyTopN(List<JdbcSortItem> sortOrder, long limit) {
        return query -> this.topNFunction().orElseThrow().apply((String)query, sortOrder, limit);
    }

    @Override
    public boolean isTopNGuaranteed(ConnectorSession session) {
        throw new UnsupportedOperationException("topNFunction() implemented without implementing isTopNLimitGuaranteed()");
    }

    @Override
    public boolean supportsLimit() {
        return this.limitFunction().isPresent();
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.empty();
    }

    private Function<String, String> applyLimit(long limit) {
        return query -> this.limitFunction().orElseThrow().apply((String)query, limit);
    }

    @Override
    public boolean isLimitGuaranteed(ConnectorSession session) {
        throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "limitFunction() is implemented without isLimitGuaranteed()");
    }

    @Override
    public boolean supportsMerge() {
        return false;
    }

    @Override
    public String quoted(String name) {
        name = name.replace(this.identifierQuote, this.identifierQuote + this.identifierQuote);
        return this.identifierQuote + name + this.identifierQuote;
    }

    @Override
    public String quoted(RemoteTableName remoteTableName) {
        return this.quoted(remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName());
    }

    @Override
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        Verify.verify((boolean)tableHandle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(tableHandle), (Object[])new Object[0]);
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to delete from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to delete when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to delete when sort order is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getUpdateAssignments().isEmpty(), (String)"Unable to delete when update assignments are set: %s", (Object)handle);
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareDeleteQuery(this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), BaseJdbcClient.getAdditionalPredicate(handle.getConstraintExpressions(), Optional.empty()));
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement(this, session, connection, preparedQuery, Optional.empty());
                try {
                    optionalLong = OptionalLong.of(preparedStatement.executeUpdate());
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public OptionalLong update(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to update from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to update when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to update when sort order is set: %s", (Object)handle);
        Preconditions.checkArgument((!handle.getUpdateAssignments().isEmpty() ? 1 : 0) != 0, (String)"Unable to update when update assignments are not set: %s", (Object)handle);
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareUpdateQuery(this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), BaseJdbcClient.getAdditionalPredicate(handle.getConstraintExpressions(), Optional.empty()), handle.getUpdateAssignments());
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement(this, session, connection, preparedQuery, Optional.empty());
                try {
                    optionalLong = OptionalLong.of(preparedStatement.executeUpdate());
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void truncateTable(ConnectorSession session, JdbcTableHandle handle) {
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s".formatted(handle), (Object[])new Object[0]);
        String sql = "TRUNCATE TABLE " + this.quoted(handle.asPlainTable().getRemoteTableName());
        this.execute(session, sql);
    }

    @Override
    public OptionalInt getMaxWriteParallelism(ConnectorSession session) {
        return OptionalInt.of(JdbcWriteSessionProperties.getWriteParallelism(session));
    }

    protected OptionalInt getMaxColumnNameLengthFromDatabaseMetaData(ConnectorSession session) {
        OptionalInt optionalInt;
        block10: {
            if (this.maxColumnNameLength != null) {
                if (this.maxColumnNameLength == 0) {
                    return OptionalInt.empty();
                }
                return OptionalInt.of(this.maxColumnNameLength);
            }
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                this.maxColumnNameLength = connection.getMetaData().getMaxColumnNameLength();
                optionalInt = OptionalInt.of(this.maxColumnNameLength);
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return optionalInt;
    }

    protected void verifySchemaName(DatabaseMetaData databaseMetadata, String schemaName) throws SQLException {
    }

    protected void verifyTableName(DatabaseMetaData databaseMetadata, String tableName) throws SQLException {
    }

    protected void verifyColumnName(DatabaseMetaData databaseMetadata, String columnName) throws SQLException {
    }

    protected String quoted(@Nullable String catalog, @Nullable String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)catalog)) {
            sb.append(this.quoted(catalog)).append(".");
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            sb.append(this.quoted(schema)).append(".");
        }
        sb.append(this.quoted(table));
        return sb.toString();
    }

    public static String varcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''") + "'";
    }

    protected Optional<String> escapeObjectNameForMetadataQuery(Optional<String> name, String escape) {
        return name.map(string -> this.escapeObjectNameForMetadataQuery((String)string, escape));
    }

    protected String escapeObjectNameForMetadataQuery(String name, String escape) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(escape, "escape is null");
        Preconditions.checkArgument((!escape.isEmpty() ? 1 : 0) != 0, (Object)"Escape string must not be empty");
        Preconditions.checkArgument((!escape.equals("_") ? 1 : 0) != 0, (Object)"Escape string must not be '_'");
        Preconditions.checkArgument((!escape.equals("%") ? 1 : 0) != 0, (Object)"Escape string must not be '%'");
        name = name.replace(escape, escape + escape);
        name = name.replace("_", escape + "_");
        name = name.replace("%", escape + "%");
        return name;
    }

    private static RemoteTableName getRemoteTable(ResultSet resultSet) throws SQLException {
        return new RemoteTableName(Optional.ofNullable(resultSet.getString("TABLE_CAT")), Optional.ofNullable(resultSet.getString("TABLE_SCHEM")), resultSet.getString("TABLE_NAME"));
    }

    private static ColumnMetadata getPageSinkIdColumn(List<String> otherColumnNames) {
        String baseColumnName = "trino_page_sink_id";
        Object columnName = baseColumnName;
        int suffix = 1;
        while (otherColumnNames.contains(columnName)) {
            columnName = baseColumnName + "_" + suffix;
            ++suffix;
        }
        return new ColumnMetadata((String)columnName, TRINO_PAGE_SINK_ID_COLUMN_TYPE);
    }

    public RemoteIdentifiers getRemoteIdentifiers(Connection connection) {
        return this.jdbcRemoteIdentifiersFactory.createJdbcRemoteIdentifies(connection);
    }

    private class IterateTableColumns
    extends AbstractIterator<RelationColumnsMetadata> {
        private final ConnectorSession session;
        private final Connection connection;
        private final Set<RemoteTableName> visibleTables;
        private final ResultSet resultSet;
        private RemoteTableName currentTable;
        private boolean currentTableVisible;
        private SchemaTableName currentTableName;
        private ImmutableList.Builder<ColumnMetadata> currentTableColumns;

        public IterateTableColumns(ConnectorSession session, Connection connection, Set<RemoteTableName> visibleTables, ResultSet resultSet) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.connection = Objects.requireNonNull(connection, "connection is null");
            this.visibleTables = Objects.requireNonNull(visibleTables, "visibleTables is null");
            this.resultSet = Objects.requireNonNull(resultSet, "resultSet is null");
        }

        protected RelationColumnsMetadata computeNext() {
            try {
                RelationColumnsMetadata computedNext = null;
                while (computedNext == null && this.resultSet.next()) {
                    RemoteTableName nextTable = BaseJdbcClient.getRemoteTable(this.resultSet);
                    if (this.currentTable != null && !this.currentTable.equals(nextTable)) {
                        computedNext = this.finishCurrentTable().orElse(null);
                    }
                    try {
                        if (this.currentTable == null) {
                            this.currentTable = nextTable;
                            String remoteSchemaFromResultSet = BaseJdbcClient.this.getTableSchemaName(this.resultSet);
                            this.currentTableVisible = this.visibleTables.contains(nextTable);
                            if (this.currentTableVisible) {
                                this.currentTableName = new SchemaTableName(BaseJdbcClient.this.identifierMapping.fromRemoteSchemaName(remoteSchemaFromResultSet), BaseJdbcClient.this.identifierMapping.fromRemoteTableName(remoteSchemaFromResultSet, this.resultSet.getString("TABLE_NAME")));
                                this.currentTableColumns = ImmutableList.builder();
                            }
                        }
                        if (!this.currentTableVisible) continue;
                        String columnName = this.resultSet.getString("COLUMN_NAME");
                        JdbcTypeHandle typeHandle = new JdbcTypeHandle(BaseJdbcClient.getInteger(this.resultSet, "DATA_TYPE").orElseThrow(() -> new IllegalStateException("DATA_TYPE is null")), Optional.ofNullable(this.resultSet.getString("TYPE_NAME")), BaseJdbcClient.getInteger(this.resultSet, "COLUMN_SIZE"), BaseJdbcClient.getInteger(this.resultSet, "DECIMAL_DIGITS"), Optional.empty(), Optional.empty());
                        boolean nullable = this.resultSet.getInt("NULLABLE") != 0;
                        Optional<String> comment = Optional.ofNullable(Strings.emptyToNull((String)this.resultSet.getString("REMARKS")));
                        BaseJdbcClient.this.toColumnMapping(this.session, this.connection, typeHandle).ifPresent(columnMapping -> this.currentTableColumns.add((Object)ColumnMetadata.builder().setName(columnName).setType(columnMapping.getType()).setNullable(nullable).setComment(comment).build()));
                    }
                    catch (RuntimeException | SQLException e) {
                        Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
                        throw new RuntimeException("Failure when processing column information for table %s: %s".formatted(this.currentTable, MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), e);
                    }
                }
                if (computedNext == null) {
                    computedNext = this.finishCurrentTable().orElse(null);
                }
                if (computedNext == null) {
                    this.resultSet.close();
                    this.connection.close();
                    return (RelationColumnsMetadata)this.endOfData();
                }
                return computedNext;
            }
            catch (RuntimeException | SQLException e) {
                BaseJdbcClient.cleanupSuppressing(e, () -> BaseJdbcClient.this.abortReadConnection(this.connection, this.resultSet));
                BaseJdbcClient.cleanupSuppressing(e, this.resultSet::close);
                BaseJdbcClient.cleanupSuppressing(e, this.connection::close);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
            }
        }

        private Optional<RelationColumnsMetadata> finishCurrentTable() {
            ImmutableList columnMetadata;
            if (this.currentTable == null) {
                return Optional.empty();
            }
            Optional<RelationColumnsMetadata> currentTableMetadata = Optional.empty();
            if (this.currentTableVisible && !(columnMetadata = this.currentTableColumns.build()).isEmpty()) {
                currentTableMetadata = Optional.of(RelationColumnsMetadata.forTable((SchemaTableName)this.currentTableName, (List)columnMetadata));
            }
            this.currentTable = null;
            this.currentTableName = null;
            this.currentTableColumns = null;
            return currentTableMetadata;
        }
    }

    @FunctionalInterface
    public static interface TopNFunction {
        public String apply(String var1, List<JdbcSortItem> var2, long var3);

        public static TopNFunction sqlStandard(Function<String, String> quote) {
            return (query, sortItems, limit) -> {
                String orderBy = sortItems.stream().map(sortItem -> {
                    String ordering = sortItem.sortOrder().isAscending() ? "ASC" : "DESC";
                    String nullsHandling = sortItem.sortOrder().isNullsFirst() ? "NULLS FIRST" : "NULLS LAST";
                    return String.format("%s %s %s", quote.apply(sortItem.column().getColumnName()), ordering, nullsHandling);
                }).collect(Collectors.joining(", "));
                return String.format("%s ORDER BY %s OFFSET 0 ROWS FETCH NEXT %s ROWS ONLY", query, orderBy, limit);
            };
        }
    }
}

