/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import dev.failsafe.RetryPolicy;
import io.trino.plugin.jdbc.BaseJdbcConnectorTableHandle;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcRecordCursor;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.RetryingModule;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class JdbcRecordSet
implements RecordSet {
    private final JdbcClient jdbcClient;
    private final ExecutorService executor;
    private final BaseJdbcConnectorTableHandle table;
    private final List<JdbcColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final JdbcSplit split;
    private final ConnectorSession session;
    private final RetryPolicy<Object> policy;

    public JdbcRecordSet(JdbcClient jdbcClient, ExecutorService executor, ConnectorSession session, RetryPolicy<Object> policy, JdbcSplit split, BaseJdbcConnectorTableHandle table, List<JdbcColumnHandle> columnHandles) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableList.Builder types = ImmutableList.builderWithExpectedSize((int)columnHandles.size());
        for (JdbcColumnHandle column : columnHandles) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        this.session = Objects.requireNonNull(session, "session is null");
        this.policy = Objects.requireNonNull(policy, "policy is null");
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return (RecordCursor)RetryingModule.retry(this.policy, () -> new JdbcRecordCursor(this.jdbcClient, this.executor, this.session, this.split, this.table, this.columnHandles));
    }
}

