/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.aggregation;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;

public class ImplementCovarianceSamp
implements AggregateFunctionRule<JdbcExpression, ParameterizedExpression> {
    private static final Capture<List<Variable>> ARGUMENTS = Capture.newCapture();

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"covar_samp")).with(AggregateFunctionPatterns.arguments().matching(AggregateFunctionPatterns.variables().matching(ConnectorExpressionPatterns.expressionTypes((Type[])new Type[]{RealType.REAL, RealType.REAL}).or(ConnectorExpressionPatterns.expressionTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}))).capturedAs(ARGUMENTS)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext<ParameterizedExpression> context) {
        List arguments = (List)captures.get(ARGUMENTS);
        Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
        Variable argument1 = (Variable)arguments.get(0);
        Variable argument2 = (Variable)arguments.get(1);
        JdbcColumnHandle columnHandle1 = (JdbcColumnHandle)context.getAssignment(argument1.getName());
        Verify.verify((boolean)aggregateFunction.getOutputType().equals((Object)columnHandle1.getColumnType()));
        ParameterizedExpression rewrittenArgument1 = (ParameterizedExpression)context.rewriteExpression((ConnectorExpression)argument1).orElseThrow();
        ParameterizedExpression rewrittenArgument2 = (ParameterizedExpression)context.rewriteExpression((ConnectorExpression)argument2).orElseThrow();
        return Optional.of(new JdbcExpression(String.format("covar_samp(%s, %s)", rewrittenArgument1.expression(), rewrittenArgument2.expression()), (List<QueryParameter>)ImmutableList.builder().addAll(rewrittenArgument1.parameters()).addAll(rewrittenArgument2.parameters()).build(), columnHandle1.getJdbcTypeHandle()));
    }
}

