/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JoinOperator;
import io.trino.plugin.jdbc.RemoteDatabaseEvent;
import io.trino.plugin.jdbc.RemoteLogTracingEvent;
import io.trino.spi.QueryId;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.assertions.Assert;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class BaseJdbcConnectorTest
extends BaseConnectorTest {
    private static final Logger log = Logger.get(BaseJdbcConnectorTest.class);
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)((Object)((Object)this)).getClass().getName()));

    protected abstract SqlExecutor onRemoteDatabase();

    @AfterAll
    public void afterClass() {
        this.executor.shutdownNow();
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_UPDATE -> true;
            case TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_POSITION, TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, TestingConnectorBehavior.SUPPORTS_MERGE, TestingConnectorBehavior.SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE -> false;
            case TestingConnectorBehavior.SUPPORTS_DYNAMIC_FILTER_PUSHDOWN -> super.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN);
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    @Test
    public void testInsertInPresenceOfNotSupportedColumn() {
        try (TestTable testTable = this.createTableWithUnsupportedColumn();){
            String unqualifiedTableName = testTable.getName().replaceAll("^\\w+\\.", "");
            this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_schema = '" + (String)this.getSession().getSchema().orElseThrow() + "' AND table_name = '" + unqualifiedTableName + "'", "VALUES 'one', 'three'");
            this.assertUpdate("INSERT INTO " + testTable.getName() + " (one, three) VALUES (123, 'test')", 1L);
            this.assertQuery("SELECT one, three FROM " + testTable.getName(), "SELECT 123, 'test'");
        }
    }

    protected TestTable createTableWithUnsupportedColumn() {
        return (TestTable)Assumptions.abort((String)"Not implemented");
    }

    @Test
    public void testCharTrailingSpace() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        try (TestTable table = new TestTable(this.onRemoteDatabase(), schema + ".char_trailing_space", "(x char(10))", List.of("'test'"));){
            String tableName = table.getName();
            this.assertQuery("SELECT * FROM " + tableName + " WHERE x = char 'test'", "VALUES 'test      '");
            this.assertQuery("SELECT * FROM " + tableName + " WHERE x = char 'test  '", "VALUES 'test      '");
            this.assertQuery("SELECT * FROM " + tableName + " WHERE x = char 'test        '", "VALUES 'test      '");
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + tableName + " WHERE x = char ' test'");
        }
    }

    @Test
    public void testAggregationPushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
            return;
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(nationkey) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(1) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count() FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, count(1) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        try (TestTable emptyTable = this.createAggregationTestTable((String)this.getSession().getSchema().orElseThrow() + ".empty_table", (List<String>)ImmutableList.of());){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(a_bigint) FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(1) FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count() FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_bigint, count(1) FROM " + emptyTable.getName() + " GROUP BY a_bigint"))).isFullyPushedDown();
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, min(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, max(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, avg(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        emptyTable = this.createAggregationTestTable((String)this.getSession().getSchema().orElseThrow() + ".empty_table", (List<String>)ImmutableList.of());
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT t_double, min(a_bigint) FROM " + emptyTable.getName() + " GROUP BY t_double"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT t_double, max(a_bigint) FROM " + emptyTable.getName() + " GROUP BY t_double"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT t_double, sum(a_bigint) FROM " + emptyTable.getName() + " GROUP BY t_double"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT t_double, avg(a_bigint) FROM " + emptyTable.getName() + " GROUP BY t_double"))).isFullyPushedDown();
        }
        finally {
            if (emptyTable != null) {
                emptyTable.close();
            }
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, sum(nationkey) FROM nation WHERE regionkey < 4 GROUP BY regionkey"))).isFullyPushedDown();
        this.assertConditionallyPushedDown(this.getSession(), "SELECT regionkey, sum(nationkey) FROM nation WHERE regionkey < 4 AND name > 'AAA' GROUP BY regionkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY), PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        this.assertConditionallyPushedDown(this.getSession(), "SELECT regionkey, sum(nationkey) FROM (SELECT * FROM nation WHERE regionkey < 2 LIMIT 11) GROUP BY regionkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_LIMIT_PUSHDOWN), PlanMatchPattern.node(LimitNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
        this.assertConditionallyPushedDown(this.getSession(), "SELECT custkey, sum(totalprice) FROM (SELECT custkey, totalprice FROM orders ORDER BY orderdate ASC, totalprice ASC LIMIT 10) GROUP BY custkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN), PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.node(TopNNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})));
        this.assertConditionallyPushedDown(this.joinPushdownEnabled(this.getSession()), "SELECT n.regionkey, sum(c.acctbal) acctbals FROM nation n LEFT JOIN customer c USING (nationkey) GROUP BY 1", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN), PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
        this.assertConditionallyPushedDown(this.getSession(), "SELECT nationkey, min(regionkey) FROM nation WHERE name = 'ARGENTINA' GROUP BY nationkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY), PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        this.assertConditionallyPushedDown(this.getSession(), "SELECT regionkey, sum(nationkey) FROM nation WHERE name LIKE '%N%' GROUP BY regionkey", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_EXPRESSION_PUSHDOWN_WITH_LIKE), PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(name) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey, count(name) FROM nation GROUP BY nationkey"))).isFullyPushedDown();
        this.assertConditionallyPushedDown(this.getSession(), "SELECT count(name) FROM nation WHERE name = 'ARGENTINA'", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY), PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT -13 FROM (SELECT count(*) FROM nation)"))).matches("VALUES -13").hasPlan(PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ValuesNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM (SELECT count(*) FROM nation)"))).matches("VALUES BIGINT '1'").hasPlan(PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ValuesNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM (SELECT count(*) FROM nation GROUP BY regionkey)"))).matches("VALUES BIGINT '5'").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM (SELECT name FROM nation UNION ALL SELECT name FROM region)"))).matches("VALUES BIGINT '30'").isNotFullyPushedDown(PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM (SELECT count(*) FROM nation UNION ALL SELECT count(*) FROM region)"))).matches("VALUES BIGINT '2'").hasPlan(PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ValuesNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ValuesNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})})})}));
    }

    @Test
    public void testCaseSensitiveAggregationPushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN)) {
            return;
        }
        boolean supportsPushdownWithVarcharInequality = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY);
        boolean supportsCountDistinctPushdown = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT);
        boolean supportsSumDistinctPushdown = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN);
        PlanMatchPattern aggregationOverTableScan = PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
        PlanMatchPattern groupingAggregationOverTableScan = PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
        try (TestTable table = this.newTrinoTable("test_cs_agg_pushdown", "(a_string varchar(1), a_char char(1), a_bigint bigint)", (List)ImmutableList.of((Object)"'A', 'A', 1", (Object)"'B', 'B', 1", (Object)"'a', 'a', 3", (Object)"'b', 'b', 4"));){
            this.assertConditionallyPushedDown(this.getSession(), "SELECT max(a_string), min(a_string), max(a_char), min(a_char) FROM " + table.getName(), supportsPushdownWithVarcharInequality, aggregationOverTableScan).skippingTypesCheck().matches("VALUES ('b', 'A', 'b', 'A')");
            this.assertConditionallyPushedDown(this.getSession(), "SELECT distinct a_string FROM " + table.getName(), supportsPushdownWithVarcharInequality, groupingAggregationOverTableScan).skippingTypesCheck().matches("VALUES 'A', 'B', 'a', 'b'");
            this.assertConditionallyPushedDown(this.getSession(), "SELECT distinct a_char FROM " + table.getName(), supportsPushdownWithVarcharInequality, groupingAggregationOverTableScan).skippingTypesCheck().matches("VALUES 'A', 'B', 'a', 'b'");
            this.assertConditionallyPushedDown(this.getSession(), "SELECT a_string, count(*) FROM " + table.getName() + " GROUP BY a_string", supportsPushdownWithVarcharInequality, groupingAggregationOverTableScan).skippingTypesCheck().matches("VALUES ('A', BIGINT '1'), ('a', BIGINT '1'), ('b', BIGINT '1'), ('B', BIGINT '1')");
            this.assertConditionallyPushedDown(this.getSession(), "SELECT a_char, count(*) FROM " + table.getName() + " GROUP BY a_char", supportsPushdownWithVarcharInequality, groupingAggregationOverTableScan).skippingTypesCheck().matches("VALUES ('A', BIGINT '1'), ('B', BIGINT '1'), ('a', BIGINT '1'), ('b', BIGINT '1')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(a_string), count(a_char) FROM " + table.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(a_string), count(a_char) FROM " + table.getName() + " GROUP BY a_bigint"))).isFullyPushedDown();
            this.assertConditionallyPushedDown(this.getSession(), "SELECT count(DISTINCT a_string) FROM " + table.getName(), supportsPushdownWithVarcharInequality, groupingAggregationOverTableScan).skippingTypesCheck().matches("VALUES BIGINT '4'");
            this.assertConditionallyPushedDown(this.getSession(), "SELECT count(DISTINCT a_char) FROM " + table.getName(), supportsPushdownWithVarcharInequality, groupingAggregationOverTableScan).skippingTypesCheck().matches("VALUES BIGINT '4'");
            Session withMarkDistinct = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "mark_distinct").build();
            Session withSingleStep = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "single_step").build();
            Session withPreAggregate = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").build();
            this.verifyMultipleDistinctPushdown(withMarkDistinct, PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}), supportsPushdownWithVarcharInequality, supportsCountDistinctPushdown, supportsSumDistinctPushdown, table);
            this.verifyMultipleDistinctPushdown(withSingleStep, PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}), supportsPushdownWithVarcharInequality, supportsCountDistinctPushdown, supportsSumDistinctPushdown, table);
            this.verifyMultipleDistinctPushdown(withPreAggregate, PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(GroupIdNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}))}), supportsPushdownWithVarcharInequality, supportsCountDistinctPushdown, supportsSumDistinctPushdown, table);
        }
    }

    private void verifyMultipleDistinctPushdown(Session session, PlanMatchPattern otherwiseExpected, boolean supportsPushdownWithVarcharInequality, boolean supportsCountDistinctPushdown, boolean supportsSumDistinctPushdown, TestTable table) {
        this.assertConditionallyPushedDown(session, "SELECT count(DISTINCT a_string), count(DISTINCT a_bigint) FROM " + table.getName(), supportsPushdownWithVarcharInequality && supportsCountDistinctPushdown, otherwiseExpected).skippingTypesCheck().matches("VALUES (BIGINT '4', BIGINT '3')");
        this.assertConditionallyPushedDown(session, "SELECT count(DISTINCT a_char), count(DISTINCT a_bigint) FROM " + table.getName(), supportsPushdownWithVarcharInequality && supportsCountDistinctPushdown, otherwiseExpected).skippingTypesCheck().matches("VALUES (BIGINT '4', BIGINT '3')");
        this.assertConditionallyPushedDown(session, "SELECT count(DISTINCT a_string), sum(DISTINCT a_bigint) FROM " + table.getName(), supportsPushdownWithVarcharInequality && supportsSumDistinctPushdown, otherwiseExpected).skippingTypesCheck().matches(this.sumDistinctAggregationPushdownExpectedResult());
        this.assertConditionallyPushedDown(session, "SELECT count(DISTINCT a_char), sum(DISTINCT a_bigint) FROM " + table.getName(), supportsPushdownWithVarcharInequality && supportsSumDistinctPushdown, otherwiseExpected).skippingTypesCheck().matches(this.sumDistinctAggregationPushdownExpectedResult());
    }

    protected String sumDistinctAggregationPushdownExpectedResult() {
        return "VALUES (BIGINT '4', BIGINT '8')";
    }

    @Test
    public void testAggregationWithUnsupportedResultType() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT array_agg(nationkey) FROM nation"))).skipResultsCorrectnessCheckForPushdown().isNotFullyPushedDown(AggregationNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT histogram(regionkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT multimap_agg(regionkey, nationkey) FROM nation"))).skipResultsCorrectnessCheckForPushdown().isNotFullyPushedDown(AggregationNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT approx_set(nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
    }

    @Test
    public void testDistinctAggregationPushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(DISTINCT regionkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
            return;
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT regionkey FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(DISTINCT regionkey) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT regionkey, min(nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        try (TestTable emptyTable = this.createAggregationTestTable((String)this.getSession().getSchema().orElseThrow() + ".empty_table", (List<String>)ImmutableList.of());){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT a_bigint FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(DISTINCT a_bigint) FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT t_double, min(a_bigint) FROM " + emptyTable.getName() + " GROUP BY t_double"))).isFullyPushedDown();
        }
        Session withMarkDistinct = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "mark_distinct").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(withMarkDistinct, "SELECT count(DISTINCT regionkey) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(withMarkDistinct, "SELECT count(DISTINCT nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        this.assertConditionallyPushedDown(withMarkDistinct, "SELECT count(DISTINCT comment) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY), PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        this.assertConditionallyPushedDown(withMarkDistinct, "SELECT count(DISTINCT regionkey), sum(nationkey) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT), PlanMatchPattern.node(MarkDistinctNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}));
        this.assertConditionallyPushedDown(withMarkDistinct, "SELECT sum(DISTINCT regionkey), sum(DISTINCT nationkey) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN), PlanMatchPattern.node(MarkDistinctNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}));
        this.assertConditionallyPushedDown(withMarkDistinct, "SELECT count(DISTINCT regionkey), count(DISTINCT nationkey) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT), PlanMatchPattern.node(MarkDistinctNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}));
        this.assertConditionallyPushedDown(withMarkDistinct, "SELECT sum(DISTINCT regionkey), count(nationkey) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN), PlanMatchPattern.node(MarkDistinctNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}));
        Session withSingleStep = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "single_step").build();
        Session withPreAggregate = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").build();
        this.verifyDistinctAggregationPushdown(withMarkDistinct, PlanMatchPattern.node(MarkDistinctNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}));
        this.verifyDistinctAggregationPushdown(withSingleStep, PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}));
        this.verifyDistinctAggregationPushdown(withPreAggregate, PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(GroupIdNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}))}));
    }

    private void verifyDistinctAggregationPushdown(Session session, PlanMatchPattern multiDistinctOtherwiseExpected) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT count(DISTINCT regionkey) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT count(DISTINCT nationkey) FROM nation GROUP BY regionkey"))).isFullyPushedDown();
        this.assertConditionallyPushedDown(session, "SELECT count(DISTINCT comment) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY), PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}));
        this.assertConditionallyPushedDown(session, "SELECT count(DISTINCT regionkey), count(DISTINCT nationkey) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT), multiDistinctOtherwiseExpected);
        this.assertConditionallyPushedDown(session, "SELECT sum(DISTINCT regionkey), sum(DISTINCT nationkey) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN), multiDistinctOtherwiseExpected);
        this.assertConditionallyPushedDown(session, "SELECT count(DISTINCT regionkey), sum(nationkey) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT), multiDistinctOtherwiseExpected);
        this.assertConditionallyPushedDown(session, "SELECT sum(DISTINCT regionkey), sum(nationkey) FROM nation", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN), multiDistinctOtherwiseExpected);
    }

    @Test
    public void testNumericAggregationPushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT max(nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT avg(nationkey) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
            return;
        }
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        try (TestTable emptyTable = this.createAggregationTestTable(schemaName + ".test_num_agg_pd", (List<String>)ImmutableList.of());){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(short_decimal), min(long_decimal), min(a_bigint), min(t_double) FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT max(short_decimal), max(long_decimal), max(a_bigint), max(t_double) FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(short_decimal), sum(long_decimal), sum(a_bigint), sum(t_double) FROM " + emptyTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT avg(short_decimal), avg(long_decimal), avg(a_bigint), avg(t_double) FROM " + emptyTable.getName()))).isFullyPushedDown();
        }
        try (TestTable testTable = this.createAggregationTestTable(schemaName + ".test_num_agg_pd", (List<String>)ImmutableList.of((Object)"100.000, 100000000.000000000, 100.000, 100000000", (Object)"123.321, 123456789.987654321, 123.321, 123456789"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(short_decimal), min(long_decimal), min(a_bigint), min(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT max(short_decimal), max(long_decimal), max(a_bigint), max(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(short_decimal), sum(long_decimal), sum(a_bigint), sum(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT avg(short_decimal), avg(long_decimal), avg(a_bigint), avg(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(short_decimal), min(long_decimal) FROM " + testTable.getName() + " WHERE short_decimal < 110 AND long_decimal < 124"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT min(long_decimal) FROM " + testTable.getName() + " WHERE short_decimal < 110"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM " + testTable.getName() + " GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM " + testTable.getName() + " WHERE short_decimal < 110 AND long_decimal < 124 GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM " + testTable.getName() + " WHERE short_decimal < 110 GROUP BY short_decimal"))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT short_decimal, min(long_decimal) FROM " + testTable.getName() + " WHERE long_decimal < 124 GROUP BY short_decimal"))).isFullyPushedDown();
        }
    }

    @Test
    public void testCountDistinctWithStringTypes() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            Assumptions.abort((String)"Unable to CREATE TABLE to test count distinct");
        }
        List rows = (List)Stream.of("a", "b", "A", "B", " a ", "a", "b", " b ", "\u0105").map(value -> String.format("'%1$s', '%1$s'", value)).collect(ImmutableList.toImmutableList());
        Session withMarkDistinct = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "mark_distinct").build();
        Session withSingleStep = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "single_step").build();
        Session withPreAggregate = Session.builder((Session)this.getSession()).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").build();
        try (TestTable testTable = this.newTrinoTable("distinct_strings", "(t_char CHAR(5), t_varchar VARCHAR(5))", rows);){
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY)) {
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(DISTINCT t_varchar) FROM " + testTable.getName()))).matches("VALUES BIGINT '7'").isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(DISTINCT t_char) FROM " + testTable.getName()))).matches("VALUES BIGINT '7'").isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(withMarkDistinct, "SELECT count(DISTINCT t_char), count(DISTINCT t_varchar) FROM " + testTable.getName()))).matches("VALUES (BIGINT '7', BIGINT '7')").isNotFullyPushedDown(MarkDistinctNode.class, new Class[]{ExchangeNode.class, ExchangeNode.class});
            } else {
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(DISTINCT t_varchar) FROM " + testTable.getName()))).matches("VALUES BIGINT '7'").isFullyPushedDown();
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(DISTINCT t_char) FROM " + testTable.getName()))).matches("VALUES BIGINT '7'").isFullyPushedDown();
                this.assertConditionallyPushedDown(withMarkDistinct, "SELECT count(DISTINCT t_char), count(DISTINCT t_varchar) FROM " + testTable.getName(), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT), PlanMatchPattern.node(MarkDistinctNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}));
                this.assertConditionallyPushedDown(withSingleStep, "SELECT count(DISTINCT t_char), count(DISTINCT t_varchar) FROM " + testTable.getName(), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT), PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
                this.assertConditionallyPushedDown(withPreAggregate, "SELECT count(DISTINCT t_char), count(DISTINCT t_varchar) FROM " + testTable.getName(), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT), PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(GroupIdNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})}))}));
            }
        }
    }

    protected TestTable createAggregationTestTable(String name, List<String> rows) {
        return new TestTable(this.onRemoteDatabase(), name, "(short_decimal decimal(9, 3), long_decimal decimal(30, 10), t_double double precision, a_bigint bigint)", rows);
    }

    @Test
    public void testStddevAggregationPushdown() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_STDDEV)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
                Assumptions.abort((String)"Unable to CREATE TABLE to test aggregation pushdown");
            }
            try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_stddev_pushdown", (List<String>)ImmutableList.of());){
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                return;
            }
        }
        try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_stddev_pushdown", (List<String>)ImmutableList.of());){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT StdDEv(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT StdDEv_SaMP(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT \"StdDEv\"(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT \"StdDEv_SaMP\"(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.onRemoteDatabase().execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (1)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.onRemoteDatabase().execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (3)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.onRemoteDatabase().execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (5)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_stddev_pushdown", (List<String>)ImmutableList.of((Object)"1, 1, 1, 1", (Object)"2, 2, 2, 2", (Object)"4, 4, 4, 4", (Object)"5, 5, 5, 5"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT stddev_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
    }

    @Test
    public void testVarianceAggregationPushdown() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_VARIANCE)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
                Assumptions.abort((String)"Unable to CREATE TABLE to test aggregation pushdown");
            }
            try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_var_pushdown", (List<String>)ImmutableList.of());){
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                return;
            }
        }
        try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_var_pushdown", (List<String>)ImmutableList.of());){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.onRemoteDatabase().execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (1)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.onRemoteDatabase().execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (3)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            this.onRemoteDatabase().execute("INSERT INTO " + testTable.getName() + " (t_double) VALUES (5)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_var_pushdown", (List<String>)ImmutableList.of((Object)"1, 1, 1, 1", (Object)"2, 2, 2, 2", (Object)"4, 4, 4, 4", (Object)"5, 5, 5, 5"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_pop(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT variance(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT var_samp(t_double) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
    }

    @Test
    public void testCovarianceAggregationPushdown() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_COVARIANCE)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
                Assumptions.abort((String)"Unable to CREATE TABLE to test aggregation pushdown");
            }
            try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_covar_pushdown", (List<String>)ImmutableList.of());){
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT covar_pop(t_double, u_double), covar_pop(v_real, w_real) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT covar_samp(t_double, u_double), covar_samp(v_real, w_real) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                return;
            }
        }
        try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_covar_pushdown", (List<String>)ImmutableList.of());){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT covar_pop(t_double, u_double), covar_pop(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT covar_samp(t_double, u_double), covar_samp(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_covar_pushdown", (List<String>)ImmutableList.of((Object)"2, 2, 2, 2", (Object)"4, 4, 4, 4"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT covar_pop(t_double, u_double), covar_pop(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT covar_samp(t_double, u_double), covar_samp(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
        testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_covar_pushdown", (List<String>)ImmutableList.of((Object)"1, 2, 1, 2", (Object)"100000000.123456, 4, 100000000.123456, 4", (Object)"123456789.987654, 8, 123456789.987654, 8"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT covar_pop(t_double, u_double), covar_pop(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT covar_samp(t_double, u_double), covar_samp(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
    }

    @Test
    public void testCorrAggregationPushdown() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_CORRELATION)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
                Assumptions.abort((String)"Unable to CREATE TABLE to test aggregation pushdown");
            }
            try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_corr_pushdown", (List<String>)ImmutableList.of());){
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT corr(t_double, u_double), corr(v_real, w_real) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                return;
            }
        }
        try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_corr_pushdown", (List<String>)ImmutableList.of());){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT corr(t_double, u_double), corr(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_corr_pushdown", (List<String>)ImmutableList.of((Object)"2, 2, 2, 2", (Object)"4, 4, 4, 4"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT corr(t_double, u_double), corr(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
        testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_corr_pushdown", (List<String>)ImmutableList.of((Object)"1, 2, 1, 2", (Object)"100000000.123456, 4, 100000000.123456, 4", (Object)"123456789.987654, 8, 123456789.987654, 8"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT corr(t_double, u_double), corr(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
    }

    @Test
    public void testRegrAggregationPushdown() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN_REGRESSION)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
                Assumptions.abort((String)"Unable to CREATE TABLE to test aggregation pushdown");
            }
            try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_regr_pushdown", (List<String>)ImmutableList.of());){
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regr_intercept(t_double, u_double), regr_intercept(v_real, w_real) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regr_slope(t_double, u_double), regr_slope(v_real, w_real) FROM " + testTable.getName()))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
                return;
            }
        }
        try (TestTable testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_regr_pushdown", (List<String>)ImmutableList.of());){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regr_intercept(t_double, u_double), regr_intercept(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regr_slope(t_double, u_double), regr_slope(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_regr_pushdown", (List<String>)ImmutableList.of((Object)"2, 2, 2, 2", (Object)"4, 4, 4, 4"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regr_intercept(t_double, u_double), regr_intercept(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regr_slope(t_double, u_double), regr_slope(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
        testTable = this.createTableWithDoubleAndRealColumns(schemaName + ".test_regr_pushdown", (List<String>)ImmutableList.of((Object)"1, 2, 1, 2", (Object)"100000000.123456, 4, 100000000.123456, 4", (Object)"123456789.987654, 8, 123456789.987654, 8"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regr_intercept(t_double, u_double), regr_intercept(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regr_slope(t_double, u_double), regr_slope(v_real, w_real) FROM " + testTable.getName()))).isFullyPushedDown();
        }
        finally {
            if (testTable != null) {
                testTable.close();
            }
        }
    }

    protected TestTable createTableWithDoubleAndRealColumns(String name, List<String> rows) {
        return new TestTable(this.onRemoteDatabase(), name, "(t_double double precision, u_double double precision, v_real real, w_real real)", rows);
    }

    @Test
    public void testLimitPushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_LIMIT_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation LIMIT 30"))).isNotFullyPushedDown(LimitNode.class, new Class[0]);
            return;
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation LIMIT 30"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation LIMIT 3"))).skipResultsCorrectnessCheckForPushdown().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation WHERE regionkey = 3 LIMIT 5"))).isFullyPushedDown();
        PlanMatchPattern filterOverTableScan = PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
        this.assertConditionallyPushedDown(this.getSession(), "SELECT name FROM nation WHERE name < 'EEE' LIMIT 5", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY), filterOverTableScan);
        PlanMatchPattern aggregationOverTableScan = PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})});
        this.assertConditionallyPushedDown(this.getSession(), "SELECT max(regionkey) FROM nation LIMIT 5", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN), aggregationOverTableScan);
        this.assertConditionallyPushedDown(this.getSession(), "SELECT regionkey, max(nationkey) FROM nation GROUP BY regionkey LIMIT 5", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN), aggregationOverTableScan);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT DISTINCT regionkey FROM nation LIMIT 5"))).isFullyPushedDown();
        this.assertConditionallyPushedDown(this.getSession(), "SELECT regionkey, count(*) FROM nation WHERE nationkey < 5 GROUP BY regionkey LIMIT 3", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN), aggregationOverTableScan);
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY)) {
            this.assertConditionallyPushedDown(this.getSession(), "SELECT regionkey, count(*) FROM nation WHERE name < 'EGYPT' GROUP BY regionkey LIMIT 3", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN), aggregationOverTableScan);
        }
        PlanMatchPattern topnOverTableScan = PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.node(TopNNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
        this.assertConditionallyPushedDown(this.getSession(), "SELECT * FROM (SELECT regionkey FROM nation ORDER BY nationkey ASC LIMIT 10) LIMIT 5", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN), topnOverTableScan);
        this.assertConditionallyPushedDown(this.getSession(), "SELECT * FROM (SELECT regionkey FROM nation ORDER BY name ASC LIMIT 10) LIMIT 5", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN_WITH_VARCHAR), topnOverTableScan);
        PlanMatchPattern joinOverTableScans = PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})});
        this.assertConditionallyPushedDown(this.joinPushdownEnabled(this.getSession()), "SELECT n.name, r.name FROM nation n LEFT JOIN region r USING (regionkey) LIMIT 30", this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN), joinOverTableScans);
    }

    @Test
    public void testTopNPushdownDisabled() {
        Session topNPushdownDisabled = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "topn_pushdown_enabled", "false").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(topNPushdownDisabled, "SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10"))).ordered().isNotFullyPushedDown(TopNNode.class, new Class[0]);
    }

    @Test
    public void testTopNPushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10"))).ordered().isNotFullyPushedDown(TopNNode.class, new Class[0]);
            return;
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM orders ORDER BY orderkey LIMIT 10"))).ordered().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM orders ORDER BY orderkey DESC LIMIT 10"))).ordered().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM orders ORDER BY shippriority DESC, totalprice ASC LIMIT 10"))).ordered().isFullyPushedDown();
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT sum(totalprice) AS total FROM orders GROUP BY custkey ORDER BY total DESC LIMIT 10"))).ordered().isFullyPushedDown();
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey, totalprice FROM (SELECT orderkey, totalprice FROM orders ORDER BY 1, 2 LIMIT 10) ORDER BY 2, 1 LIMIT 5"))).ordered().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey, totalprice FROM (SELECT orderkey, totalprice FROM (SELECT orderkey, totalprice FROM orders ORDER BY 1, 2 LIMIT 10) ORDER BY 2, 1 LIMIT 5) ORDER BY 1, 2 LIMIT 3"))).ordered().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey, totalprice FROM (SELECT orderkey, totalprice FROM orders LIMIT 15000) ORDER BY totalprice ASC LIMIT 5"))).ordered().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey, totalprice FROM (SELECT orderkey, totalprice FROM orders WHERE orderdate = DATE '1995-09-16' LIMIT 20) ORDER BY totalprice ASC LIMIT 5"))).ordered().isFullyPushedDown();
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM (SELECT SUM(totalprice) as sum, custkey AS total FROM orders GROUP BY custkey HAVING COUNT(*) > 3) ORDER BY sum DESC LIMIT 10"))).ordered().isFullyPushedDown();
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "join_pushdown_enabled", "false").build(), "SELECT * FROM nation n LEFT JOIN region r ON n.regionkey = r.regionkey ORDER BY n.nationkey LIMIT 3"))).ordered().isNotFullyPushedDown(PlanMatchPattern.node(TopNNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(ExchangeNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})})})}));
    }

    @Test
    public void testNullSensitiveTopNPushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN)) {
            return;
        }
        try (TestTable testTable = this.newTrinoTable("test_null_sensitive_topn_pushdown", "(name varchar(10), a bigint)", List.of("'small', 42", "'big', 134134", "'negative', -15", "'null', NULL"));){
            Verify.verify((SortOrder.values().length == 4 ? 1 : 0) != 0, (String)"The test needs to be updated when new options are added", (Object[])new Object[0]);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM " + testTable.getName() + " ORDER BY a ASC NULLS FIRST LIMIT 5"))).ordered().isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM " + testTable.getName() + " ORDER BY a ASC NULLS LAST LIMIT 5"))).ordered().isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM " + testTable.getName() + " ORDER BY a DESC NULLS FIRST LIMIT 5"))).ordered().isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM " + testTable.getName() + " ORDER BY a DESC NULLS LAST LIMIT 5"))).ordered().isFullyPushedDown();
        }
    }

    @Test
    public void testArithmeticPredicatePushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_ARITHMETIC_EXPRESSION_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT shippriority FROM orders WHERE shippriority % 4 = 0"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
            return;
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT shippriority FROM orders WHERE shippriority % 4 = 0"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey, name, regionkey FROM nation WHERE nationkey > 0 AND (nationkey - regionkey) % nationkey = 2"))).isFullyPushedDown().matches("VALUES (BIGINT '3', CAST('CANADA' AS varchar(25)), BIGINT '1')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey, name, regionkey FROM nation WHERE nationkey > 0 AND (nationkey - regionkey) % -nationkey = 2"))).isFullyPushedDown().matches("VALUES (BIGINT '3', CAST('CANADA' AS varchar(25)), BIGINT '1')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey, name, regionkey FROM nation WHERE nationkey > 0 AND (nationkey - regionkey) % 0 = 2"))).failure().hasMessageContaining("by zero");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nationkey, name, regionkey FROM nation WHERE nationkey > 0 AND (nationkey - regionkey) % (regionkey - 1) = 2"))).failure().hasMessageContaining("by zero");
    }

    @Test
    public void testCaseSensitiveTopNPushdown() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN)) {
            return;
        }
        boolean expectTopNPushdown = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN_WITH_VARCHAR);
        PlanMatchPattern topNOverTableScan = PlanMatchPattern.project((PlanMatchPattern)PlanMatchPattern.node(TopNNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
        try (TestTable testTable = this.newTrinoTable("test_case_sensitive_topn_pushdown", "(a_string varchar(10), a_char char(10), a_bigint bigint)", List.of("'A', 'A', 1", "'B', 'B', 2", "'a', 'a', 3", "'b', 'b', 4"));){
            this.assertConditionallyOrderedPushedDown(this.getSession(), "SELECT a_bigint FROM " + testTable.getName() + " ORDER BY a_string ASC LIMIT 2", expectTopNPushdown, topNOverTableScan);
            this.assertConditionallyOrderedPushedDown(this.getSession(), "SELECT a_bigint FROM " + testTable.getName() + " ORDER BY a_string DESC LIMIT 2", expectTopNPushdown, topNOverTableScan);
            this.assertConditionallyOrderedPushedDown(this.getSession(), "SELECT a_bigint FROM " + testTable.getName() + " ORDER BY a_char ASC LIMIT 2", expectTopNPushdown, topNOverTableScan);
            this.assertConditionallyOrderedPushedDown(this.getSession(), "SELECT a_bigint FROM " + testTable.getName() + " ORDER BY a_char DESC LIMIT 2", expectTopNPushdown, topNOverTableScan);
            this.assertConditionallyOrderedPushedDown(this.getSession(), "SELECT a_bigint FROM " + testTable.getName() + " ORDER BY a_bigint, a_char LIMIT 2", expectTopNPushdown, topNOverTableScan);
            this.assertConditionallyOrderedPushedDown(this.getSession(), "SELECT a_bigint FROM " + testTable.getName() + " ORDER BY a_bigint, a_string DESC LIMIT 2", expectTopNPushdown, topNOverTableScan);
        }
    }

    @Test
    public void testCaseInsensitivePredicate() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT address FROM customer WHERE address IN ('01bR7OOM6zPqo29DpAq', 'BJYZYJQk4yD5B', 'a6M1wdC44LW')"))).skippingTypesCheck().matches("VALUES 'BJYZYJQk4yD5B', 'a6M1wdC44LW', '01bR7OOM6zPqo29DpAq'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT COUNT(*) FROM customer WHERE address >= '01bR7OOM6zPqo29DpAq' AND address <= 'a6M1wdC44LW'"))).matches("VALUES BIGINT '858'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "domain_compaction_threshold", "1").build(), "SELECT address FROM customer WHERE address IN ('01bR7OOM6zPqo29DpAq', 'BJYZYJQk4yD5B', 'a6M1wdC44LW')"))).skippingTypesCheck().matches("VALUES 'BJYZYJQk4yD5B', 'a6M1wdC44LW', '01bR7OOM6zPqo29DpAq'");
    }

    @Test
    public void testJoinPushdownDisabled() {
        Session noJoinPushdown = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "join_pushdown_enabled", "false").setSystemProperty("enable_dynamic_filtering", "false").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(noJoinPushdown, "SELECT r.name, n.name FROM nation n JOIN region r ON n.regionkey = r.regionkey"))).joinIsNotFullyPushedDown();
    }

    @Test
    public void testJoinPushdown() {
        Session session = this.joinPushdownEnabled(this.getSession());
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN)) {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM nation n JOIN region r ON n.regionkey = r.regionkey"))).joinIsNotFullyPushedDown();
            return;
        }
        try (TestTable nationLowercaseTable = this.newTrinoTable("nation_lowercase", "AS SELECT nationkey, lower(name) name, regionkey FROM nation");){
            for (JoinOperator joinOperator : JoinOperator.values()) {
                log.info("Testing joinOperator=%s", new Object[]{joinOperator});
                if (joinOperator == JoinOperator.FULL_JOIN && !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_FULL_JOIN)) {
                    ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT r.name, n.name FROM nation n FULL JOIN region r ON n.regionkey = r.regionkey"))).joinIsNotFullyPushedDown();
                    continue;
                }
                Session withoutDynamicFiltering = Session.builder((Session)session).setSystemProperty("enable_dynamic_filtering", "false").build();
                List nonEqualities = (List)Stream.concat(Stream.of(JoinCondition.Operator.values()).filter(operator -> operator != JoinCondition.Operator.EQUAL && operator != JoinCondition.Operator.IDENTICAL).map(JoinCondition.Operator::getValue), Stream.of("IS DISTINCT FROM", "IS NOT DISTINCT FROM")).collect(ImmutableList.toImmutableList());
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format("SELECT r.name, n.name FROM nation n %s region r ON n.regionkey = r.regionkey", new Object[]{joinOperator})))).isFullyPushedDown();
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format("SELECT r.name, n.name FROM nation n %s region r ON n.nationkey = r.regionkey", new Object[]{joinOperator})))).isFullyPushedDown();
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format("SELECT n.name FROM nation n %s orders o ON DATE '2025-03-19' = o.orderdate", new Object[]{joinOperator})))).joinIsNotFullyPushedDown();
                this.assertJoinConditionallyPushedDown(session, String.format("SELECT n.name FROM nation n %s orders o ON n.regionkey = 1", new Object[]{joinOperator}), BaseJdbcConnectorTest.expectJoinPushdownOnEmptyProjection(joinOperator));
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format("SELECT r.name, n.name FROM nation n %s region r USING(regionkey)", new Object[]{joinOperator})))).isFullyPushedDown();
                this.assertJoinConditionallyPushedDown(session, String.format("SELECT n.name, n2.regionkey FROM nation n %s nation n2 ON n.name = n2.name", new Object[]{joinOperator}), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_EQUALITY));
                this.assertJoinConditionallyPushedDown(session, String.format("SELECT n.name, nl.regionkey FROM nation n %s %s nl ON n.name = nl.name", new Object[]{joinOperator, nationLowercaseTable.getName()}), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_EQUALITY));
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format("SELECT n.name, c.name FROM nation n %s customer c ON n.nationkey = c.nationkey and n.regionkey = c.custkey", new Object[]{joinOperator})))).isFullyPushedDown();
                for (String operator2 : nonEqualities) {
                    this.assertJoinConditionallyPushedDown(withoutDynamicFiltering, String.format("SELECT r.name, n.name FROM nation n %s region r ON n.regionkey %s r.regionkey", new Object[]{joinOperator, operator2}), this.expectJoinPushdown(operator2) && this.expectJoinPushdownOnInequalityOperator(joinOperator));
                    this.assertJoinConditionallyPushedDown(withoutDynamicFiltering, String.format("SELECT n.name, nl.name FROM nation n %s %s nl ON n.name %s nl.name", new Object[]{joinOperator, nationLowercaseTable.getName(), operator2}), this.expectVarcharJoinPushdown(operator2) && this.expectJoinPushdownOnInequalityOperator(joinOperator));
                }
                for (String operator2 : nonEqualities) {
                    log.info("Testing [joinOperator=%s] operator=%s on number", new Object[]{joinOperator, operator2});
                    this.assertJoinConditionallyPushedDown(session, String.format("SELECT n.name, c.name FROM nation n %s customer c ON n.nationkey = c.nationkey AND n.regionkey %s c.custkey", new Object[]{joinOperator, operator2}), this.expectJoinPushdown(operator2));
                }
                for (String operator2 : nonEqualities) {
                    log.info("Testing [joinOperator=%s] operator=%s on varchar", new Object[]{joinOperator, operator2});
                    this.assertJoinConditionallyPushedDown(session, String.format("SELECT n.name, nl.name FROM nation n %s %s nl ON n.regionkey = nl.regionkey AND n.name %s nl.name", new Object[]{joinOperator, nationLowercaseTable.getName(), operator2}), this.expectVarcharJoinPushdown(operator2));
                }
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format("SELECT c.name, n.name FROM (SELECT * FROM customer WHERE acctbal > 8000) c %s nation n ON c.custkey = n.nationkey", new Object[]{joinOperator})))).isFullyPushedDown();
                this.assertJoinConditionallyPushedDown(session, String.format("SELECT c.name, n.name FROM (SELECT * FROM customer WHERE address = 'TcGe5gaZNgVePxU5kRrvXBfkasDTea') c %s nation n ON c.custkey = n.nationkey", new Object[]{joinOperator}), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY));
                this.assertJoinConditionallyPushedDown(session, String.format("SELECT c.name, n.name FROM (SELECT * FROM customer WHERE address < 'TcGe5gaZNgVePxU5kRrvXBfkasDTea') c %s nation n ON c.custkey = n.nationkey", new Object[]{joinOperator}), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY));
                this.assertJoinConditionallyPushedDown(session, String.format("SELECT * FROM (SELECT regionkey rk, count(nationkey) c FROM nation GROUP BY regionkey) n %s region r ON n.rk = r.regionkey", new Object[]{joinOperator}), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN));
                this.assertJoinConditionallyPushedDown(session, String.format("SELECT * FROM (SELECT nationkey FROM nation LIMIT 30) n %s region r ON n.nationkey = r.regionkey", new Object[]{joinOperator}), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_LIMIT_PUSHDOWN));
                this.assertJoinConditionallyPushedDown(session, String.format("SELECT * FROM (SELECT nationkey FROM nation ORDER BY regionkey LIMIT 5) n %s region r ON n.nationkey = r.regionkey", new Object[]{joinOperator}), this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN));
                ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT * FROM nation n, region r, customer c WHERE n.regionkey = r.regionkey AND r.regionkey = c.custkey"))).isFullyPushedDown();
            }
        }
    }

    @Test
    public void testComplexJoinPushdown() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        Session session = this.joinPushdownEnabled(this.getSession());
        String query = "SELECT n.name, o.orderstatus FROM nation n JOIN orders o ON n.regionkey = o.orderkey AND n.nationkey + o.custkey - 3 = 0";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)session).setCatalogSessionProperty(catalog, "complex_join_pushdown_enabled", "false").build(), query))).joinIsNotFullyPushedDown();
        this.assertJoinConditionallyPushedDown(session, query, this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_ARITHMETIC_EXPRESSION_PUSHDOWN));
    }

    @Test
    public void testExplainAnalyzePhysicalReadWallTime() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM nation a", new String[]{"Physical input time: .*s"});
    }

    protected QueryAssertions.QueryAssert assertConditionallyPushedDown(Session session, @Language(value="SQL") String query, boolean condition, PlanMatchPattern otherwiseExpected) {
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, query));
        if (condition) {
            return queryAssert.isFullyPushedDown();
        }
        return queryAssert.isNotFullyPushedDown(otherwiseExpected);
    }

    protected QueryAssertions.QueryAssert assertJoinConditionallyPushedDown(Session session, @Language(value="SQL") String query, boolean condition) {
        try {
            QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, query));
            if (condition) {
                return queryAssert.isFullyPushedDown();
            }
            return queryAssert.joinIsNotFullyPushedDown();
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + query));
            throw e;
        }
    }

    protected void assertConditionallyOrderedPushedDown(Session session, @Language(value="SQL") String query, boolean condition, PlanMatchPattern otherwiseExpected) {
        try {
            QueryAssertions.QueryAssert queryAssert = ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, query))).ordered();
            if (condition) {
                queryAssert.isFullyPushedDown();
            } else {
                queryAssert.isNotFullyPushedDown(otherwiseExpected);
            }
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + query));
            throw e;
        }
    }

    protected boolean expectJoinPushdown(String operator) {
        if ("IS DISTINCT FROM".equals(operator)) {
            return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM);
        }
        return switch (this.toJoinConditionOperator(operator)) {
            default -> throw new MatchException(null, null);
            case JoinCondition.Operator.EQUAL, JoinCondition.Operator.NOT_EQUAL, JoinCondition.Operator.LESS_THAN, JoinCondition.Operator.LESS_THAN_OR_EQUAL, JoinCondition.Operator.GREATER_THAN, JoinCondition.Operator.GREATER_THAN_OR_EQUAL -> true;
            case JoinCondition.Operator.IDENTICAL -> this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM);
        };
    }

    protected static boolean expectJoinPushdownOnEmptyProjection(JoinOperator joinOperator) {
        return joinOperator == JoinOperator.LEFT_JOIN || joinOperator == JoinOperator.FULL_JOIN;
    }

    protected boolean expectJoinPushdownOnInequalityOperator(JoinOperator joinOperator) {
        return joinOperator != JoinOperator.JOIN;
    }

    private boolean expectVarcharJoinPushdown(String operator) {
        if ("IS DISTINCT FROM".equals(operator)) {
            return this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_EQUALITY);
        }
        return switch (this.toJoinConditionOperator(operator)) {
            default -> throw new MatchException(null, null);
            case JoinCondition.Operator.EQUAL, JoinCondition.Operator.NOT_EQUAL -> this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_EQUALITY);
            case JoinCondition.Operator.LESS_THAN, JoinCondition.Operator.LESS_THAN_OR_EQUAL, JoinCondition.Operator.GREATER_THAN, JoinCondition.Operator.GREATER_THAN_OR_EQUAL -> this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_INEQUALITY);
            case JoinCondition.Operator.IDENTICAL -> this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_DISTINCT_FROM) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_EQUALITY);
        };
    }

    private JoinCondition.Operator toJoinConditionOperator(String operator) {
        if (operator.equals("IS NOT DISTINCT FROM")) {
            return JoinCondition.Operator.IDENTICAL;
        }
        return (JoinCondition.Operator)((Optional)Stream.of(JoinCondition.Operator.values()).filter(joinOperator -> joinOperator.getValue().equals(operator)).collect(MoreCollectors.toOptional())).orElseThrow(() -> new IllegalArgumentException("Not found: " + operator));
    }

    protected Session joinPushdownEnabled(Session session) {
        Verify.verify((!new JdbcMetadataConfig().isJoinPushdownEnabled() ? 1 : 0) != 0);
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "join_pushdown_enabled", "true").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBulkColumnListingOptions() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            String schemaName = "test_columns_listing_" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            try (TestTable newNation = this.newTrinoTable(schemaName + ".nation", "(name varchar(25), nationkey bigint)");
                 TestTable newRegion = this.newTrinoTable(schemaName + ".region", "(name varchar(25), regionkey bigint)");){
                if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE)) {
                    this.assertUpdate("COMMENT ON TABLE " + newNation.getName() + " IS 'tmp nation copy comment'");
                }
                String newNationName = newNation.getName().replaceFirst("^" + Pattern.quote(schemaName) + ".", "");
                String newRegionName = newRegion.getName().replaceFirst("^" + Pattern.quote(schemaName) + ".", "");
                this.testBulkColumnListingOptions(Optional.of(schemaName), Optional.of(newNationName), Optional.of(newRegionName));
            }
            finally {
                this.assertUpdate("DROP SCHEMA " + schemaName);
            }
            return;
        }
        this.testBulkColumnListingOptions(Optional.empty(), Optional.empty(), Optional.empty());
    }

    private void testBulkColumnListingOptions(Optional<String> temporarySchema, Optional<String> temporaryNationTable, Optional<String> temporaryRegionTable) {
        for (boolean bulkListColumns : List.of(Boolean.valueOf(false), Boolean.valueOf(true))) {
            try {
                this.testBulkColumnListingOptions(temporarySchema, temporaryNationTable, temporaryRegionTable, bulkListColumns);
            }
            catch (AssertionError | RuntimeException e) {
                Fail.fail((String)("Failure for bulkListColumns " + bulkListColumns), (Throwable)e);
            }
        }
    }

    private void testBulkColumnListingOptions(Optional<String> temporarySchema, Optional<String> temporaryNationTable, Optional<String> temporaryRegionTable, boolean bulkListColumns) {
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalogName, "bulk_list_columns", Boolean.toString(bulkListColumns)).build();
        try {
            this.computeActual(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA");
        }
        catch (QueryFailedException maybeExpected) {
            Assertions.assertThat((Throwable)maybeExpected).hasMessage("Error listing table columns for catalog %s: The requested column listing mode is not supported".formatted(catalogName));
            return;
        }
        if (temporarySchema.isPresent()) {
            String numericNullable = (String)this.computeScalar("SELECT is_nullable FROM information_schema.columns\nWHERE table_schema = CURRENT_SCHEMA AND table_name = 'nation' AND column_name = 'nationkey'\n");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT table_name, column_name, is_nullable FROM information_schema.columns\nWHERE table_schema = '%s'\n".formatted(temporarySchema.get())))).skippingTypesCheck().matches("VALUES\n    ('%1$s', 'nationkey', '%3$s')\n  , ('%1$s', 'name', 'YES')\n  , ('%2$s', 'regionkey', '%3$s')\n  , ('%2$s', 'name', 'YES')\n".formatted(temporaryNationTable.orElseThrow(), temporaryRegionTable.orElseThrow(), numericNullable));
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT table_name, column_name, is_nullable FROM system.jdbc.columns\nWHERE table_cat = CURRENT_CATALOG AND table_schem = '%s'\n".formatted(temporarySchema.get())))).skippingTypesCheck().matches("VALUES\n    ('%1$s', 'nationkey', '%3$s')\n  , ('%1$s', 'name', 'YES')\n  , ('%2$s', 'regionkey', '%3$s')\n  , ('%2$s', 'name', 'YES')\n".formatted(temporaryNationTable.orElseThrow(), temporaryRegionTable.orElseThrow(), numericNullable));
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT table_name, column_name, is_nullable FROM information_schema.columns\nWHERE table_schema = CURRENT_SCHEMA\nAND ((column_name LIKE 'n_me' AND table_name IN ('customer', 'nation')) OR rand() = 42) -- not pushed down into connector\n"))).skippingTypesCheck().matches("VALUES\n    ('customer', 'name', 'YES')\n  , ('nation', 'name', 'YES')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT table_name, column_name, is_nullable FROM system.jdbc.columns\nWHERE table_cat = CURRENT_CATALOG AND table_schem = CURRENT_SCHEMA\nAND ((column_name LIKE 'n_me' AND table_name IN ('customer', 'nation')) OR rand() = 42) -- not pushed down into connector\n"))).skippingTypesCheck().matches("VALUES\n    ('customer', 'name', 'YES')\n  , ('nation', 'name', 'YES')\n");
    }

    @Test
    @Timeout(value=60L)
    public void testCancellation() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CANCELLATION)) {
            Assumptions.abort((String)"Cancellation is not supported by given connector");
        }
        try (TestView sleepingView = this.createSleepingView(new Duration(1.0, TimeUnit.MINUTES));){
            String tableNameToScan = sleepingView.getName().toLowerCase(Locale.ENGLISH);
            RemoteLogTracingEvent runningTracingEvent = new RemoteLogTracingEvent(event -> event.getQuery().toLowerCase(Locale.ENGLISH).contains(tableNameToScan) && event.getStatus() == RemoteDatabaseEvent.Status.RUNNING);
            this.startTracingDatabaseEvent(runningTracingEvent);
            String query = "SELECT * FROM " + sleepingView.getName();
            Future<?> future = this.executor.submit(() -> this.assertQueryFails(query, "Query killed. Message: Killed by test"));
            QueryId queryId = this.getQueryId(query);
            Assert.assertEventually(() -> Assertions.assertThat((boolean)runningTracingEvent.hasHappened()).isTrue());
            this.stopTracingDatabaseEvent(runningTracingEvent);
            RemoteLogTracingEvent cancelledTracingEvent = new RemoteLogTracingEvent(event -> event.getQuery().toLowerCase(Locale.ENGLISH).contains(tableNameToScan) && event.getStatus() == RemoteDatabaseEvent.Status.CANCELLED);
            this.startTracingDatabaseEvent(cancelledTracingEvent);
            this.assertUpdate(String.format("CALL system.runtime.kill_query(query_id => '%s', message => '%s')", queryId, "Killed by test"));
            future.get();
            Assert.assertEventually(() -> Assertions.assertThat((boolean)cancelledTracingEvent.hasHappened()).isTrue());
            this.stopTracingDatabaseEvent(cancelledTracingEvent);
        }
    }

    protected void startTracingDatabaseEvent(RemoteLogTracingEvent event) {
        throw new UnsupportedOperationException();
    }

    protected void stopTracingDatabaseEvent(RemoteLogTracingEvent event) {
        throw new UnsupportedOperationException();
    }

    private QueryId getQueryId(String query) throws Exception {
        for (int i = 0; i < 100; ++i) {
            MaterializedResult queriesResult = this.getQueryRunner().execute(String.format("SELECT query_id FROM system.runtime.queries WHERE query = '%s' AND query NOT LIKE '%%system.runtime.queries%%'", query));
            int rowCount = queriesResult.getRowCount();
            if (rowCount != 0) {
                Preconditions.checkState((rowCount == 1 ? 1 : 0) != 0, (String)"Too many (%s) query ids were found for: %s", (int)rowCount, (Object)query);
                return new QueryId((String)queriesResult.getOnlyValue());
            }
            Thread.sleep(100L);
        }
        throw new IllegalStateException("Query id not found for: " + query);
    }

    protected TestView createSleepingView(Duration minimalSleepDuration) {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testUpdateNotNullColumn() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
            super.testUpdateNotNullColumn();
            return;
        }
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT)) {
            this.assertQueryFails("CREATE TABLE not_null_constraint (not_null_col INTEGER NOT NULL)", String.format("line 1:35: Catalog '%s' does not support non-null column for column name 'not_null_col'", this.getSession().getCatalog().orElseThrow()));
            return;
        }
        try (TestTable table = this.newTrinoTable("update_not_null", "(nullable_col INTEGER, not_null_col INTEGER NOT NULL)");){
            this.assertUpdate(String.format("INSERT INTO %s (nullable_col, not_null_col) VALUES (1, 10)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 10)");
            this.assertQueryFails("UPDATE " + table.getName() + " SET not_null_col = NULL WHERE nullable_col = 1", "This connector does not support modifying table rows");
            this.assertQueryFails("UPDATE " + table.getName() + " SET not_null_col = TRY(5/0) where nullable_col = 1", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void testUpdateRowType() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
            super.testUpdateRowType();
            return;
        }
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE) ? 1 : 0) != 0);
        try (TestTable table = this.newTrinoTable("test_update_with_predicates_on_row_types", "(int_t INT, row_t ROW(f1 INT, f2 INT))");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(2, 3)), (11, ROW(12, 13)), (21, ROW(22, 23))", 3L);
            this.assertQueryFails("UPDATE " + tableName + " SET int_t = int_t - 1 WHERE row_t.f2 = 3", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void testUpdateRowConcurrently() throws Exception {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
            super.testUpdateRowConcurrently();
            return;
        }
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE) ? 1 : 0) != 0);
        try (TestTable table = this.newTrinoTable("test_update_row", "(a INT, b INT, c INT)", (List)ImmutableList.of((Object)"1, 2, 3"));){
            this.assertQueryFails("UPDATE " + table.getName() + " SET a = a + 1", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void testUpdateAllValues() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
            super.testUpdateAllValues();
            return;
        }
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE) ? 1 : 0) != 0);
        try (TestTable table = this.newTrinoTable("test_update_all", "(a INT, b INT, c INT)", (List)ImmutableList.of((Object)"1, 2, 3"));){
            this.assertUpdate("UPDATE " + table.getName() + " SET a = 1, b = 1, c = 2", 1L);
        }
    }

    @Test
    public void testUpdateWithPredicates() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
            super.testUpdateWithPredicates();
            return;
        }
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE) ? 1 : 0) != 0);
        try (TestTable table = this.newTrinoTable("test_row_predicates", "(a INT, b INT, c INT)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2, 3), (11, 12, 13), (21, 22, 23)", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET a = 5 WHERE c = 3", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (5, 2, 3), (11, 12, 13), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET c = 6 WHERE a = 11", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (5, 2, 3), (11, 12, 6), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = 44 WHERE b = 22", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (5, 2, 3), (11, 12, 6), (21, 44, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = 45 WHERE a > 5", 2L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (5, 2, 3), (11, 45, 6), (21, 45, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = 46 WHERE a < 21", 2L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (5, 46, 3), (11, 46, 6), (21, 45, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = 47 WHERE a != 11", 2L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (5, 47, 3), (11, 46, 6), (21, 47, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = 48 WHERE a IN (5, 11)", 2L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (5, 48, 3), (11, 48, 6), (21, 47, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = 49 WHERE a NOT IN (5, 11)", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (5, 48, 3), (11, 48, 6), (21, 49, 23)");
            this.assertQueryFails("UPDATE " + tableName + " SET b = b + 3 WHERE a NOT IN (5, 11)", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void testConstantUpdateWithVarcharEqualityPredicates() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE) ? 1 : 0) != 0);
        try (TestTable table = this.createTestTableForWrites("test_update_varchar", "(col1 INT, col2 varchar(1), pk INT)", (List)ImmutableList.of((Object)"1, 'a', 1", (Object)"2, 'A', 2"), "pk");){
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY) && !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
                this.assertQueryFails("UPDATE " + table.getName() + " SET col1 = 20 WHERE col2 = 'A'", "This connector does not support modifying table rows");
                return;
            }
            this.assertUpdate("UPDATE " + table.getName() + " SET col1 = 20 WHERE col2 = 'A'", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 'a', 1), (20, 'A', 2)");
        }
    }

    @Test
    public void testConstantUpdateWithVarcharInequalityPredicates() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE) ? 1 : 0) != 0);
        try (TestTable table = this.createTestTableForWrites("test_update_varchar", "(col1 INT, col2 varchar(1), pk INT)", (List)ImmutableList.of((Object)"1, 'a', 1", (Object)"2, 'A', 2"), "pk");){
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY) && !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
                this.assertQueryFails("UPDATE " + table.getName() + " SET col1 = 20 WHERE col2 != 'A'", "This connector does not support modifying table rows");
                return;
            }
            this.assertUpdate("UPDATE " + table.getName() + " SET col1 = 20 WHERE col2 != 'A'", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (20, 'a', 1), (2, 'A', 2)");
        }
    }

    @Test
    public void testConstantUpdateWithVarcharGreaterAndLowerPredicate() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE) ? 1 : 0) != 0);
        try (TestTable table = this.createTestTableForWrites("test_update_varchar", "(col1 INT, col2 varchar(1), pk INT)", (List)ImmutableList.of((Object)"1, 'a', 1", (Object)"2, 'A', 2"), "pk");){
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY) && !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
                this.assertQueryFails("UPDATE " + table.getName() + " SET col1 = 20 WHERE col2 > 'A'", "This connector does not support modifying table rows");
                this.assertQueryFails("UPDATE " + table.getName() + " SET col1 = 20 WHERE col2 < 'A'", "This connector does not support modifying table rows");
                return;
            }
            this.assertUpdate("UPDATE " + table.getName() + " SET col1 = 20 WHERE col2 > 'A'", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (20, 'a', 1), (2, 'A', 2)");
            this.assertUpdate("UPDATE " + table.getName() + " SET col1 = 20 WHERE col2 < 'a'", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (20, 'a', 1), (20, 'A', 2)");
        }
    }

    @Test
    public void testDeleteWithBigintEqualityPredicate() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE) ? 1 : 0) != 0);
        try (TestTable table = this.newTrinoTable("test_delete_bigint", "AS SELECT * FROM region");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey = 1", 1L);
            this.assertQuery("SELECT regionkey, name FROM " + table.getName(), "VALUES (0, 'AFRICA'),(2, 'ASIA'),(3, 'EUROPE'),(4, 'MIDDLE EAST')");
        }
    }

    @Test
    public void testDeleteWithVarcharEqualityPredicate() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE) ? 1 : 0) != 0);
        try (TestTable table = this.createTestTableForWrites("test_delete_varchar", "(col varchar(1), pk INT)", (List)ImmutableList.of((Object)"'a', 1", (Object)"'A', 2", (Object)"null, 3"), "pk");){
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_EQUALITY) && !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_UPDATE)) {
                this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE col = 'A'", "This connector does not support modifying table rows");
                return;
            }
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE col = 'A'", 1L);
            this.assertQuery("SELECT col FROM " + table.getName(), "VALUES 'a', null");
        }
    }

    @Test
    public void testDeleteWithVarcharInequalityPredicate() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE) ? 1 : 0) != 0);
        try (TestTable table = this.createTestTableForWrites("test_delete_varchar", "(col varchar(1), pk int)", (List)ImmutableList.of((Object)"'a', 0", (Object)"'A', 1", (Object)"null, 2"), "pk");){
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY) && !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE)) {
                this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE col != 'A'", "This connector does not support modifying table rows");
                return;
            }
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE col != 'A'", 1L);
            this.assertQuery("SELECT col FROM " + table.getName(), "VALUES 'A', null");
        }
    }

    @Test
    public void testDeleteWithVarcharGreaterAndLowerPredicate() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE) ? 1 : 0) != 0);
        try (TestTable table = this.createTestTableForWrites("test_delete_varchar", "(col varchar(1), pk int)", (List)ImmutableList.of((Object)"'0', 0", (Object)"'a', 1", (Object)"'A', 2", (Object)"'b', 3", (Object)"null, 4"), "pk");){
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY) && !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE)) {
                this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE col < 'A'", "This connector does not support modifying table rows");
                this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE col > 'A'", "This connector does not support modifying table rows");
                return;
            }
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE col < 'A'", 1L);
            this.assertQuery("SELECT col FROM " + table.getName(), "VALUES 'a', 'A', 'b', null");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE col > 'A'", 2L);
            this.assertQuery("SELECT col FROM " + table.getName(), "VALUES 'A', null");
        }
    }

    @Test
    public void testDeleteWithComplexPredicate() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE) ? 1 : 0) != 0);
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE)) {
            super.testDeleteWithComplexPredicate();
            return;
        }
        Assertions.assertThatThrownBy(() -> super.testDeleteWithComplexPredicate()).hasStackTraceContaining("TrinoException: This connector does not support modifying table rows");
    }

    @Test
    public void testDeleteWithSubquery() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE) ? 1 : 0) != 0);
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE)) {
            super.testDeleteWithSubquery();
            return;
        }
        Assertions.assertThatThrownBy(() -> super.testDeleteWithSubquery()).hasStackTraceContaining("TrinoException: This connector does not support modifying table rows");
    }

    @Test
    public void testExplainAnalyzeWithDeleteWithSubquery() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE) ? 1 : 0) != 0);
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE)) {
            super.testExplainAnalyzeWithDeleteWithSubquery();
            return;
        }
        Assertions.assertThatThrownBy(() -> super.testExplainAnalyzeWithDeleteWithSubquery()).hasStackTraceContaining("TrinoException: This connector does not support modifying table rows");
    }

    @Test
    public void testDeleteWithSemiJoin() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE) ? 1 : 0) != 0);
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE)) {
            super.testDeleteWithSemiJoin();
            return;
        }
        Assertions.assertThatThrownBy(() -> super.testDeleteWithSemiJoin()).hasStackTraceContaining("TrinoException: This connector does not support modifying table rows");
    }

    @Test
    public void testMergeTargetWithoutPrimaryKeys() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String tableName = "test_merge_target_no_pks_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a int, b int)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(1, 1), (2, 2)", 2L);
        this.assertQueryFails(String.format("DELETE FROM %s WHERE a IS NOT NULL AND abs(a + b) > 10", tableName), "The connector can not perform merge on the target table without primary keys");
        this.assertQueryFails(String.format("UPDATE %s SET a = a+b WHERE a IS NOT NULL AND (a + b) > 10", tableName), "The connector can not perform merge on the target table without primary keys");
        this.assertQueryFails(String.format("MERGE INTO %s t USING (VALUES (3, 3)) AS s(x, y)    ON t.a = s.x    WHEN MATCHED THEN UPDATE SET b = y    WHEN NOT MATCHED THEN INSERT (a, b) VALUES (s.x, s.y) ", tableName), "The connector can not perform merge on the target table without primary keys");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeleteWithVarcharPredicate() {
        Assumptions.abort((String)"This is implemented by testDeleteWithVarcharEqualityPredicate");
    }

    @Test
    public void testInsertWithoutTemporaryTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            Assumptions.abort((String)"CREATE TABLE is required for testing non-transactional write support");
        }
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "non_transactional_insert", "false").build();
        try (TestTable table = this.newTrinoTable("test_bypass_temp", "(a varchar(36), b bigint)");){
            int numberOfRows = 50;
            String values = String.join((CharSequence)",", BaseJdbcConnectorTest.buildRowsForInsert(numberOfRows));
            this.assertUpdate(session, "INSERT INTO " + table.getName() + " (a, b) VALUES " + values, numberOfRows);
            this.assertQuery("SELECT COUNT(*) FROM " + table.getName(), String.format("VALUES %d", numberOfRows));
        }
    }

    @Test
    public void testWriteBatchSizeSessionProperty() {
        this.testWriteBatchSizeSessionProperty(10, 8);
        this.testWriteBatchSizeSessionProperty(10, 10);
        this.testWriteBatchSizeSessionProperty(10, 11);
        this.testWriteBatchSizeSessionProperty(10, 50);
        this.testWriteBatchSizeSessionProperty(10, 52);
    }

    private void testWriteBatchSizeSessionProperty(int batchSize, int numberOfRows) {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            Assumptions.abort((String)"CREATE TABLE is required for write_batch_size test but is not supported");
        }
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "write_batch_size", Integer.toString(batchSize)).build();
        try (TestTable table = this.newTrinoTable("write_batch_size", "(a varchar(36), b bigint)");){
            String values = String.join((CharSequence)",", BaseJdbcConnectorTest.buildRowsForInsert(numberOfRows));
            this.assertUpdate(session, "INSERT INTO " + table.getName() + " (a, b) VALUES " + values, numberOfRows);
            this.assertQuery("SELECT COUNT(*) FROM " + table.getName(), String.format("VALUES %d", numberOfRows));
        }
    }

    @Test
    public void testWriteTaskParallelismSessionProperty() {
        this.testWriteTaskParallelismSessionProperty(1, 10000);
        this.testWriteTaskParallelismSessionProperty(2, 10000);
        this.testWriteTaskParallelismSessionProperty(4, 10000);
        this.testWriteTaskParallelismSessionProperty(16, 10000);
        this.testWriteTaskParallelismSessionProperty(32, 10000);
    }

    private void testWriteTaskParallelismSessionProperty(int parallelism, int numberOfRows) {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            Assumptions.abort((String)"CREATE TABLE is required for write_parallelism test but is not supported");
        }
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "write_parallelism", String.valueOf(parallelism)).build();
        QueryRunner queryRunner = this.getQueryRunner();
        try (TestTable table = this.newTrinoTable("write_parallelism", "(a varchar(128), b bigint)");){
            Plan plan = (Plan)this.newTransaction().singleStatement().execute(session, transactionSession -> queryRunner.createPlan(transactionSession, "INSERT INTO " + table.getName() + " (a, b) SELECT clerk, orderkey FROM tpch.sf100.orders LIMIT " + numberOfRows));
            TableWriterNode.WriterTarget target = ((TableWriterNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof TableWriterNode).findOnlyElement()).getTarget();
            Assertions.assertThat((OptionalInt)target.getMaxWriterTasks(queryRunner.getPlannerContext().getMetadata(), this.getSession())).hasValue(parallelism);
        }
    }

    private static List<String> buildRowsForInsert(int numberOfRows) {
        ArrayList<String> result = new ArrayList<String>(numberOfRows);
        for (int i = 0; i < numberOfRows; ++i) {
            result.add(String.format("('%s', %d)", UUID.randomUUID(), ThreadLocalRandom.current().nextLong()));
        }
        return result;
    }

    @Test
    public void verifySupportsNativeQueryDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY)) {
            return;
        }
        this.assertQueryFails(String.format("SELECT * FROM TABLE(system.query(query => 'SELECT name FROM %s.nation WHERE nationkey = 0'))", this.getSession().getSchema().orElseThrow()), "line 1:21: Table function 'system.query' not registered");
    }

    @Test
    public void testNativeQuerySimple() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        this.assertQuery("SELECT * FROM TABLE(system.query(query => 'SELECT 1'))", "VALUES 1");
    }

    @Test
    public void testNativeQueryParameters() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query_simple", "SELECT * FROM TABLE(system.query(query => ?))").addPreparedStatement("my_query", "SELECT * FROM TABLE(system.query(query => format('SELECT %s FROM %s', ?, ?)))").build();
        this.assertQuery(session, "EXECUTE my_query_simple USING 'SELECT 1 a'", "VALUES 1");
        this.assertQuery(session, "EXECUTE my_query USING 'a', '(SELECT 2 a) t'", "VALUES 2");
    }

    @Test
    public void testNativeQuerySelectFromNation() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        this.assertQuery(String.format("SELECT * FROM TABLE(system.query(query => 'SELECT name FROM %s.nation WHERE nationkey = 0'))", this.getSession().getSchema().orElseThrow()), "VALUES 'ALGERIA'");
    }

    @Test
    public void testNativeQuerySelectFromTestTable() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        try (TestTable testTable = this.simpleTable();){
            this.assertQuery(String.format("SELECT * FROM TABLE(system.query(query => 'SELECT * FROM %s'))", testTable.getName()), "VALUES 1, 2");
        }
    }

    @Test
    public void testNativeQueryColumnAlias() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT region_name FROM TABLE(system.query(query => 'SELECT name AS region_name FROM %s.region WHERE regionkey = 0'))", this.getSession().getSchema().orElseThrow())))).skippingTypesCheck().matches("VALUES 'AFRICA'");
    }

    @Test
    public void testNativeQueryColumnAliasNotFound() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        this.assertQueryFails(String.format("SELECT name FROM TABLE(system.query(query => 'SELECT name AS region_name FROM %s.region'))", this.getSession().getSchema().orElseThrow()), ".* Column 'name' cannot be resolved");
        this.assertQueryFails(String.format("SELECT column_not_found FROM TABLE(system.query(query => 'SELECT name AS region_name FROM %s.region'))", this.getSession().getSchema().orElseThrow()), ".* Column 'column_not_found' cannot be resolved");
    }

    @Test
    public void testNativeQuerySelectUnsupportedType() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        try (TestTable testTable = this.createTableWithUnsupportedColumn();){
            String unqualifiedTableName = testTable.getName().replaceAll("^\\w+\\.", "");
            this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_schema = '" + (String)this.getSession().getSchema().orElseThrow() + "' AND table_name = '" + unqualifiedTableName + "'", "VALUES 'one', 'three'");
            this.assertUpdate("INSERT INTO " + testTable.getName() + " (one, three) VALUES (123, 'test')", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM TABLE(system.query(query => 'SELECT * FROM %s'))", testTable.getName())))).nonTrinoExceptionFailure().hasMessageContaining("Unsupported type");
        }
    }

    @Test
    public void testNativeQueryCreateStatement() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "numbers")).isFalse();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(system.query(query => 'CREATE TABLE numbers(n INTEGER)'))"))).failure().hasMessageContaining("Query not supported: ResultSetMetaData not available for query: CREATE TABLE numbers(n INTEGER)");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "numbers")).isFalse();
    }

    @Test
    public void testNativeQueryInsertStatementTableDoesNotExist() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), "non_existent_table")).isFalse();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(system.query(query => 'INSERT INTO non_existent_table VALUES (1)'))"))).failure().hasMessageContaining("Failed to get table handle for prepared query");
    }

    @Test
    public void testNativeQueryInsertStatementTableExists() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        try (TestTable testTable = this.simpleTable();){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT * FROM TABLE(system.query(query => 'INSERT INTO %s VALUES (3)'))", testTable.getName())))).failure().hasMessageContaining(String.format("Query not supported: ResultSetMetaData not available for query: INSERT INTO %s VALUES (3)", testTable.getName()));
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES 1, 2");
        }
    }

    @Test
    public void testNativeQueryIncorrectSyntax() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NATIVE_QUERY));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM TABLE(system.query(query => 'some wrong syntax'))"))).failure().hasMessageContaining("Failed to get table handle for prepared query");
    }

    protected TestTable simpleTable() {
        return new TestTable(this.onRemoteDatabase(), String.format("%s.simple_table", this.getSession().getSchema().orElseThrow()), "(col BIGINT)", (List)ImmutableList.of((Object)"1", (Object)"2"));
    }

    @Test
    public void testJoinPushdownWithLongIdentifiers() {
        BaseJdbcConnectorTest.skipTestUnless((this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_JOIN_PUSHDOWN) ? 1 : 0) != 0);
        String baseColumnName = "col";
        int maxLength = this.maxColumnNameLength().orElse(65541);
        String validColumnName = baseColumnName + "z".repeat(maxLength - baseColumnName.length());
        try (TestTable left = this.newTrinoTable("test_long_id_l", String.format("(%s BIGINT)", validColumnName));
             TestTable right = this.newTrinoTable("test_long_id_r", String.format("(%s BIGINT)", validColumnName));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.joinPushdownEnabled(this.getSession()), "SELECT l.%1$s, r.%1$s\nFROM %2$s l JOIN %3$s r ON l.%1$s = r.%1$s".formatted(validColumnName, left.getName(), right.getName())))).isFullyPushedDown();
        }
    }

    @Test
    public void testDynamicFiltering() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DYNAMIC_FILTER_PUSHDOWN));
        this.assertDynamicFiltering("SELECT * FROM orders a JOIN orders b ON a.orderkey = b.orderkey AND b.totalprice < 1000", OptimizerConfig.JoinDistributionType.BROADCAST);
        this.assertDynamicFiltering("SELECT * FROM orders a JOIN orders b ON a.orderkey = b.orderkey AND b.totalprice < 1000", OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    @Test
    public void testDynamicFilteringWithAggregationGroupingColumn() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DYNAMIC_FILTER_PUSHDOWN));
        this.assertDynamicFiltering("SELECT * FROM (SELECT orderkey, count(*) FROM orders GROUP BY orderkey) a JOIN orders b ON a.orderkey = b.orderkey AND b.totalprice < 1000", OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    @Test
    public void testDynamicFilteringWithAggregationAggregateColumn() {
        this.executeExclusively(this::testDynamicFilteringWithAggregationAggregateColumnUnsafe);
    }

    private void testDynamicFilteringWithAggregationAggregateColumnUnsafe() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DYNAMIC_FILTER_PUSHDOWN));
        QueryRunner.MaterializedResultWithPlan resultWithPlan = this.getDistributedQueryRunner().executeWithPlan(this.getSession(), "SELECT custkey, count(*) count FROM orders GROUP BY custkey");
        boolean isAggregationPushedDown = this.getPhysicalInputPositions(resultWithPlan.queryId()) == 1000L;
        this.assertDynamicFiltering("SELECT * FROM (SELECT custkey, count(*) count FROM orders GROUP BY custkey) a JOIN orders b ON a.count = b.custkey AND b.totalprice < 1000", OptimizerConfig.JoinDistributionType.PARTITIONED, isAggregationPushedDown);
    }

    @Test
    public void testDynamicFilteringWithAggregationGroupingSet() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DYNAMIC_FILTER_PUSHDOWN));
        this.assertNoDynamicFiltering("SELECT * FROM (SELECT orderkey, count(*) FROM orders GROUP BY GROUPING SETS ((orderkey), ())) a JOIN orders b ON a.orderkey = b.orderkey AND b.totalprice < 1000");
    }

    @Test
    public void testDynamicFilteringWithLimit() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DYNAMIC_FILTER_PUSHDOWN));
        this.assertNoDynamicFiltering("SELECT * FROM (SELECT orderkey FROM orders LIMIT 10000000) a JOIN orders b ON a.orderkey = b.orderkey AND b.totalprice < 1000");
    }

    @Test
    public void testDynamicFilteringDomainCompactionThreshold() {
        this.executeExclusively(this::testDynamicFilteringDomainCompactionThresholdUnsafe);
    }

    private void testDynamicFilteringDomainCompactionThresholdUnsafe() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DYNAMIC_FILTER_PUSHDOWN));
        String tableName = "orderkeys_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (orderkey) AS VALUES 30000, 60000", 2L);
        String query = "SELECT * FROM orders a JOIN " + tableName + " b ON a.orderkey = b.orderkey";
        QueryRunner.MaterializedResultWithPlan dynamicFilteringResult = this.getDistributedQueryRunner().executeWithPlan(this.dynamicFiltering(true), query);
        long filteredInputPositions = this.getPhysicalInputPositions(dynamicFilteringResult.queryId());
        QueryRunner.MaterializedResultWithPlan dynamicFilteringWithCompactionThresholdResult = this.getDistributedQueryRunner().executeWithPlan(this.dynamicFilteringWithCompactionThreshold(1), query);
        long smallCompactionInputPositions = this.getPhysicalInputPositions(dynamicFilteringWithCompactionThresholdResult.queryId());
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)dynamicFilteringResult.result(), (Iterable)dynamicFilteringWithCompactionThresholdResult.result(), (String)("For query: \n " + query));
        QueryRunner.MaterializedResultWithPlan noDynamicFilteringResult = this.getDistributedQueryRunner().executeWithPlan(this.dynamicFiltering(false), query);
        long unfilteredInputPositions = this.getPhysicalInputPositions(noDynamicFilteringResult.queryId());
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)dynamicFilteringWithCompactionThresholdResult.result(), (Iterable)noDynamicFilteringResult.result(), (String)("For query: \n " + query));
        ((AbstractLongAssert)Assertions.assertThat((long)unfilteredInputPositions).as("unfiltered input positions", new Object[0])).isGreaterThan(smallCompactionInputPositions);
        ((AbstractLongAssert)Assertions.assertThat((long)smallCompactionInputPositions).as("small compaction input positions", new Object[0])).isGreaterThan(filteredInputPositions);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDynamicFilteringCaseInsensitiveDomainCompaction() {
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        BaseJdbcConnectorTest.skipTestUnless((boolean)this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DYNAMIC_FILTER_PUSHDOWN));
        try (TestTable table = this.newTrinoTable("test_caseinsensitive", "(id varchar(1))", (List)ImmutableList.of((Object)"'0'", (Object)"'a'", (Object)"'B'"));){
            Assertions.assertThat((Object)this.computeActual(this.dynamicFilteringWithCompactionThreshold(1), "SELECT COUNT(*) FROM " + table.getName() + " a JOIN " + table.getName() + " b ON a.id = b.id").getOnlyValue()).isEqualTo((Object)3L);
        }
    }

    @Test
    public void testExecuteProcedure() {
        String tableName = "test_execute" + TestingNames.randomNameSuffix();
        String schemaTableName = (String)this.getSession().getSchema().orElseThrow() + "." + tableName;
        this.assertUpdate("CREATE TABLE " + schemaTableName + "(a int)");
        try {
            this.assertUpdate("CALL system.execute('INSERT INTO " + schemaTableName + " VALUES (1)')");
            this.assertQuery("SELECT * FROM " + schemaTableName, "VALUES 1");
            this.assertUpdate("CALL system.execute('UPDATE " + schemaTableName + " SET a = 2')");
            this.assertQuery("SELECT * FROM " + schemaTableName, "VALUES 2");
            this.assertUpdate("CALL system.execute('DELETE FROM " + schemaTableName + "')");
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + schemaTableName);
            this.assertUpdate("CALL system.execute('DROP TABLE " + schemaTableName + "')");
            Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + schemaTableName);
        }
    }

    @Test
    public void testExecuteProcedureWithNamedArgument() {
        String tableName = "test_execute" + TestingNames.randomNameSuffix();
        String schemaTableName = (String)this.getSession().getSchema().orElseThrow() + "." + tableName;
        this.assertUpdate("CREATE TABLE " + schemaTableName + "(a int)");
        try {
            Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isTrue();
            this.assertUpdate("CALL system.execute(query => 'DROP TABLE " + schemaTableName + "')");
            Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + schemaTableName);
        }
    }

    @Test
    public void testExecuteProcedureWithInvalidQuery() {
        this.assertQueryFails("CALL system.execute('SELECT 1')", "(?s)Failed to execute query.*");
        this.assertQueryFails("CALL system.execute('invalid')", "(?s)Failed to execute query.*");
    }

    protected void assertDynamicFiltering(@Language(value="SQL") String sql, OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertDynamicFiltering(sql, joinDistributionType, true);
    }

    private void assertNoDynamicFiltering(@Language(value="SQL") String sql) {
        this.assertDynamicFiltering(sql, OptimizerConfig.JoinDistributionType.PARTITIONED, false);
    }

    private void assertDynamicFiltering(@Language(value="SQL") String sql, OptimizerConfig.JoinDistributionType joinDistributionType, boolean expectDynamicFiltering) {
        this.executeExclusively(() -> this.assertDynamicFilteringUnsafe(sql, joinDistributionType, expectDynamicFiltering));
    }

    private void assertDynamicFilteringUnsafe(@Language(value="SQL") String sql, OptimizerConfig.JoinDistributionType joinDistributionType, boolean expectDynamicFiltering) {
        QueryRunner.MaterializedResultWithPlan dynamicFilteringResultWithQueryId = this.getDistributedQueryRunner().executeWithPlan(this.dynamicFiltering(joinDistributionType, true), sql);
        QueryRunner.MaterializedResultWithPlan noDynamicFilteringResultWithQueryId = this.getDistributedQueryRunner().executeWithPlan(this.dynamicFiltering(joinDistributionType, false), sql);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)dynamicFilteringResultWithQueryId.result(), (Iterable)noDynamicFilteringResultWithQueryId.result(), (String)("For query: \n " + sql));
        long dynamicFilteringInputPositions = this.getPhysicalInputPositions(dynamicFilteringResultWithQueryId.queryId());
        long noDynamicFilteringInputPositions = this.getPhysicalInputPositions(noDynamicFilteringResultWithQueryId.queryId());
        if (expectDynamicFiltering) {
            ((AbstractLongAssert)Assertions.assertThat((long)dynamicFilteringInputPositions).as("filtered input positions", new Object[0])).isLessThan(noDynamicFilteringInputPositions);
        } else {
            ((AbstractLongAssert)Assertions.assertThat((long)dynamicFilteringInputPositions).as("filtered input positions", new Object[0])).isEqualTo(noDynamicFilteringInputPositions);
        }
    }

    private Session dynamicFiltering(boolean enabled) {
        return this.dynamicFiltering(OptimizerConfig.JoinDistributionType.PARTITIONED, enabled);
    }

    private Session dynamicFilteringWithCompactionThreshold(int compactionThreshold) {
        return Session.builder((Session)this.dynamicFiltering(true)).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "domain_compaction_threshold", Integer.toString(compactionThreshold)).build();
    }

    private Session dynamicFiltering(OptimizerConfig.JoinDistributionType joinDistributionType, boolean enabled) {
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        return Session.builder((Session)this.noJoinReordering(joinDistributionType)).setCatalogSessionProperty(catalogName, "dynamic_filtering_enabled", Boolean.toString(enabled)).setCatalogSessionProperty(catalogName, "dynamic_filtering_wait_timeout", "1h").setCatalogSessionProperty(catalogName, "join_pushdown_enabled", "false").build();
    }

    private long getPhysicalInputPositions(QueryId queryId) {
        return this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getPhysicalInputPositions();
    }
}

