/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.plugin.jdbc.JdbcPlugin;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public final class H2QueryRunner {
    private static final String TPCH_SCHEMA = "tpch";

    private H2QueryRunner() {
    }

    public static QueryRunner createH2QueryRunner(TpchTable<?> ... tables) throws Exception {
        return H2QueryRunner.createH2QueryRunner(ImmutableList.copyOf((Object[])tables));
    }

    public static QueryRunner createH2QueryRunner(Iterable<TpchTable<?>> tables) throws Exception {
        return H2QueryRunner.createH2QueryRunner(tables, TestingH2JdbcModule.createProperties());
    }

    public static QueryRunner createH2QueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> properties) throws Exception {
        return H2QueryRunner.createH2QueryRunner(tables, properties, new TestingH2JdbcModule());
    }

    public static QueryRunner createH2QueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> properties, Module module) throws Exception {
        return H2QueryRunner.createH2QueryRunner(tables, properties, (Map<String, String>)ImmutableMap.of(), module);
    }

    public static QueryRunner createH2QueryRunner(Iterable<TpchTable<?>> tables, Map<String, String> properties, Map<String, String> coordinatorProperties, Module module) throws Exception {
        DistributedQueryRunner queryRunner = null;
        try {
            queryRunner = DistributedQueryRunner.builder((Session)H2QueryRunner.createSession()).setCoordinatorProperties(coordinatorProperties).build();
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
            H2QueryRunner.createSchema(properties, TPCH_SCHEMA);
            queryRunner.installPlugin((Plugin)new JdbcPlugin("base_jdbc", () -> module));
            queryRunner.createCatalog("jdbc", "base_jdbc", properties);
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)TPCH_SCHEMA, (String)"tiny", tables);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    private static void createSchema(Map<String, String> properties, String schema) throws SQLException {
        try (Connection connection = DriverManager.getConnection(properties.get("connection-url"));
             Statement statement = connection.createStatement();){
            statement.execute("CREATE SCHEMA " + schema);
        }
    }

    public static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("jdbc").setSchema(TPCH_SCHEMA).build();
    }
}

