/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.jdbc.JdbcDynamicFilteringConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestJdbcDynamicFilteringConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((JdbcDynamicFilteringConfig)ConfigAssertions.recordDefaults(JdbcDynamicFilteringConfig.class)).setDynamicFilteringEnabled(true).setDynamicFilteringWaitTimeout(new Duration(20.0, TimeUnit.SECONDS)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"dynamic-filtering.enabled", (Object)"false").put((Object)"dynamic-filtering.wait-timeout", (Object)"10m").buildOrThrow();
        JdbcDynamicFilteringConfig expected = new JdbcDynamicFilteringConfig().setDynamicFilteringEnabled(false).setDynamicFilteringWaitTimeout(new Duration(10.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

