/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.testing.Closeables;
import io.trino.plugin.jdbc.BaseJdbcConnectorTableHandle;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcPageSource;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.TestingDatabase;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJdbcPageSource {
    private TestingDatabase database;
    private JdbcClient jdbcClient;
    private JdbcTableHandle table;
    private JdbcSplit split;
    private Map<String, JdbcColumnHandle> columnHandles;
    private ExecutorService executor;

    @BeforeAll
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.jdbcClient = this.database.getJdbcClient();
        this.table = this.database.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"));
        this.split = this.database.getSplit(TestingConnectorSession.SESSION, this.table);
        this.columnHandles = this.database.getColumnHandles(TestingConnectorSession.SESSION, this.table);
        this.executor = MoreExecutors.newDirectExecutorService();
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeables.closeAll((AutoCloseable[])new AutoCloseable[]{this.database, () -> this.executor.shutdownNow()});
        this.database = null;
        this.executor = null;
    }

    @Test
    public void testCursorSimple() {
        try (JdbcPageSource pageSource = this.createPageSource((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("text"), (Object)this.columnHandles.get("text_short"), (Object)this.columnHandles.get("value")));){
            Assertions.assertThat((boolean)pageSource.isBlocked().isDone()).isTrue();
            LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
            SourcePage page = pageSource.getNextSourcePage();
            while (true) {
                if (page != null) {
                    for (int position = 0; position < page.getPositionCount(); ++position) {
                        Assertions.assertThat((boolean)page.getBlock(0).isNull(position)).isFalse();
                        Assertions.assertThat((boolean)page.getBlock(1).isNull(position)).isFalse();
                        Assertions.assertThat((boolean)page.getBlock(2).isNull(position)).isFalse();
                        Assertions.assertThat((Comparable)VarcharType.VARCHAR.getSlice(page.getBlock(0), position)).isEqualTo((Object)VarcharType.VARCHAR.getSlice(page.getBlock(1), position));
                        data.put(VarcharType.VARCHAR.getSlice(page.getBlock(0), position).toStringUtf8(), BigintType.BIGINT.getLong(page.getBlock(2), position));
                    }
                    if (pageSource.isFinished()) break;
                }
                page = pageSource.getNextSourcePage();
            }
            Assertions.assertThat(data).isEqualTo((Object)ImmutableMap.builder().put((Object)"one", (Object)1L).put((Object)"two", (Object)2L).put((Object)"three", (Object)3L).put((Object)"ten", (Object)10L).put((Object)"eleven", (Object)11L).put((Object)"twelve", (Object)12L).buildOrThrow());
            Assertions.assertThat((long)pageSource.getReadTimeNanos()).isPositive();
        }
    }

    @Test
    public void testCursorMixedOrder() {
        try (JdbcPageSource pageSource = this.createPageSource((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("text")));){
            LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
            SourcePage page = pageSource.getNextSourcePage();
            while (true) {
                if (page != null) {
                    for (int position = 0; position < page.getPositionCount(); ++position) {
                        Assertions.assertThat((long)BigintType.BIGINT.getLong(page.getBlock(0), position)).isEqualTo(BigintType.BIGINT.getLong(page.getBlock(1), position));
                        data.put(VarcharType.VARCHAR.getSlice(page.getBlock(2), position).toStringUtf8(), BigintType.BIGINT.getLong(page.getBlock(0), position));
                    }
                    if (pageSource.isFinished()) break;
                }
                page = pageSource.getNextSourcePage();
            }
            Assertions.assertThat(data).isEqualTo((Object)ImmutableMap.builder().put((Object)"one", (Object)1L).put((Object)"two", (Object)2L).put((Object)"three", (Object)3L).put((Object)"ten", (Object)10L).put((Object)"eleven", (Object)11L).put((Object)"twelve", (Object)12L).buildOrThrow());
            Assertions.assertThat((long)pageSource.getReadTimeNanos()).isPositive();
        }
    }

    @Test
    public void testIdempotentClose() {
        JdbcPageSource pageSource = this.createPageSource((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("text")));
        pageSource.close();
        pageSource.close();
    }

    @Test
    public void testGetNextPageAfterClose() {
        JdbcPageSource pageSource = this.createPageSource((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("text")));
        pageSource.close();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((JdbcPageSource)pageSource).getNextSourcePage()).isInstanceOf(TrinoException.class)).hasMessageContaining("page source is closed");
        Assertions.assertThat((boolean)pageSource.isBlocked().isDone()).isTrue();
    }

    @Test
    public void testGetNextPageAfterFinish() {
        JdbcPageSource pageSource = this.createPageSource((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("text")));
        while (!pageSource.isFinished()) {
            pageSource.getNextSourcePage();
        }
        Assertions.assertThat((Object)pageSource.getNextSourcePage()).isNull();
        Assertions.assertThat((boolean)pageSource.isBlocked().isDone()).isTrue();
    }

    private JdbcPageSource createPageSource(List<JdbcColumnHandle> columnHandles) {
        return new JdbcPageSource(this.jdbcClient, this.executor, TestingConnectorSession.SESSION, this.split, (BaseJdbcConnectorTableHandle)this.table, columnHandles);
    }
}

