/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import dev.failsafe.RetryPolicy;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slices;
import io.airlift.testing.Closeables;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcPageSourceProvider;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTransactionHandle;
import io.trino.plugin.jdbc.TestingDatabase;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJdbcPageSourceProvider {
    private static final ConnectorSession SESSION = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig(), Optional.empty()).getSessionProperties()).build();
    private TestingDatabase database;
    private JdbcClient jdbcClient;
    private JdbcSplit split;
    private JdbcTableHandle table;
    private JdbcColumnHandle textColumn;
    private JdbcColumnHandle textShortColumn;
    private JdbcColumnHandle valueColumn;
    private ExecutorService executor;

    @BeforeAll
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.jdbcClient = this.database.getJdbcClient();
        this.table = this.database.getTableHandle(SESSION, new SchemaTableName("example", "numbers"));
        this.split = this.database.getSplit(SESSION, this.table);
        Map<String, JdbcColumnHandle> columns = this.database.getColumnHandles(SESSION, this.table);
        this.textColumn = columns.get("text");
        this.textShortColumn = columns.get("text_short");
        this.valueColumn = columns.get("value");
        this.executor = MoreExecutors.newDirectExecutorService();
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeables.closeAll((AutoCloseable[])new AutoCloseable[]{this.database, () -> this.executor.shutdownNow()});
        this.database = null;
        this.executor = null;
    }

    @Test
    public void testGetPageSource() {
        JdbcTransactionHandle transaction = new JdbcTransactionHandle();
        JdbcPageSourceProvider pageSourceProvider = new JdbcPageSourceProvider(this.jdbcClient, this.executor, RetryPolicy.ofDefaults());
        ConnectorPageSource pageSource = pageSourceProvider.createPageSource((ConnectorTransactionHandle)transaction, SESSION, (ConnectorSplit)this.split, (ConnectorTableHandle)this.table, (List)ImmutableList.of((Object)this.textColumn, (Object)this.textShortColumn, (Object)this.valueColumn), DynamicFilter.EMPTY);
        ((ObjectAssert)Assertions.assertThat((Object)pageSource).withFailMessage("pageSource is null", new Object[0])).isNotNull();
        LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
        SourcePage page = pageSource.getNextSourcePage();
        while (true) {
            if (page != null) {
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    Assertions.assertThat((Comparable)VarcharType.VARCHAR.getSlice(page.getBlock(0), position)).isEqualTo((Object)VarcharType.VARCHAR.getSlice(page.getBlock(1), position));
                    data.put(VarcharType.VARCHAR.getSlice(page.getBlock(0), position).toStringUtf8(), BigintType.BIGINT.getLong(page.getBlock(2), position));
                }
                if (pageSource.isFinished()) break;
            }
            page = pageSource.getNextSourcePage();
        }
        Assertions.assertThat(data).isEqualTo((Object)ImmutableMap.builder().put((Object)"one", (Object)1L).put((Object)"two", (Object)2L).put((Object)"three", (Object)3L).put((Object)"ten", (Object)10L).put((Object)"eleven", (Object)11L).put((Object)"twelve", (Object)12L).buildOrThrow());
    }

    @Test
    public void testTupleDomain() {
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.union((List)ImmutableList.of((Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"bar")))))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")), (Range[])new Range[0]), (boolean)false))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")), (Range[])new Range[0]), (boolean)false))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")), (Range[])new Range[0]), (boolean)false))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")), (Range[])new Range[0]), (boolean)false))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.onlyNull((Type)VarcharType.VARCHAR))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.notNull((Type)VarcharType.VARCHAR))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.union((List)ImmutableList.of((Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo")), (Object)Domain.onlyNull((Type)VarcharType.VARCHAR))))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"bar"), (boolean)true, (Object)Slices.utf8Slice((String)"foo"), (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.textShortColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"bar"), (boolean)true, (Object)Slices.utf8Slice((String)"foo"), (boolean)true), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"hello"), (boolean)false, (Object)Slices.utf8Slice((String)"world"), (boolean)false)}), (boolean)false), (Object)this.textShortColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createVarcharType((int)32), (Object)Slices.utf8Slice((String)"bar"), (boolean)true, (Object)Slices.utf8Slice((String)"foo"), (boolean)true), (Range[])new Range[]{Range.range((Type)VarcharType.createVarcharType((int)32), (Object)Slices.utf8Slice((String)"hello"), (boolean)false, (Object)Slices.utf8Slice((String)"world"), (boolean)false)}), (boolean)false))));
        this.getCursor(this.table, (List<ColumnHandle>)ImmutableList.of((Object)this.textColumn, (Object)this.valueColumn), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.textColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"bar"), (boolean)true, (Object)Slices.utf8Slice((String)"foo"), (boolean)true), (Range[])new Range[]{Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"hello"), (boolean)false, (Object)Slices.utf8Slice((String)"world"), (boolean)false), Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"apple")), Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"banana")), Range.equal((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"zoo"))}), (boolean)false), (Object)this.valueColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)5L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)20L, (boolean)false)}), (boolean)true))));
    }

    private ConnectorPageSource getCursor(JdbcTableHandle jdbcTableHandle, List<ColumnHandle> columns, TupleDomain<ColumnHandle> domain) {
        jdbcTableHandle = new JdbcTableHandle(jdbcTableHandle.getRelationHandle(), domain, (List)ImmutableList.of(), Optional.empty(), OptionalLong.empty(), Optional.empty(), jdbcTableHandle.getOtherReferencedTables(), jdbcTableHandle.getNextSyntheticColumnId(), Optional.empty(), (List)ImmutableList.of());
        ConnectorSplitSource splits = this.jdbcClient.getSplits(SESSION, jdbcTableHandle);
        JdbcSplit split = (JdbcSplit)Iterables.getOnlyElement((Iterable)((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)splits.getNextBatch(1000))).getSplits());
        JdbcTransactionHandle transaction = new JdbcTransactionHandle();
        JdbcPageSourceProvider pageSourceProvider = new JdbcPageSourceProvider(this.jdbcClient, this.executor, RetryPolicy.ofDefaults());
        return pageSourceProvider.createPageSource((ConnectorTransactionHandle)transaction, SESSION, (ConnectorSplit)split, (ConnectorTableHandle)jdbcTableHandle, columns, DynamicFilter.EMPTY);
    }
}

