/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.jdbc.JdbcWriteConfig;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJdbcWriteConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((JdbcWriteConfig)ConfigAssertions.recordDefaults(JdbcWriteConfig.class)).setWriteBatchSize(1000).setWriteParallelism(8).setNonTransactionalInsert(false).setNonTransactionalMerge(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"write.batch-size", (Object)"24").put((Object)"insert.non-transactional-insert.enabled", (Object)"true").put((Object)"merge.non-transactional-merge.enabled", (Object)"true").put((Object)"write.parallelism", (Object)"16").buildOrThrow();
        JdbcWriteConfig expected = new JdbcWriteConfig().setWriteBatchSize(24).setNonTransactionalInsert(true).setNonTransactionalMerge(true).setWriteParallelism(16);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testWriteBatchSizeValidation() {
        Assertions.assertThatThrownBy(() -> TestJdbcWriteConfig.makeConfig((Map<String, String>)ImmutableMap.of((Object)"write.batch-size", (Object)"-42"))).hasMessageContaining("write.batch-size: must be greater than or equal to 1");
        Assertions.assertThatThrownBy(() -> TestJdbcWriteConfig.makeConfig((Map<String, String>)ImmutableMap.of((Object)"write.batch-size", (Object)"0"))).hasMessageContaining("write.batch-size: must be greater than or equal to 1");
        Assertions.assertThatThrownBy(() -> TestJdbcWriteConfig.makeConfig((Map<String, String>)ImmutableMap.of((Object)"write.batch-size", (Object)String.valueOf(10000001)))).hasMessageContaining("write.batch-size: must be less than or equal to");
        Assertions.assertThatCode(() -> TestJdbcWriteConfig.makeConfig((Map<String, String>)ImmutableMap.of((Object)"write.batch-size", (Object)"1"))).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> TestJdbcWriteConfig.makeConfig((Map<String, String>)ImmutableMap.of((Object)"write.batch-size", (Object)"42"))).doesNotThrowAnyException();
    }

    private static JdbcWriteConfig makeConfig(Map<String, String> props) {
        return (JdbcWriteConfig)new ConfigurationFactory(props).build(JdbcWriteConfig.class);
    }
}

