/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.trino.benchmark.AbstractSimpleOperatorBenchmark;
import io.trino.benchmark.BenchmarkAggregationFunction;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.operator.HashAggregationOperator;
import io.trino.operator.OperatorFactory;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.LocalQueryRunner;
import java.util.List;
import java.util.Optional;

public class HashAggregationBenchmark
extends AbstractSimpleOperatorBenchmark {
    private final BenchmarkAggregationFunction doubleSum = this.createAggregationFunction("sum", new Type[]{DoubleType.DOUBLE});

    public HashAggregationBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_agg", 5, 25);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        List<Type> tableTypes = this.getColumnTypes("orders", "orderstatus", "totalprice");
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderstatus", "totalprice");
        HashAggregationOperator.HashAggregationOperatorFactory aggregationOperator = new HashAggregationOperator.HashAggregationOperatorFactory(1, new PlanNodeId("test"), (List)ImmutableList.of((Object)tableTypes.get(0)), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)this.doubleSum.bind((List<Integer>)ImmutableList.of((Object)1))), Optional.empty(), Optional.empty(), 100000, Optional.of(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), new JoinCompiler(this.localQueryRunner.getTypeOperators()), this.localQueryRunner.getBlockTypeOperators(), false);
        return ImmutableList.of((Object)tableScanOperator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HashAggregationBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

