/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.AggregationNode;
import java.util.List;
import java.util.OptionalInt;

public class BenchmarkAggregationFunction {
    private final Type intermediateType;
    private final AccumulatorFactory accumulatorFactory;
    private final Type finalType;

    public BenchmarkAggregationFunction(ResolvedFunction resolvedFunction, AggregationMetadata aggregationMetadata) {
        BoundSignature signature = resolvedFunction.getSignature();
        this.intermediateType = ((AggregationMetadata.AccumulatorStateDescriptor)Iterables.getOnlyElement((Iterable)aggregationMetadata.getAccumulatorStateDescriptors())).getSerializer().getSerializedType();
        this.finalType = signature.getReturnType();
        this.accumulatorFactory = AccumulatorCompiler.generateAccumulatorFactory((BoundSignature)signature, (AggregationMetadata)aggregationMetadata, (FunctionNullability)resolvedFunction.getFunctionNullability());
    }

    public AggregatorFactory bind(List<Integer> inputChannels) {
        return new AggregatorFactory(this.accumulatorFactory, AggregationNode.Step.SINGLE, this.intermediateType, this.finalType, inputChannels, OptionalInt.empty(), true, (List)ImmutableList.of());
    }
}

