/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.benchmark.AbstractSimpleOperatorBenchmark;
import io.trino.benchmark.BenchmarkAggregationFunction;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.operator.AggregationOperator;
import io.trino.operator.FilterAndProjectOperator;
import io.trino.operator.OperatorFactory;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.PageFilter;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.testing.LocalQueryRunner;
import io.trino.util.DateTimeUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class HandTpchQuery6
extends AbstractSimpleOperatorBenchmark {
    private final BenchmarkAggregationFunction doubleSum = this.createAggregationFunction("sum", new Type[]{DoubleType.DOUBLE});

    public HandTpchQuery6(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_6", 10, 100);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "extendedprice", "discount", "shipdate", "quantity");
        Supplier projection = new PageFunctionCompiler(this.localQueryRunner.getFunctionManager(), 0).compileProjection((RowExpression)Expressions.field((int)0, (Type)BigintType.BIGINT), Optional.empty());
        OperatorFactory tpchQuery6Operator = FilterAndProjectOperator.createOperatorFactory((int)1, (PlanNodeId)new PlanNodeId("test"), () -> HandTpchQuery6.lambda$createOperatorFactories$0((Supplier)projection), (List)ImmutableList.of((Object)DoubleType.DOUBLE), (DataSize)DataSize.ofBytes((long)0L), (int)0);
        AggregationOperator.AggregationOperatorFactory aggregationOperator = new AggregationOperator.AggregationOperatorFactory(2, new PlanNodeId("test"), (List)ImmutableList.of((Object)this.doubleSum.bind((List<Integer>)ImmutableList.of((Object)0))));
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery6Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery6(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    private static /* synthetic */ PageProcessor lambda$createOperatorFactories$0(Supplier projection) {
        return new PageProcessor(Optional.of(new TpchQuery6Filter()), (List)ImmutableList.of((Object)((PageProjection)projection.get())));
    }

    public static class TpchQuery6Filter
    implements PageFilter {
        private static final int MIN_SHIP_DATE = DateTimeUtils.parseDate((String)"1994-01-01");
        private static final int MAX_SHIP_DATE = DateTimeUtils.parseDate((String)"1995-01-01");
        private static final InputChannels INPUT_CHANNELS = new InputChannels(new int[]{1, 2, 3});
        private boolean[] selectedPositions = new boolean[0];

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return INPUT_CHANNELS;
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            if (this.selectedPositions.length < page.getPositionCount()) {
                this.selectedPositions = new boolean[page.getPositionCount()];
            }
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.selectedPositions[position] = TpchQuery6Filter.filter(page, position);
            }
            return PageFilter.positionsArrayToSelectedPositions((boolean[])this.selectedPositions, (int)page.getPositionCount());
        }

        private static boolean filter(Page page, int position) {
            Block discountBlock = page.getBlock(0);
            Block shipDateBlock = page.getBlock(1);
            Block quantityBlock = page.getBlock(2);
            return !shipDateBlock.isNull(position) && DateType.DATE.getLong(shipDateBlock, position) >= (long)MIN_SHIP_DATE && !shipDateBlock.isNull(position) && DateType.DATE.getLong(shipDateBlock, position) < (long)MAX_SHIP_DATE && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && BigintType.BIGINT.getLong(quantityBlock, position) < 24L;
        }
    }
}

