/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.Session;
import io.trino.benchmark.AbstractOperatorBenchmark;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.operator.Driver;
import io.trino.operator.DriverFactory;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.TaskContext;
import io.trino.operator.TrinoOperatorFactories;
import io.trino.operator.ValuesOperator;
import io.trino.operator.join.HashBuilderOperator;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.PartitionedLookupSourceFactory;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.NullOutputOperator;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class HashBuildBenchmark
extends AbstractOperatorBenchmark {
    private final OperatorFactories operatorFactories;

    public HashBuildBenchmark(LocalQueryRunner localQueryRunner) {
        this(localQueryRunner, (OperatorFactories)new TrinoOperatorFactories());
    }

    public HashBuildBenchmark(LocalQueryRunner localQueryRunner, OperatorFactories operatorFactories) {
        super(localQueryRunner, "hash_build", 4, 5);
        this.operatorFactories = Objects.requireNonNull(operatorFactories, "operatorFactories is null");
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        List<Type> ordersTypes = this.getColumnTypes("orders", "orderkey", "totalprice");
        OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(new TypeOperators());
        JoinBridgeManager lookupSourceFactoryManager = JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory(ordersTypes, (List)ImmutableList.of((Object)0, (Object)1).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), (List)Ints.asList((int[])new int[]{0}).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), 1, false, blockTypeOperators));
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(1, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)0, (Object)1), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory(), HashArraySizeSupplier.incrementalLoadFactorHashArraySizeSupplier((Session)this.session));
        DriverFactory hashBuildDriverFactory = new DriverFactory(0, true, true, (List)ImmutableList.of((Object)ordersTableScan, (Object)hashBuilder), OptionalInt.empty());
        ImmutableList.Builder joinDriversBuilder = ImmutableList.builder();
        joinDriversBuilder.add((Object)new ValuesOperator.ValuesOperatorFactory(0, new PlanNodeId("values"), (List)ImmutableList.of()));
        OperatorFactory joinOperator = this.operatorFactories.innerJoin(2, new PlanNodeId("test"), lookupSourceFactoryManager, false, false, false, true, (List)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), OptionalInt.empty(), PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), blockTypeOperators);
        joinDriversBuilder.add((Object)joinOperator);
        joinDriversBuilder.add((Object)new NullOutputOperator.NullOutputOperatorFactory(3, new PlanNodeId("test")));
        DriverFactory joinDriverFactory = new DriverFactory(1, true, true, (List)joinDriversBuilder.build(), OptionalInt.empty());
        Driver hashBuildDriver = hashBuildDriverFactory.createDriver(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        hashBuildDriverFactory.noMoreDrivers();
        Driver joinDriver = joinDriverFactory.createDriver(taskContext.addPipelineContext(1, true, true, false).addDriverContext());
        joinDriverFactory.noMoreDrivers();
        return ImmutableList.of((Object)hashBuildDriver, (Object)joinDriver);
    }

    public static void main(String[] args) {
        new HashBuildBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

