/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.trino.benchmark.BenchmarkResultHook;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;

public class JsonBenchmarkResultWriter
implements BenchmarkResultHook {
    private final JsonGenerator jsonGenerator;

    public JsonBenchmarkResultWriter(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream is null");
        try {
            this.jsonGenerator = new JsonFactory().createGenerator(outputStream, JsonEncoding.UTF8);
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeArrayFieldStart("samples");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public BenchmarkResultHook addResults(Map<String, Long> results) {
        Objects.requireNonNull(results, "results is null");
        try {
            this.jsonGenerator.writeStartObject();
            for (Map.Entry<String, Long> entry : results.entrySet()) {
                this.jsonGenerator.writeNumberField(entry.getKey(), entry.getValue().longValue());
            }
            this.jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public void finished() {
        try {
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.writeEndObject();
            this.jsonGenerator.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

