/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.benchmark.AverageBenchmarkResults;
import io.trino.benchmark.BenchmarkResultHook;
import io.trino.benchmark.FormatUtils;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class AbstractBenchmark {
    private final String benchmarkName;
    private final int warmupIterations;
    private final int measuredIterations;

    protected AbstractBenchmark(String benchmarkName, int warmupIterations, int measuredIterations) {
        Objects.requireNonNull(benchmarkName, "benchmarkName is null");
        Preconditions.checkArgument((warmupIterations >= 0 ? 1 : 0) != 0, (Object)"warmupIterations must not be negative");
        Preconditions.checkArgument((measuredIterations >= 0 ? 1 : 0) != 0, (Object)"measuredIterations must not be negative");
        this.benchmarkName = benchmarkName;
        this.warmupIterations = warmupIterations;
        this.measuredIterations = measuredIterations;
    }

    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    protected void setUp() {
    }

    protected abstract Map<String, Long> runOnce();

    protected void tearDown() {
    }

    public void runBenchmark() {
        this.runBenchmark(null);
    }

    public void runBenchmark(@Nullable BenchmarkResultHook benchmarkResultHook) {
        AverageBenchmarkResults averageBenchmarkResults = new AverageBenchmarkResults();
        this.setUp();
        try {
            int i;
            for (i = 0; i < this.warmupIterations; ++i) {
                this.runOnce();
            }
            for (i = 0; i < this.measuredIterations; ++i) {
                Map<String, Long> results = this.runOnce();
                if (benchmarkResultHook != null) {
                    benchmarkResultHook.addResults(results);
                }
                averageBenchmarkResults.addResults(results);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Exception in " + this.getBenchmarkName(), t);
        }
        finally {
            this.tearDown();
        }
        if (benchmarkResultHook != null) {
            benchmarkResultHook.finished();
        }
        Map<String, Double> resultsAvg = averageBenchmarkResults.getAverageResultsValues();
        Duration cpuNanos = new Duration(resultsAvg.get("cpu_nanos").doubleValue(), TimeUnit.NANOSECONDS);
        long inputRows = resultsAvg.get("input_rows").longValue();
        DataSize inputBytes = DataSize.ofBytes((long)Math.round(resultsAvg.get("input_bytes")));
        long outputRows = resultsAvg.get("output_rows").longValue();
        DataSize outputBytes = DataSize.ofBytes((long)Math.round(resultsAvg.get("output_bytes")));
        DataSize memory = DataSize.ofBytes((long)Math.round(resultsAvg.get("peak_memory")));
        System.out.printf("%35s :: %8.3f cpu ms :: %5s peak memory :: in %5s,  %6s,  %8s,  %8s :: out %5s,  %6s,  %8s,  %8s%n", this.getBenchmarkName(), cpuNanos.getValue(TimeUnit.MILLISECONDS), FormatUtils.formatDataSize(memory, true), FormatUtils.formatCount(inputRows), FormatUtils.formatDataSize(inputBytes, true), FormatUtils.formatCountRate(inputRows, cpuNanos, true), FormatUtils.formatDataRate(inputBytes, cpuNanos, true), FormatUtils.formatCount(outputRows), FormatUtils.formatDataSize(outputBytes, true), FormatUtils.formatCountRate(outputRows, cpuNanos, true), FormatUtils.formatDataRate(outputBytes, cpuNanos, true));
    }
}

