/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import io.trino.benchmark.BenchmarkResultHook;
import io.trino.plugin.base.util.JsonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;

public class OdsBenchmarkResultWriter
implements BenchmarkResultHook {
    private final String entity;
    private final JsonGenerator jsonGenerator;

    public OdsBenchmarkResultWriter(String entity, OutputStream outputStream) {
        Objects.requireNonNull(entity, "entity is null");
        Objects.requireNonNull(outputStream, "outputStream is null");
        this.entity = entity;
        try {
            this.jsonGenerator = JsonUtils.jsonFactory().createGenerator(outputStream, JsonEncoding.UTF8);
            this.jsonGenerator.writeStartArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public BenchmarkResultHook addResults(Map<String, Long> results) {
        Objects.requireNonNull(results, "results is null");
        try {
            for (Map.Entry<String, Long> entry : results.entrySet()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("entity", this.entity);
                this.jsonGenerator.writeStringField("key", entry.getKey());
                this.jsonGenerator.writeNumberField("value", entry.getValue().longValue());
                this.jsonGenerator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    @Override
    public void finished() {
        try {
            this.jsonGenerator.writeEndArray();
            this.jsonGenerator.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

