/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.MoreFutures;
import io.airlift.stats.CpuTimer;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.benchmark.AbstractBenchmark;
import io.trino.benchmark.BenchmarkAggregationFunction;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.executor.timesharing.PrioritizedSplitRunner;
import io.trino.memory.MemoryPool;
import io.trino.memory.QueryContext;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.FilterAndProjectOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PageSourceOperator;
import io.trino.operator.TaskContext;
import io.trino.operator.TaskStats;
import io.trino.operator.project.InputPageProjection;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProjection;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spiller.SpillSpaceTracker;
import io.trino.split.SplitSource;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.HashGenerationOptimizer;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.sql.tree.Expression;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOperatorBenchmark
extends AbstractBenchmark {
    protected final LocalQueryRunner localQueryRunner;
    protected final Session session;

    protected AbstractOperatorBenchmark(LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        this(localQueryRunner.getDefaultSession(), localQueryRunner, benchmarkName, warmupIterations, measuredIterations);
    }

    protected AbstractOperatorBenchmark(Session session, LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        super(benchmarkName, warmupIterations, measuredIterations);
        this.localQueryRunner = Objects.requireNonNull(localQueryRunner, "localQueryRunner is null");
        TransactionId transactionId = localQueryRunner.getTransactionManager().beginTransaction(false);
        this.session = session.beginTransactionId(transactionId, localQueryRunner.getTransactionManager(), (AccessControl)new AllowAllAccessControl());
    }

    @Override
    protected void tearDown() {
        this.localQueryRunner.getTransactionManager().asyncAbort(this.session.getRequiredTransactionId());
        super.tearDown();
    }

    protected final List<Type> getColumnTypes(String tableName, String ... columnNames) {
        Preconditions.checkState((boolean)this.session.getCatalog().isPresent(), (Object)"catalog not set");
        Preconditions.checkState((boolean)this.session.getSchema().isPresent(), (Object)"schema not set");
        Metadata metadata = this.localQueryRunner.getMetadata();
        QualifiedObjectName qualifiedTableName = new QualifiedObjectName((String)this.session.getCatalog().get(), (String)this.session.getSchema().get(), tableName);
        TableHandle tableHandle = (TableHandle)metadata.getTableHandle(this.session, qualifiedTableName).orElseThrow(() -> new IllegalArgumentException(String.format("Table '%s' does not exist", qualifiedTableName)));
        Map allColumnHandles = metadata.getColumnHandles(this.session, tableHandle);
        return (List)Arrays.stream(columnNames).map(allColumnHandles::get).map(columnHandle -> metadata.getColumnMetadata(this.session, tableHandle, columnHandle).getType()).collect(ImmutableList.toImmutableList());
    }

    protected final BenchmarkAggregationFunction createAggregationFunction(String name, Type ... argumentTypes) {
        ResolvedFunction resolvedFunction = this.localQueryRunner.getMetadata().resolveBuiltinFunction(name, TypeSignatureProvider.fromTypes((Type[])argumentTypes));
        AggregationImplementation aggregationImplementation = this.localQueryRunner.getFunctionManager().getAggregationImplementation(resolvedFunction);
        return new BenchmarkAggregationFunction(resolvedFunction, aggregationImplementation);
    }

    protected final OperatorFactory createTableScanOperator(final int operatorId, final PlanNodeId planNodeId, String tableName, String ... columnNames) {
        Preconditions.checkArgument((boolean)this.session.getCatalog().isPresent(), (Object)"catalog not set");
        Preconditions.checkArgument((boolean)this.session.getSchema().isPresent(), (Object)"schema not set");
        Metadata metadata = this.localQueryRunner.getMetadata();
        QualifiedObjectName qualifiedTableName = new QualifiedObjectName((String)this.session.getCatalog().get(), (String)this.session.getSchema().get(), tableName);
        final TableHandle tableHandle = metadata.getTableHandle(this.session, qualifiedTableName).orElse(null);
        Preconditions.checkArgument((tableHandle != null ? 1 : 0) != 0, (String)"Table '%s' does not exist", (Object)qualifiedTableName);
        Map allColumnHandles = metadata.getColumnHandles(this.session, tableHandle);
        ImmutableList.Builder columnHandlesBuilder = ImmutableList.builder();
        for (String columnName : columnNames) {
            ColumnHandle columnHandle = (ColumnHandle)allColumnHandles.get(columnName);
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Table '%s' does not have a column '%s'", (Object)tableName, (Object)columnName);
            columnHandlesBuilder.add((Object)columnHandle);
        }
        ImmutableList columnHandles = columnHandlesBuilder.build();
        final Split split = this.getLocalQuerySplit(this.session, tableHandle);
        return new OperatorFactory(){
            final /* synthetic */ List val$columnHandles;
            {
                this.val$columnHandles = list;
            }

            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(operatorId, planNodeId, "BenchmarkSource");
                ConnectorPageSource pageSource = AbstractOperatorBenchmark.this.localQueryRunner.getPageSourceManager().createPageSource(AbstractOperatorBenchmark.this.session, split, tableHandle, this.val$columnHandles, DynamicFilter.EMPTY);
                return new PageSourceOperator(pageSource, operatorContext);
            }

            public void noMoreOperators() {
            }

            public OperatorFactory duplicate() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Split getLocalQuerySplit(Session session, TableHandle handle) {
        SplitSource splitSource = this.localQueryRunner.getSplitManager().getSplits(session, Span.getInvalid(), handle, DynamicFilter.EMPTY, Constraint.alwaysTrue());
        ArrayList<Split> splits = new ArrayList<Split>();
        while (!splitSource.isFinished()) {
            splits.addAll(AbstractOperatorBenchmark.getNextBatch(splitSource));
        }
        Preconditions.checkArgument((splits.size() == 1 ? 1 : 0) != 0, (String)"Expected only one split for a local query, but got %s splits", (int)splits.size());
        return (Split)splits.get(0);
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue((Future)splitSource.getNextBatch(1000))).getSplits();
    }

    protected final OperatorFactory createHashProjectOperator(int operatorId, PlanNodeId planNodeId, List<Type> types) {
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        ImmutableMap.Builder symbolToInputMapping = ImmutableMap.builder();
        ImmutableList.Builder projections = ImmutableList.builder();
        for (int channel = 0; channel < types.size(); ++channel) {
            Symbol symbol = symbolAllocator.newSymbol("h" + channel, types.get(channel));
            symbolToInputMapping.put((Object)symbol, (Object)channel);
            projections.add((Object)new InputPageProjection(channel, types.get(channel)));
        }
        Map symbolTypes = symbolAllocator.getTypes().allTypes();
        Optional hashExpression = HashGenerationOptimizer.getHashExpression((Metadata)this.localQueryRunner.getMetadata(), (SymbolAllocator)symbolAllocator, (List)ImmutableList.copyOf(symbolTypes.keySet()));
        Verify.verify((boolean)hashExpression.isPresent());
        Map expressionTypes = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.localQueryRunner.getPlannerContext()).getTypes(this.session, TypeProvider.copyOf((Map)symbolTypes), (Expression)hashExpression.get());
        RowExpression translated = SqlToRowExpressionTranslator.translate((Expression)((Expression)hashExpression.get()), (Map)expressionTypes, (Map)symbolToInputMapping.buildOrThrow(), (Metadata)this.localQueryRunner.getMetadata(), (FunctionManager)this.localQueryRunner.getFunctionManager(), (Session)this.session, (boolean)false);
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler(this.localQueryRunner.getFunctionManager(), 0);
        projections.add((Object)((PageProjection)functionCompiler.compileProjection(translated, Optional.empty()).get()));
        return FilterAndProjectOperator.createOperatorFactory((int)operatorId, (PlanNodeId)planNodeId, () -> new PageProcessor(Optional.empty(), (List)projections.build()), (List)ImmutableList.copyOf((Iterable)Iterables.concat(types, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))), (DataSize)SystemSessionProperties.getFilterAndProjectMinOutputPageSize((Session)this.session), (int)SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount((Session)this.session));
    }

    protected abstract List<Driver> createDrivers(TaskContext var1);

    protected Map<String, Long> execute(TaskContext taskContext) {
        List<Driver> drivers = this.createDrivers(taskContext);
        long peakMemory = 0L;
        boolean done = false;
        while (!done) {
            boolean processed = false;
            for (Driver driver : drivers) {
                if (driver.isFinished()) continue;
                driver.processForDuration(PrioritizedSplitRunner.SPLIT_RUN_QUANTA);
                long lastPeakMemory = peakMemory;
                peakMemory = taskContext.getTaskStats().getUserMemoryReservation().toBytes();
                if (peakMemory <= lastPeakMemory) {
                    peakMemory = lastPeakMemory;
                }
                processed = true;
            }
            done = !processed;
        }
        return ImmutableMap.of((Object)"peak_memory", (Object)peakMemory);
    }

    @Override
    protected Map<String, Long> runOnce() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("optimizer.optimize-hash-generation", "true").setTransactionId(this.session.getRequiredTransactionId()).build();
        MemoryPool memoryPool = new MemoryPool(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        TaskContext taskContext = new QueryContext(new QueryId("test"), DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.localQueryRunner.getExecutor(), this.localQueryRunner.getScheduler(), DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE), spillSpaceTracker).addTaskContext(new TaskStateMachine(new TaskId(new StageId("query", 0), 0, 0), (Executor)this.localQueryRunner.getExecutor()), session, () -> {}, false, false);
        CpuTimer cpuTimer = new CpuTimer();
        Map<String, Long> executionStats = this.execute(taskContext);
        CpuTimer.CpuDuration executionTime = cpuTimer.elapsedTime();
        TaskStats taskStats = taskContext.getTaskStats();
        long inputRows = taskStats.getRawInputPositions();
        long inputBytes = taskStats.getRawInputDataSize().toBytes();
        long outputRows = taskStats.getOutputPositions();
        long outputBytes = taskStats.getOutputDataSize().toBytes();
        double inputMegaBytes = (double)inputBytes / (double)DataSize.Unit.MEGABYTE.inBytes();
        return ImmutableMap.builder().putAll(executionStats).put((Object)"elapsed_millis", (Object)executionTime.getWall().toMillis()).put((Object)"input_rows_per_second", (Object)((long)((double)inputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"output_rows_per_second", (Object)((long)((double)outputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"input_megabytes", (Object)((long)inputMegaBytes)).put((Object)"input_megabytes_per_second", (Object)((long)(inputMegaBytes / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"wall_nanos", (Object)executionTime.getWall().roundTo(TimeUnit.NANOSECONDS)).put((Object)"cpu_nanos", (Object)executionTime.getCpu().roundTo(TimeUnit.NANOSECONDS)).put((Object)"user_nanos", (Object)executionTime.getUser().roundTo(TimeUnit.NANOSECONDS)).put((Object)"input_rows", (Object)inputRows).put((Object)"input_bytes", (Object)inputBytes).put((Object)"output_rows", (Object)outputRows).put((Object)"output_bytes", (Object)outputBytes).buildOrThrow();
    }
}

