/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import io.trino.benchmark.AbstractSqlBenchmark;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.testing.LocalQueryRunner;

public abstract class ArrayComparisonBenchmark {
    public static void main(String ... args) {
        LocalQueryRunner localQueryRunner = BenchmarkQueryRunner.createLocalQueryRunner();
        new ArrayEqualsBenchmark(localQueryRunner).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new ArrayLessThanBenchmark(localQueryRunner).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new ArrayGreaterThanBenchmark(localQueryRunner).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new ArrayNotEqualBenchmark(localQueryRunner).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new ArrayLessThanOrEqualBenchmark(localQueryRunner).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new ArrayGreaterThanOrEqualBenchmark(localQueryRunner).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class ArrayEqualsBenchmark
    extends AbstractSqlBenchmark {
        public ArrayEqualsBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "array_equals", 5, 50, "SELECT COUNT_IF(ARRAY [orderkey, orderkey + 1, orderkey + 2] = ARRAY[orderkey + 1, orderkey + 2, orderkey + 3]) FROM orders");
        }
    }

    public static class ArrayLessThanBenchmark
    extends AbstractSqlBenchmark {
        public ArrayLessThanBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "array_less_than", 5, 50, "SELECT COUNT_IF(ARRAY [quantity, quantity + 5] < ARRAY[quantity, quantity + 5, quantity + 3]) FROM lineitem");
        }
    }

    public static class ArrayGreaterThanBenchmark
    extends AbstractSqlBenchmark {
        public ArrayGreaterThanBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "array_greater_than", 5, 50, "SELECT COUNT_IF(ARRAY [quantity, quantity + 6] > ARRAY[quantity, quantity + 5, quantity + 3]) FROM lineitem");
        }
    }

    public static class ArrayNotEqualBenchmark
    extends AbstractSqlBenchmark {
        public ArrayNotEqualBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "array_not_equal", 5, 50, "SELECT COUNT_IF(ARRAY [orderkey, orderkey + 1, orderkey + 2] != ARRAY[orderkey + 1, orderkey + 2, orderkey + 3]) FROM orders");
        }
    }

    public static class ArrayLessThanOrEqualBenchmark
    extends AbstractSqlBenchmark {
        public ArrayLessThanOrEqualBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "array_less_than_or_equal", 5, 50, "SELECT COUNT_IF(ARRAY [quantity, quantity + 5, quantity + 2] <= ARRAY[quantity, quantity + 5, quantity + 3]) FROM lineitem");
        }
    }

    public static class ArrayGreaterThanOrEqualBenchmark
    extends AbstractSqlBenchmark {
        public ArrayGreaterThanOrEqualBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "array_greater_than_or_equal", 5, 50, "SELECT COUNT_IF(ARRAY [quantity, quantity + 6] >= ARRAY[quantity, quantity + 5, quantity + 3]) FROM lineitem");
        }
    }
}

