/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;

public final class BenchmarkQueryRunner {
    private BenchmarkQueryRunner() {
    }

    public static LocalQueryRunner createLocalQueryRunnerHashEnabled() {
        return BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)ImmutableMap.of((Object)"optimizer.optimize_hash_generation", (Object)"true"));
    }

    public static LocalQueryRunner createLocalQueryRunner() {
        return BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)ImmutableMap.of());
    }

    public static LocalQueryRunner createLocalQueryRunner(Map<String, String> extraSessionProperties) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
        extraSessionProperties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        Session session = sessionBuilder.build();
        LocalQueryRunner localQueryRunner = LocalQueryRunner.create((Session)session);
        localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return localQueryRunner;
    }
}

