/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.benchmark.AbstractBenchmark;
import io.trino.benchmark.ArrayComparisonBenchmark;
import io.trino.benchmark.BenchmarkResultHook;
import io.trino.benchmark.CountAggregationBenchmark;
import io.trino.benchmark.CountAggregationSqlBenchmark;
import io.trino.benchmark.CountWithFilterSqlBenchmark;
import io.trino.benchmark.DoubleSumAggregationBenchmark;
import io.trino.benchmark.GroupByAggregationSqlBenchmark;
import io.trino.benchmark.GroupBySumWithArithmeticSqlBenchmark;
import io.trino.benchmark.HandTpchQuery1;
import io.trino.benchmark.HandTpchQuery6;
import io.trino.benchmark.HashAggregationBenchmark;
import io.trino.benchmark.HashBuildAndJoinBenchmark;
import io.trino.benchmark.HashBuildBenchmark;
import io.trino.benchmark.HashJoinBenchmark;
import io.trino.benchmark.JsonAvgBenchmarkResultWriter;
import io.trino.benchmark.JsonBenchmarkResultWriter;
import io.trino.benchmark.LongMaxAggregationSqlBenchmark;
import io.trino.benchmark.OdsBenchmarkResultWriter;
import io.trino.benchmark.OrderByBenchmark;
import io.trino.benchmark.PredicateFilterBenchmark;
import io.trino.benchmark.PredicateFilterSqlBenchmark;
import io.trino.benchmark.RawStreamingBenchmark;
import io.trino.benchmark.RawStreamingSqlBenchmark;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.benchmark.SqlApproximateCountDistinctDoubleBenchmark;
import io.trino.benchmark.SqlApproximateCountDistinctLongBenchmark;
import io.trino.benchmark.SqlApproximateCountDistinctVarBinaryBenchmark;
import io.trino.benchmark.SqlApproximatePercentileBenchmark;
import io.trino.benchmark.SqlBetweenBenchmark;
import io.trino.benchmark.SqlDistinctMultipleFields;
import io.trino.benchmark.SqlDistinctSingleField;
import io.trino.benchmark.SqlDoubleSumAggregationBenchmark;
import io.trino.benchmark.SqlHashJoinBenchmark;
import io.trino.benchmark.SqlInBenchmark;
import io.trino.benchmark.SqlJoinWithPredicateBenchmark;
import io.trino.benchmark.SqlLikeBenchmark;
import io.trino.benchmark.SqlRegexpLikeBenchmark;
import io.trino.benchmark.SqlSemiJoinInPredicateBenchmark;
import io.trino.benchmark.SqlTpchQuery1;
import io.trino.benchmark.SqlTpchQuery6;
import io.trino.benchmark.StatisticsBenchmark;
import io.trino.benchmark.Top100Benchmark;
import io.trino.benchmark.Top100SqlBenchmark;
import io.trino.benchmark.VarBinaryMaxAggregationSqlBenchmark;
import io.trino.testing.LocalQueryRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BenchmarkSuite {
    private static final Logger LOGGER = Logger.get(BenchmarkSuite.class);
    private final LocalQueryRunner localQueryRunner;
    private final String outputDirectory;

    public static List<AbstractBenchmark> createBenchmarks(LocalQueryRunner localQueryRunner) {
        Session optimizeHashSession = Session.builder((Session)localQueryRunner.getDefaultSession()).setSystemProperty("optimize_hash_generation", "true").build();
        return ImmutableList.of((Object)new CountAggregationBenchmark(localQueryRunner), (Object)new DoubleSumAggregationBenchmark(localQueryRunner), (Object)new HashAggregationBenchmark(localQueryRunner), (Object)new PredicateFilterBenchmark(localQueryRunner), (Object)new RawStreamingBenchmark(localQueryRunner), (Object)new Top100Benchmark(localQueryRunner), (Object)new OrderByBenchmark(localQueryRunner), (Object)new HashBuildBenchmark(localQueryRunner), (Object)new HashJoinBenchmark(localQueryRunner), (Object)new HashBuildAndJoinBenchmark(localQueryRunner.getDefaultSession(), localQueryRunner), (Object)new HashBuildAndJoinBenchmark(optimizeHashSession, localQueryRunner), (Object)new HandTpchQuery1(localQueryRunner), (Object[])new AbstractBenchmark[]{new HandTpchQuery6(localQueryRunner), new GroupBySumWithArithmeticSqlBenchmark(localQueryRunner), new CountAggregationSqlBenchmark(localQueryRunner), new SqlDoubleSumAggregationBenchmark(localQueryRunner), new CountWithFilterSqlBenchmark(localQueryRunner), new GroupByAggregationSqlBenchmark(localQueryRunner), new PredicateFilterSqlBenchmark(localQueryRunner), new RawStreamingSqlBenchmark(localQueryRunner), new Top100SqlBenchmark(localQueryRunner), new SqlHashJoinBenchmark(localQueryRunner), new SqlJoinWithPredicateBenchmark(localQueryRunner), new LongMaxAggregationSqlBenchmark(localQueryRunner), new VarBinaryMaxAggregationSqlBenchmark(localQueryRunner), new SqlDistinctMultipleFields(localQueryRunner), new SqlDistinctSingleField(localQueryRunner), new SqlTpchQuery1(localQueryRunner), new SqlTpchQuery6(localQueryRunner), new SqlLikeBenchmark(localQueryRunner), new SqlInBenchmark(localQueryRunner), new SqlSemiJoinInPredicateBenchmark(localQueryRunner), new SqlRegexpLikeBenchmark(localQueryRunner), new SqlApproximatePercentileBenchmark(localQueryRunner), new SqlBetweenBenchmark(localQueryRunner), new StatisticsBenchmark.LongVarianceBenchmark(localQueryRunner), new StatisticsBenchmark.LongVariancePopBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleVarianceBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleVariancePopBenchmark(localQueryRunner), new StatisticsBenchmark.LongStdDevBenchmark(localQueryRunner), new StatisticsBenchmark.LongStdDevPopBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleStdDevBenchmark(localQueryRunner), new StatisticsBenchmark.DoubleStdDevPopBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayEqualsBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayLessThanBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayGreaterThanBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayNotEqualBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayLessThanOrEqualBenchmark(localQueryRunner), new ArrayComparisonBenchmark.ArrayGreaterThanOrEqualBenchmark(localQueryRunner), new SqlApproximateCountDistinctLongBenchmark(localQueryRunner), new SqlApproximateCountDistinctDoubleBenchmark(localQueryRunner), new SqlApproximateCountDistinctVarBinaryBenchmark(localQueryRunner)});
    }

    public BenchmarkSuite(LocalQueryRunner localQueryRunner, String outputDirectory) {
        this.localQueryRunner = localQueryRunner;
        this.outputDirectory = Objects.requireNonNull(outputDirectory, "outputDirectory is null");
    }

    private static File createOutputFile(String fileName) throws IOException {
        File outputFile = new File(fileName);
        Files.createParentDirs((File)outputFile);
        return outputFile;
    }

    public void runAllBenchmarks() throws IOException {
        List<AbstractBenchmark> benchmarks = BenchmarkSuite.createBenchmarks(this.localQueryRunner);
        LOGGER.info("=== Pre-running all benchmarks for JVM warmup ===");
        for (AbstractBenchmark benchmark : benchmarks) {
            benchmark.runBenchmark();
        }
        LOGGER.info("=== Actually running benchmarks for metrics ===");
        for (AbstractBenchmark benchmark : benchmarks) {
            try (FileOutputStream jsonOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/json/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));
                 FileOutputStream jsonAvgOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/json-avg/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));
                 FileOutputStream csvOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/csv/%s.csv", this.outputDirectory, benchmark.getBenchmarkName())));
                 FileOutputStream odsOut = new FileOutputStream(BenchmarkSuite.createOutputFile(String.format("%s/ods/%s.json", this.outputDirectory, benchmark.getBenchmarkName())));){
                benchmark.runBenchmark(new ForwardingBenchmarkResultWriter((List<BenchmarkResultHook>)ImmutableList.of((Object)new JsonBenchmarkResultWriter(jsonOut), (Object)new JsonAvgBenchmarkResultWriter(jsonAvgOut), (Object)new SimpleLineBenchmarkResultWriter(csvOut), (Object)new OdsBenchmarkResultWriter("trino.benchmark." + benchmark.getBenchmarkName(), odsOut))));
            }
        }
    }

    private static class ForwardingBenchmarkResultWriter
    implements BenchmarkResultHook {
        private final List<BenchmarkResultHook> benchmarkResultHooks;

        private ForwardingBenchmarkResultWriter(List<BenchmarkResultHook> benchmarkResultHooks) {
            Objects.requireNonNull(benchmarkResultHooks, "benchmarkResultHooks is null");
            this.benchmarkResultHooks = ImmutableList.copyOf(benchmarkResultHooks);
        }

        @Override
        public BenchmarkResultHook addResults(Map<String, Long> results) {
            Objects.requireNonNull(results, "results is null");
            for (BenchmarkResultHook benchmarkResultHook : this.benchmarkResultHooks) {
                benchmarkResultHook.addResults(results);
            }
            return this;
        }

        @Override
        public void finished() {
            for (BenchmarkResultHook benchmarkResultHook : this.benchmarkResultHooks) {
                benchmarkResultHook.finished();
            }
        }
    }
}

