/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.trino.benchmark.AbstractSimpleOperatorBenchmark;
import io.trino.benchmark.BenchmarkAggregationFunction;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.operator.DriverContext;
import io.trino.operator.HashAggregationOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.LocalQueryRunner;
import io.trino.util.DateTimeUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HandTpchQuery1
extends AbstractSimpleOperatorBenchmark {
    private final BenchmarkAggregationFunction longAverage = this.createAggregationFunction("avg", new Type[]{BigintType.BIGINT});
    private final BenchmarkAggregationFunction doubleAverage = this.createAggregationFunction("avg", new Type[]{DoubleType.DOUBLE});
    private final BenchmarkAggregationFunction doubleSum = this.createAggregationFunction("sum", new Type[]{DoubleType.DOUBLE});
    private final BenchmarkAggregationFunction countFunction = this.createAggregationFunction("count", new Type[0]);

    public HandTpchQuery1(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_1", 1, 5);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "returnflag", "linestatus", "quantity", "extendedprice", "discount", "tax", "shipdate");
        TpchQuery1Operator.TpchQuery1OperatorFactory tpchQuery1Operator = new TpchQuery1Operator.TpchQuery1OperatorFactory(1);
        HashAggregationOperator.HashAggregationOperatorFactory aggregationOperator = new HashAggregationOperator.HashAggregationOperatorFactory(2, new PlanNodeId("test"), this.getColumnTypes("lineitem", "returnflag", "linestatus"), Ints.asList((int[])new int[]{0, 1}), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)this.doubleSum.bind((List<Integer>)ImmutableList.of((Object)2)), (Object)this.doubleSum.bind((List<Integer>)ImmutableList.of((Object)3)), (Object)this.doubleSum.bind((List<Integer>)ImmutableList.of((Object)4)), (Object)this.longAverage.bind((List<Integer>)ImmutableList.of((Object)2)), (Object)this.doubleAverage.bind((List<Integer>)ImmutableList.of((Object)5)), (Object)this.doubleAverage.bind((List<Integer>)ImmutableList.of((Object)6)), (Object)this.countFunction.bind((List<Integer>)ImmutableList.of((Object)2))), Optional.empty(), Optional.empty(), 10000, Optional.of(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), new JoinCompiler(this.localQueryRunner.getTypeOperators()), this.localQueryRunner.getTypeOperators(), Optional.empty());
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery1Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery1(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class TpchQuery1Operator
    implements Operator {
        private static final ImmutableList<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
        private final OperatorContext operatorContext;
        private final PageBuilder pageBuilder;
        private boolean finishing;
        private static final int MAX_SHIP_DATE = DateTimeUtils.parseDate((String)"1998-09-02");

        public TpchQuery1Operator(OperatorContext operatorContext) {
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
            this.pageBuilder = new PageBuilder(TYPES);
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public void finish() {
            this.finishing = true;
        }

        public boolean isFinished() {
            return this.finishing && this.pageBuilder.isEmpty();
        }

        public boolean needsInput() {
            return !this.pageBuilder.isFull();
        }

        public void addInput(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Output buffer is full");
            Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finished");
            TpchQuery1Operator.filterAndProjectRowOriented(this.pageBuilder, page.getBlock(0), page.getBlock(1), page.getBlock(2), page.getBlock(3), page.getBlock(4), page.getBlock(5), page.getBlock(6));
        }

        public Page getOutput() {
            if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                return page;
            }
            return null;
        }

        private static void filterAndProjectRowOriented(PageBuilder pageBuilder, Block returnFlagBlock, Block lineStatusBlock, Block quantityBlock, Block extendedPriceBlock, Block discountBlock, Block taxBlock, Block shipDateBlock) {
            int rows = returnFlagBlock.getPositionCount();
            for (int position = 0; position < rows; ++position) {
                int shipDate;
                if (shipDateBlock.isNull(position) || (shipDate = DateType.DATE.getInt(shipDateBlock, position)) > MAX_SHIP_DATE) continue;
                pageBuilder.declarePosition();
                if (returnFlagBlock.isNull(position)) {
                    pageBuilder.getBlockBuilder(0).appendNull();
                } else {
                    VarcharType.VARCHAR.appendTo(returnFlagBlock, position, pageBuilder.getBlockBuilder(0));
                }
                if (lineStatusBlock.isNull(position)) {
                    pageBuilder.getBlockBuilder(1).appendNull();
                } else {
                    VarcharType.VARCHAR.appendTo(lineStatusBlock, position, pageBuilder.getBlockBuilder(1));
                }
                double quantity = DoubleType.DOUBLE.getDouble(quantityBlock, position);
                double extendedPrice = DoubleType.DOUBLE.getDouble(extendedPriceBlock, position);
                double discount = DoubleType.DOUBLE.getDouble(discountBlock, position);
                double tax = DoubleType.DOUBLE.getDouble(taxBlock, position);
                boolean quantityIsNull = quantityBlock.isNull(position);
                boolean extendedPriceIsNull = extendedPriceBlock.isNull(position);
                boolean discountIsNull = discountBlock.isNull(position);
                boolean taxIsNull = taxBlock.isNull(position);
                if (quantityIsNull) {
                    pageBuilder.getBlockBuilder(2).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(2), quantity);
                }
                if (extendedPriceIsNull) {
                    pageBuilder.getBlockBuilder(3).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), extendedPrice);
                }
                if (extendedPriceIsNull || discountIsNull) {
                    pageBuilder.getBlockBuilder(4).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(4), extendedPrice * (1.0 - discount));
                }
                if (extendedPriceIsNull || discountIsNull || taxIsNull) {
                    pageBuilder.getBlockBuilder(5).appendNull();
                } else {
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(5), extendedPrice * (1.0 - discount) * (1.0 + tax));
                }
                if (discountIsNull) {
                    pageBuilder.getBlockBuilder(6).appendNull();
                    continue;
                }
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(6), discount);
            }
        }

        public static class TpchQuery1OperatorFactory
        implements OperatorFactory {
            private final int operatorId;

            public TpchQuery1OperatorFactory(int operatorId) {
                this.operatorId = operatorId;
            }

            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, new PlanNodeId("test"), TpchQuery1Operator.class.getSimpleName());
                return new TpchQuery1Operator(operatorContext);
            }

            public void noMoreOperators() {
            }

            public OperatorFactory duplicate() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

