/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.benchmark.AbstractOperatorBenchmark;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.operator.Driver;
import io.trino.operator.DriverFactory;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.JoinOperatorType;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.TaskContext;
import io.trino.operator.join.HashBuilderOperator;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.PartitionedLookupSourceFactory;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.NullOutputOperator;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public class HashBuildAndJoinBenchmark
extends AbstractOperatorBenchmark {
    private final boolean hashEnabled;
    private final List<Type> ordersTableTypes = this.getColumnTypes("orders", "orderkey", "totalprice");
    private final OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
    private final List<Type> lineItemTableTypes = this.getColumnTypes("lineitem", "orderkey", "quantity");
    private final OperatorFactory lineItemTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "orderkey", "quantity");

    public HashBuildAndJoinBenchmark(Session session, LocalQueryRunner localQueryRunner) {
        super(session, localQueryRunner, "hash_build_and_join_hash_enabled_" + HashBuildAndJoinBenchmark.isHashEnabled(session), 4, 5);
        this.hashEnabled = HashBuildAndJoinBenchmark.isHashEnabled(session);
    }

    private static boolean isHashEnabled(Session session) {
        return SystemSessionProperties.isOptimizeHashGenerationEnabled((Session)session);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        ImmutableList.Builder driversBuilder = ImmutableList.builder();
        driversBuilder.add((Object)this.ordersTableScan);
        Object sourceTypes = this.ordersTableTypes;
        OptionalInt hashChannel = OptionalInt.empty();
        if (this.hashEnabled) {
            driversBuilder.add((Object)this.createHashProjectOperator(1, new PlanNodeId("test"), (List<Type>)sourceTypes));
            sourceTypes = ImmutableList.builder().addAll(sourceTypes).add((Object)BigintType.BIGINT).build();
            hashChannel = OptionalInt.of(sourceTypes.size() - 1);
        }
        TypeOperators typeOperators = new TypeOperators();
        JoinBridgeManager lookupSourceFactoryManager = JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory((List)sourceTypes, (List)ImmutableList.of((Object)0, (Object)1).stream().map(((List)sourceTypes)::get).collect(ImmutableList.toImmutableList()), (List)Ints.asList((int[])new int[]{0}).stream().map(((List)sourceTypes)::get).collect(ImmutableList.toImmutableList()), 1, false, typeOperators));
        HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(2, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)0, (Object)1), Ints.asList((int[])new int[]{0}), hashChannel, Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory(), HashArraySizeSupplier.incrementalLoadFactorHashArraySizeSupplier((Session)this.session));
        driversBuilder.add((Object)hashBuilder);
        DriverFactory hashBuildDriverFactory = new DriverFactory(0, true, false, (List)driversBuilder.build(), OptionalInt.empty());
        ImmutableList.Builder joinDriversBuilder = ImmutableList.builder();
        joinDriversBuilder.add((Object)this.lineItemTableScan);
        sourceTypes = this.lineItemTableTypes;
        hashChannel = OptionalInt.empty();
        if (this.hashEnabled) {
            joinDriversBuilder.add((Object)this.createHashProjectOperator(1, new PlanNodeId("test"), (List<Type>)sourceTypes));
            sourceTypes = ImmutableList.builder().addAll((Iterable)sourceTypes).add((Object)BigintType.BIGINT).build();
            hashChannel = OptionalInt.of(sourceTypes.size() - 1);
        }
        OperatorFactory joinOperator = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)2, (PlanNodeId)new PlanNodeId("test"), (JoinBridgeManager)lookupSourceFactoryManager, (boolean)false, (List)sourceTypes, (List)Ints.asList((int[])new int[]{0}), (OptionalInt)hashChannel, Optional.empty(), (OptionalInt)OptionalInt.empty(), (PartitioningSpillerFactory)PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), (TypeOperators)typeOperators);
        joinDriversBuilder.add((Object)joinOperator);
        joinDriversBuilder.add((Object)new NullOutputOperator.NullOutputOperatorFactory(3, new PlanNodeId("test")));
        DriverFactory joinDriverFactory = new DriverFactory(1, true, true, (List)joinDriversBuilder.build(), OptionalInt.empty());
        Driver hashBuildDriver = hashBuildDriverFactory.createDriver(taskContext.addPipelineContext(0, true, false, false).addDriverContext());
        hashBuildDriverFactory.noMoreDrivers();
        Driver joinDriver = joinDriverFactory.createDriver(taskContext.addPipelineContext(1, true, true, false).addDriverContext());
        joinDriverFactory.noMoreDrivers();
        return ImmutableList.of((Object)hashBuildDriver, (Object)joinDriver);
    }

    public static void main(String[] args) {
        new HashBuildAndJoinBenchmark(TestingSession.testSessionBuilder().build(), BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        new HashBuildAndJoinBenchmark(TestingSession.testSessionBuilder().build(), BenchmarkQueryRunner.createLocalQueryRunnerHashEnabled()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

