/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.benchmark.AbstractOperatorBenchmark;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.execution.executor.timesharing.PrioritizedSplitRunner;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverFactory;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.JoinOperatorType;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.TaskContext;
import io.trino.operator.join.HashBuilderOperator;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.LookupSourceProvider;
import io.trino.operator.join.PartitionedLookupSourceFactory;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.NullOutputOperator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Future;

public class HashJoinBenchmark
extends AbstractOperatorBenchmark {
    private DriverFactory probeDriverFactory;

    public HashJoinBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hash_join", 4, 50);
    }

    @Override
    protected List<Driver> createDrivers(TaskContext taskContext) {
        if (this.probeDriverFactory == null) {
            List<Type> ordersTypes = this.getColumnTypes("orders", "orderkey", "totalprice");
            OperatorFactory ordersTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey", "totalprice");
            TypeOperators typeOperators = new TypeOperators();
            JoinBridgeManager lookupSourceFactoryManager = JoinBridgeManager.lookupAllAtOnce((PartitionedLookupSourceFactory)new PartitionedLookupSourceFactory(ordersTypes, (List)ImmutableList.of((Object)0, (Object)1).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), (List)Ints.asList((int[])new int[]{0}).stream().map(ordersTypes::get).collect(ImmutableList.toImmutableList()), 1, false, typeOperators));
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilder = new HashBuilderOperator.HashBuilderOperatorFactory(1, new PlanNodeId("test"), lookupSourceFactoryManager, (List)ImmutableList.of((Object)0, (Object)1), Ints.asList((int[])new int[]{0}), OptionalInt.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), 1500000, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, SingleStreamSpillerFactory.unsupportedSingleStreamSpillerFactory(), HashArraySizeSupplier.incrementalLoadFactorHashArraySizeSupplier((Session)this.session));
            DriverContext driverContext = taskContext.addPipelineContext(0, false, false, false).addDriverContext();
            DriverFactory buildDriverFactory = new DriverFactory(0, false, false, (List)ImmutableList.of((Object)ordersTableScan, (Object)hashBuilder), OptionalInt.empty());
            List<Type> lineItemTypes = this.getColumnTypes("lineitem", "orderkey", "quantity");
            OperatorFactory lineItemTableScan = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "orderkey", "quantity");
            OperatorFactory joinOperator = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)1, (PlanNodeId)new PlanNodeId("test"), (JoinBridgeManager)lookupSourceFactoryManager, (boolean)false, lineItemTypes, (List)Ints.asList((int[])new int[]{0}), (OptionalInt)OptionalInt.empty(), Optional.empty(), (OptionalInt)OptionalInt.empty(), (PartitioningSpillerFactory)PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), (TypeOperators)typeOperators);
            NullOutputOperator.NullOutputOperatorFactory output = new NullOutputOperator.NullOutputOperatorFactory(2, new PlanNodeId("test"));
            this.probeDriverFactory = new DriverFactory(1, true, true, (List)ImmutableList.of((Object)lineItemTableScan, (Object)joinOperator, (Object)output), OptionalInt.empty());
            Driver driver = buildDriverFactory.createDriver(driverContext);
            ListenableFuture lookupSourceProvider = ((PartitionedLookupSourceFactory)lookupSourceFactoryManager.getJoinBridge()).createLookupSourceProvider();
            while (!lookupSourceProvider.isDone()) {
                driver.processForDuration(PrioritizedSplitRunner.SPLIT_RUN_QUANTA);
            }
            ((LookupSourceProvider)MoreFutures.getFutureValue((Future)lookupSourceProvider)).close();
        }
        DriverContext driverContext = taskContext.addPipelineContext(1, true, true, false).addDriverContext();
        Driver driver = this.probeDriverFactory.createDriver(driverContext);
        return ImmutableList.of((Object)driver);
    }

    public static void main(String[] args) {
        new HashJoinBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

