/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import io.trino.benchmark.AbstractSqlBenchmark;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.JsonAvgBenchmarkResultWriter;
import io.trino.testing.LocalQueryRunner;

public abstract class JsonFunctionsBenchmark {
    public static void main(String ... args) {
        LocalQueryRunner localQueryRunner = BenchmarkQueryRunner.createLocalQueryRunner();
        new JsonExtractBenchmark(localQueryRunner).runBenchmark(new JsonAvgBenchmarkResultWriter(System.out));
        new JsonQueryBenchmark(localQueryRunner).runBenchmark(new JsonAvgBenchmarkResultWriter(System.out));
        new JsonExtractScalarBenchmark(localQueryRunner).runBenchmark(new JsonAvgBenchmarkResultWriter(System.out));
        new JsonValueBenchmark(localQueryRunner).runBenchmark(new JsonAvgBenchmarkResultWriter(System.out));
    }

    public static class JsonExtractBenchmark
    extends AbstractSqlBenchmark {
        public JsonExtractBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "json_extract", 5, 50, "SELECT json_extract(format('{name : %s, random_number : %s}', partkey, random()), '$.name') FROM lineitem");
        }
    }

    public static class JsonQueryBenchmark
    extends AbstractSqlBenchmark {
        public JsonQueryBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "json_query", 5, 50, "SELECT json_query(format('{name : %s, random_number : %s}', partkey, random()), 'strict $.name') FROM lineitem");
        }
    }

    public static class JsonExtractScalarBenchmark
    extends AbstractSqlBenchmark {
        public JsonExtractScalarBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "json_extract_scalar", 5, 50, "SELECT json_extract_scalar(format('{comment : %s, random_number : %s}', comment, random()), '$.comment') FROM lineitem");
        }
    }

    public static class JsonValueBenchmark
    extends AbstractSqlBenchmark {
        public JsonValueBenchmark(LocalQueryRunner localQueryRunner) {
            super(localQueryRunner, "json_value", 5, 50, "SELECT json_value(format('{comment : %s, random_number : %s}', comment, random()), 'strict $.comment') FROM lineitem");
        }
    }
}

