/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import io.trino.benchmark.AbstractSimpleOperatorBenchmark;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.operator.LimitOperator;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OrderByOperator;
import io.trino.operator.PagesIndex;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.LocalQueryRunner;
import java.util.List;
import java.util.Optional;

public class OrderByBenchmark
extends AbstractSimpleOperatorBenchmark {
    private static final int ROWS = 1500000;

    public OrderByBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "in_memory_orderby_1.5M", 5, 10);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        List<Type> tableScanTypes = this.getColumnTypes("orders", "totalprice", "clerk");
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "totalprice", "clerk");
        LimitOperator.LimitOperatorFactory limitOperator = new LimitOperator.LimitOperatorFactory(1, new PlanNodeId("test"), 1500000L);
        OrderByOperator.OrderByOperatorFactory orderByOperator = new OrderByOperator.OrderByOperatorFactory(2, new PlanNodeId("test"), tableScanTypes, (List)ImmutableList.of((Object)1), 1500000, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, Optional.empty(), new OrderingCompiler(this.localQueryRunner.getTypeOperators()));
        return ImmutableList.of((Object)tableScanOperator, (Object)limitOperator, (Object)orderByOperator);
    }

    public static void main(String[] args) {
        new OrderByBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

