/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchmark;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.benchmark.AbstractSimpleOperatorBenchmark;
import io.trino.benchmark.BenchmarkQueryRunner;
import io.trino.benchmark.SimpleLineBenchmarkResultWriter;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.FilterAndProjectOperator;
import io.trino.operator.OperatorFactory;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.testing.LocalQueryRunner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class PredicateFilterBenchmark
extends AbstractSimpleOperatorBenchmark {
    public PredicateFilterBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "predicate_filter", 5, 50);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "totalprice");
        CallExpression filter = Expressions.call((ResolvedFunction)this.localQueryRunner.getMetadata().resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)), (RowExpression[])new RowExpression[]{Expressions.constant((Object)50000.0, (Type)DoubleType.DOUBLE), Expressions.field((int)0, (Type)DoubleType.DOUBLE)});
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(this.localQueryRunner.getFunctionManager(), new PageFunctionCompiler(this.localQueryRunner.getFunctionManager(), 0));
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)DoubleType.DOUBLE)));
        OperatorFactory filterAndProjectOperator = FilterAndProjectOperator.createOperatorFactory((int)1, (PlanNodeId)new PlanNodeId("test"), (Supplier)pageProcessor, (List)ImmutableList.of((Object)DoubleType.DOUBLE), (DataSize)DataSize.ofBytes((long)0L), (int)0);
        return ImmutableList.of((Object)tableScanOperator, (Object)filterAndProjectOperator);
    }

    public static void main(String[] args) {
        new PredicateFilterBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

