/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.bigquery.BigQueryMetadata;
import io.trino.plugin.bigquery.BigQueryMetadataFactory;
import io.trino.plugin.bigquery.BigQueryTransactionHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BigQueryTransactionManager {
    private static final Logger log = Logger.get(BigQueryTransactionManager.class);
    private final ConcurrentMap<ConnectorTransactionHandle, BigQueryMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, BigQueryMetadata>();
    private final BigQueryMetadataFactory metadataFactory;

    @Inject
    public BigQueryTransactionManager(BigQueryMetadataFactory metadataFactory) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        log.debug("beginTransaction(isolationLevel=%s, readOnly=%s)", new Object[]{isolationLevel, readOnly});
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        BigQueryTransactionHandle transaction = new BigQueryTransactionHandle();
        this.transactions.put(transaction, this.metadataFactory.create(transaction));
        return transaction;
    }

    public BigQueryMetadata getMetadata(ConnectorTransactionHandle transaction) {
        BigQueryMetadata metadata = (BigQueryMetadata)this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        Preconditions.checkArgument((this.transactions.remove(transaction) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        BigQueryMetadata metadata = (BigQueryMetadata)this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        metadata.rollback();
    }
}

