/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.bigquery.BigQueryType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class BigQueryTypeUtils {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSSSSS");

    private BigQueryTypeUtils() {
    }

    @Nullable
    public static Object readNativeValue(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return BooleanType.BOOLEAN.getBoolean(block, position);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return TinyintType.TINYINT.getByte(block, position);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return SmallintType.SMALLINT.getShort(block, position);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return IntegerType.INTEGER.getInt(block, position);
        }
        if (type.equals(BigintType.BIGINT)) {
            return BigintType.BIGINT.getLong(block, position);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return DoubleType.DOUBLE.getDouble(block, position);
        }
        if (type instanceof DecimalType) {
            return Decimals.readBigDecimal((DecimalType)((DecimalType)type), (Block)block, (int)position).toString();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return varcharType.getSlice(block, position).toStringUtf8();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return Base64.getEncoder().encodeToString(VarbinaryType.VARBINARY.getSlice(block, position).getBytes());
        }
        if (type.equals(DateType.DATE)) {
            int days = DateType.DATE.getInt(block, position);
            return DATE_FORMATTER.format(LocalDate.ofEpochDay(days));
        }
        if (type.equals(TimestampType.TIMESTAMP_MICROS)) {
            long epochMicros = TimestampType.TIMESTAMP_MICROS.getLong(block, position);
            long epochSeconds = Math.floorDiv(epochMicros, 1000000);
            int nanoAdjustment = Math.floorMod(epochMicros, 1000000) * 1000;
            return DATETIME_FORMATTER.format(BigQueryType.toZonedDateTime(epochSeconds, nanoAdjustment, ZoneOffset.UTC));
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS)) {
            LongTimestampWithTimeZone timestamp = (LongTimestampWithTimeZone)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.getObject(block, position);
            return BigQueryType.timestampToStringConverter(timestamp);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Block arrayBlock = (Block)block.getObject(position, Block.class);
            ImmutableList.Builder list = ImmutableList.builderWithExpectedSize((int)arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = BigQueryTypeUtils.readNativeValue(arrayType.getElementType(), arrayBlock, i);
                if (element == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "BigQuery does not support null elements in arrays");
                }
                list.add(element);
            }
            return list.build();
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            Block rowBlock = (Block)block.getObject(position, Block.class);
            List fieldTypes = rowType.getTypeParameters();
            if (fieldTypes.size() != rowBlock.getPositionCount()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected row value field count does not match type field count");
            }
            HashMap<String, Object> rowValue = new HashMap<String, Object>();
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                String fieldName = (String)((RowType.Field)rowType.getFields().get(i)).getName().orElseThrow(() -> new IllegalArgumentException("Field name must exist in BigQuery"));
                Object fieldValue = BigQueryTypeUtils.readNativeValue((Type)fieldTypes.get(i), rowBlock, i);
                rowValue.put(fieldName, fieldValue);
            }
            return Collections.unmodifiableMap(rowValue);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + type);
    }
}

