/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.plugin.base.TemporaryTables;
import io.trino.plugin.bigquery.BigQueryClient;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.plugin.bigquery.BigQueryErrorCode;
import io.trino.plugin.bigquery.BigQueryFilterQueryBuilder;
import io.trino.plugin.bigquery.BigQueryInsertTableHandle;
import io.trino.plugin.bigquery.BigQueryNamedRelationHandle;
import io.trino.plugin.bigquery.BigQueryOutputTableHandle;
import io.trino.plugin.bigquery.BigQueryPseudoColumn;
import io.trino.plugin.bigquery.BigQueryTableHandle;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.plugin.bigquery.BigQueryUtil;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.plugin.bigquery.ptf.Query;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BigQueryMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(BigQueryMetadata.class);
    private static final Type TRINO_PAGE_SINK_ID_COLUMN_TYPE = BigintType.BIGINT;
    static final int DEFAULT_NUMERIC_TYPE_PRECISION = 38;
    static final int DEFAULT_NUMERIC_TYPE_SCALE = 9;
    private static final String VIEW_DEFINITION_SYSTEM_TABLE_SUFFIX = "$view_definition";
    private final BigQueryClientFactory bigQueryClientFactory;
    private final BigQueryTypeManager typeManager;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();
    private final ListeningExecutorService executorService;

    public BigQueryMetadata(BigQueryClientFactory bigQueryClientFactory, BigQueryTypeManager typeManager, ListeningExecutorService executorService) {
        this.bigQueryClientFactory = Objects.requireNonNull(bigQueryClientFactory, "bigQueryClientFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        log.debug("listSchemaNames(session=%s)", new Object[]{session});
        return (List)this.listRemoteSchemaNames(session).stream().map(schema -> schema.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
    }

    private List<String> listRemoteSchemaNames(ConnectorSession session) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        String projectId = client.getProjectId();
        Stream<String> remoteSchemaNames = Streams.stream(client.listDatasetIds(projectId)).map(DatasetId::getDataset).distinct();
        return (List)remoteSchemaNames.map(remoteSchema -> client.toRemoteDataset(projectId, remoteSchema.toLowerCase(Locale.ENGLISH))).filter(Optional::isPresent).map(Optional::get).filter(dataset -> !dataset.isAmbiguous()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).collect(ImmutableList.toImmutableList());
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        DatasetId localDatasetId = client.toDatasetId(schemaName);
        log.debug("schemaExists(session=%s)", new Object[]{session});
        return client.toRemoteDataset(localDatasetId).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).filter(remoteSchema -> client.getDataset(DatasetId.of((String)localDatasetId.getProject(), (String)remoteSchema)) != null).isPresent();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        Object remoteSchemaNames;
        String projectId;
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("listTables(session=%s, schemaName=%s)", new Object[]{session, schemaName});
        if (schemaName.isPresent()) {
            DatasetId localDatasetId = client.toDatasetId(schemaName.get());
            projectId = localDatasetId.getProject();
            Optional<String> remoteSchema = client.toRemoteDataset(localDatasetId).filter(dataset -> !dataset.isAmbiguous()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName);
            remoteSchemaNames = (Set)remoteSchema.map(ImmutableSet::of).orElse(ImmutableSet.of());
        } else {
            projectId = client.getProjectId();
            remoteSchemaNames = ImmutableSet.copyOf(this.listRemoteSchemaNames(session));
        }
        return (List)this.processInParallel(remoteSchemaNames.stream().toList(), remoteSchemaName -> this.listTablesInRemoteSchema(client, projectId, (String)remoteSchemaName)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private List<SchemaTableName> listTablesInRemoteSchema(BigQueryClient client, String projectId, String remoteSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        try {
            Iterable<TableId> tableIds = client.listTableIds(DatasetId.of((String)projectId, (String)remoteSchemaName));
            for (TableId tableId : tableIds) {
                client.toRemoteTable(projectId, remoteSchemaName, tableId.getTable().toLowerCase(Locale.ENGLISH), tableIds).filter(BigQueryClient.RemoteDatabaseObject::isAmbiguous).ifPresentOrElse(remoteTable -> log.debug("Filtered out [%s.%s] from list of tables due to ambiguous name", new Object[]{remoteSchemaName, tableId.getTable()}), () -> tableNames.add((Object)new SchemaTableName(client.toSchemaName(DatasetId.of((String)projectId, (String)tableId.getDataset())), tableId.getTable())));
            }
        }
        catch (TrinoException e) {
            BigQueryException bigQueryException;
            Throwable throwable;
            if (e.getErrorCode() == BigQueryErrorCode.BIGQUERY_LISTING_TABLE_ERROR.toErrorCode() && (throwable = e.getCause()) instanceof BigQueryException && (bigQueryException = (BigQueryException)throwable).getCode() == 404 && bigQueryException.getMessage().contains("Not found: Dataset")) {
                log.debug("Dataset disappeared during listing operation: %s", new Object[]{remoteSchemaName});
            }
            throw e;
        }
        return tableNames.build();
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("getTableHandle(session=%s, schemaTableName=%s)", new Object[]{session, schemaTableName});
        DatasetId localDatasetId = client.toDatasetId(schemaTableName.getSchemaName());
        String remoteSchemaName = client.toRemoteDataset(localDatasetId).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElse(localDatasetId.getDataset());
        String remoteTableName = client.toRemoteTable(localDatasetId.getProject(), remoteSchemaName, schemaTableName.getTableName()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElse(schemaTableName.getTableName());
        Optional<TableInfo> tableInfo = client.getTable(TableId.of((String)localDatasetId.getProject(), (String)remoteSchemaName, (String)remoteTableName));
        if (tableInfo.isEmpty()) {
            log.debug("Table [%s.%s] was not found", new Object[]{schemaTableName.getSchemaName(), schemaTableName.getTableName()});
            return null;
        }
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll(client.buildColumnHandles(tableInfo.get()));
        Optional<BigQueryTableHandle.BigQueryPartitionType> partitionType = BigQueryTableHandle.getPartitionType(tableInfo.get().getDefinition());
        if (partitionType.isPresent() && partitionType.get() == BigQueryTableHandle.BigQueryPartitionType.INGESTION) {
            columns.add((Object)BigQueryPseudoColumn.PARTITION_DATE.getColumnHandle());
            columns.add((Object)BigQueryPseudoColumn.PARTITION_TIME.getColumnHandle());
        }
        return new BigQueryTableHandle(new BigQueryNamedRelationHandle(schemaTableName, new RemoteTableName(tableInfo.get().getTableId()), tableInfo.get().getDefinition().getType().toString(), partitionType, Optional.ofNullable(tableInfo.get().getDescription()))).withProjectedColumns((List<BigQueryColumnHandle>)columns.build());
    }

    private Optional<TableInfo> getTableInfoIgnoringConflicts(ConnectorSession session, SchemaTableName schemaTableName) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        DatasetId localDatasetId = client.toDatasetId(schemaTableName.getSchemaName());
        String remoteSchemaName = client.toRemoteDataset(localDatasetId).map(BigQueryClient.RemoteDatabaseObject::getAnyRemoteName).orElse(localDatasetId.getDataset());
        String remoteTableName = client.toRemoteTable(localDatasetId.getProject(), remoteSchemaName, schemaTableName.getTableName()).map(BigQueryClient.RemoteDatabaseObject::getAnyRemoteName).orElse(schemaTableName.getTableName());
        return client.getTable(TableId.of((String)localDatasetId.getProject(), (String)remoteSchemaName, (String)remoteTableName));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("getTableMetadata(session=%s, tableHandle=%s)", new Object[]{session, tableHandle});
        BigQueryTableHandle handle = (BigQueryTableHandle)tableHandle;
        List columns = (List)client.getColumns(handle).stream().map(BigQueryColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(BigQueryMetadata.getSchemaTableName(handle), columns, (Map)ImmutableMap.of(), BigQueryMetadata.getTableComment(handle));
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        if (BigQueryMetadata.isViewDefinitionSystemTable(tableName)) {
            return this.getViewDefinitionSystemTable(session, tableName, BigQueryMetadata.getViewDefinitionSourceTableName(tableName));
        }
        return Optional.empty();
    }

    private Optional<SystemTable> getViewDefinitionSystemTable(ConnectorSession session, SchemaTableName viewDefinitionTableName, SchemaTableName sourceTableName) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        DatasetId localDatasetId = client.toDatasetId(sourceTableName.getSchemaName());
        String remoteSchemaName = client.toRemoteDataset(localDatasetId).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElseThrow(() -> new TableNotFoundException(viewDefinitionTableName));
        String remoteTableName = client.toRemoteTable(localDatasetId.getProject(), remoteSchemaName, sourceTableName.getTableName()).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElseThrow(() -> new TableNotFoundException(viewDefinitionTableName));
        TableInfo tableInfo = client.getTable(TableId.of((String)localDatasetId.getProject(), (String)remoteSchemaName, (String)remoteTableName)).orElseThrow(() -> new TableNotFoundException(viewDefinitionTableName));
        if (!(tableInfo.getDefinition() instanceof ViewDefinition)) {
            throw new TableNotFoundException(viewDefinitionTableName);
        }
        ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("query", (Type)VarcharType.VARCHAR));
        List types = (List)columns.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        Optional<String> query = Optional.ofNullable(((ViewDefinition)tableInfo.getDefinition()).getQuery());
        ImmutableList propertyValues = ImmutableList.of((Object)ImmutableList.of((Object)query.orElse("NULL")));
        return Optional.of(BigQueryMetadata.createSystemTable(new ConnectorTableMetadata(sourceTableName, (List)columns), arg_0 -> BigQueryMetadata.lambda$getViewDefinitionSystemTable$11(types, (Iterable)propertyValues, arg_0)));
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("getColumnHandles(session=%s, tableHandle=%s)", new Object[]{session, tableHandle});
        BigQueryTableHandle table = (BigQueryTableHandle)tableHandle;
        if (table.getProjectedColumns().isPresent()) {
            return (Map)table.getProjectedColumns().get().stream().collect(ImmutableMap.toImmutableMap(columnHandle -> columnHandle.getColumnMetadata().getName(), Function.identity()));
        }
        Preconditions.checkArgument((boolean)table.isNamedRelation(), (String)"Cannot get columns for %s", (Object)tableHandle);
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll(client.getColumns(table));
        if (table.asPlainTable().getPartitionType().isPresent() && table.asPlainTable().getPartitionType().get() == BigQueryTableHandle.BigQueryPartitionType.INGESTION) {
            columns.add((Object)BigQueryPseudoColumn.PARTITION_DATE.getColumnHandle());
            columns.add((Object)BigQueryPseudoColumn.PARTITION_TIME.getColumnHandle());
        }
        return (Map)columns.build().stream().collect(ImmutableMap.toImmutableMap(columnHandle -> columnHandle.getColumnMetadata().getName(), Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        log.debug("getColumnMetadata(session=%s, tableHandle=%s, columnHandle=%s)", new Object[]{session, columnHandle, columnHandle});
        return ((BigQueryColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        log.debug("listTableColumns(session=%s, prefix=%s)", new Object[]{session, prefix});
        List tables = prefix.toOptionalSchemaTableName().map(ImmutableList::of).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        List tableInfos = (List)this.processInParallel(tables, table -> this.getTableInfoIgnoringConflicts(session, (SchemaTableName)table)).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
        return (Map)tableInfos.stream().collect(ImmutableMap.toImmutableMap(table -> new SchemaTableName(table.getTableId().getDataset(), table.getTableId().getTable()), table -> (List)client.buildColumnHandles((TableInfo)table).stream().map(BigQueryColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList())));
    }

    protected <T, R> Stream<R> processInParallel(List<T> list, Function<T, R> function) {
        if (list.size() == 1) {
            return Stream.of(function.apply(list.get(0)));
        }
        List futures = (List)list.stream().map(element -> this.executorService.submit(() -> function.apply(element))).collect(ImmutableList.toImmutableList());
        try {
            return ((List)Futures.allAsList((Iterable)futures).get()).stream();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        Preconditions.checkArgument((boolean)properties.isEmpty(), (Object)"Can't have properties for schema creation");
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((DatasetId)client.toDatasetId(schemaName)).build();
        client.createSchema(datasetInfo);
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        DatasetId localDatasetId = client.toDatasetId(schemaName);
        String remoteSchemaName = this.getRemoteSchemaName(client, localDatasetId.getProject(), localDatasetId.getDataset());
        client.dropSchema(DatasetId.of((String)localDatasetId.getProject(), (String)remoteSchemaName), cascade);
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        try {
            this.createTable(session, tableMetadata, Optional.empty());
        }
        catch (BigQueryException e) {
            if (ignoreExisting && e.getCode() == 409) {
                return;
            }
            throw e;
        }
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        ColumnMetadata pageSinkIdColumn = BigQueryMetadata.buildPageSinkIdColumn((List)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList()));
        return this.createTable(session, tableMetadata, Optional.of(pageSinkIdColumn));
    }

    private BigQueryOutputTableHandle createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ColumnMetadata> pageSinkIdColumn) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        if (!this.schemaExists(session, schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
        int columnSize = tableMetadata.getColumns().size();
        ImmutableList.Builder fields = ImmutableList.builderWithExpectedSize((int)columnSize);
        ImmutableList.Builder tempFields = ImmutableList.builderWithExpectedSize((int)(columnSize + 1));
        ImmutableList.Builder columnsNames = ImmutableList.builderWithExpectedSize((int)columnSize);
        ImmutableList.Builder columnsTypes = ImmutableList.builderWithExpectedSize((int)columnSize);
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            fields.add((Object)this.typeManager.toField(column2.getName(), column2.getType(), column2.getComment()));
            tempFields.add((Object)this.typeManager.toField(column2.getName(), column2.getType(), column2.getComment()));
            columnsNames.add((Object)column2.getName());
            columnsTypes.add((Object)column2.getType());
        }
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        DatasetId localDatasetId = client.toDatasetId(schemaName);
        String remoteSchemaName = this.getRemoteSchemaName(client, localDatasetId.getProject(), localDatasetId.getDataset());
        Closer closer = Closer.create();
        this.setRollback(() -> {
            try {
                closer.close();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
            }
        });
        TableId tableId = this.createTable(client, localDatasetId.getProject(), remoteSchemaName, tableName, (List<Field>)fields.build(), tableMetadata.getComment());
        closer.register(() -> this.bigQueryClientFactory.create(session).dropTable(tableId));
        Optional<String> temporaryTableName = pageSinkIdColumn.map(column -> {
            tempFields.add((Object)this.typeManager.toField(column.getName(), column.getType(), column.getComment()));
            String tempTableName = TemporaryTables.generateTemporaryTableName((ConnectorSession)session);
            TableId tempTableId = this.createTable(client, localDatasetId.getProject(), remoteSchemaName, tempTableName, (List<Field>)tempFields.build(), tableMetadata.getComment());
            closer.register(() -> this.bigQueryClientFactory.create(session).dropTable(tempTableId));
            return tempTableName;
        });
        return new BigQueryOutputTableHandle(new RemoteTableName(tableId), (List<String>)columnsNames.build(), (List<Type>)columnsTypes.build(), temporaryTableName, pageSinkIdColumn.map(ColumnMetadata::getName));
    }

    private TableId createTable(BigQueryClient client, String projectId, String datasetName, String tableName, List<Field> fields, Optional<String> tableComment) {
        TableId tableId = TableId.of((String)projectId, (String)datasetName, (String)tableName);
        StandardTableDefinition tableDefinition = StandardTableDefinition.of((Schema)Schema.of(fields));
        TableInfo.Builder tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition);
        tableComment.ifPresent(arg_0 -> ((TableInfo.Builder)tableInfo).setDescription(arg_0));
        client.createTable(tableInfo.build());
        return tableId;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        BigQueryOutputTableHandle handle = (BigQueryOutputTableHandle)tableHandle;
        Preconditions.checkState((boolean)handle.getTemporaryTableName().isPresent(), (Object)"Unexpected use of finishCreateTable without a temporaryTableName present");
        return this.finishInsert(session, handle.getRemoteTableName(), handle.getTemporaryRemoteTableName().orElseThrow(), handle.getPageSinkIdColumnName().orElseThrow(), handle.getColumnNames(), fragments);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        BigQueryTableHandle bigQueryTable = (BigQueryTableHandle)tableHandle;
        if (BigQueryUtil.isWildcardTable(TableDefinition.Type.valueOf((String)bigQueryTable.asPlainTable().getType()), bigQueryTable.asPlainTable().getRemoteTableName().getTableName())) {
            throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_UNSUPPORTED_OPERATION, "This connector does not support dropping wildcard tables");
        }
        TableId tableId = bigQueryTable.asPlainTable().getRemoteTableName().toTableId();
        client.dropTable(tableId);
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BigQueryTableHandle table = (BigQueryTableHandle)tableHandle;
        BigQueryClient client = this.bigQueryClientFactory.createBigQueryClient(session);
        RemoteTableName remoteTableName = table.asPlainTable().getRemoteTableName();
        String sql = String.format("TRUNCATE TABLE %s.%s.%s", BigQueryUtil.quote(remoteTableName.getProjectId()), BigQueryUtil.quote(remoteTableName.getDatasetName()), BigQueryUtil.quote(remoteTableName.getTableName()));
        client.executeUpdate(session, QueryJobConfiguration.of((String)sql));
    }

    public boolean supportsMissingColumnsOnInsert() {
        return true;
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        BigQueryTableHandle table = (BigQueryTableHandle)tableHandle;
        if (BigQueryUtil.isWildcardTable(TableDefinition.Type.valueOf((String)table.asPlainTable().getType()), table.asPlainTable().getRemoteTableName().getTableName())) {
            throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_UNSUPPORTED_OPERATION, "This connector does not support inserting into wildcard tables");
        }
        ImmutableList.Builder columnNames = ImmutableList.builderWithExpectedSize((int)columns.size());
        ImmutableList.Builder columnTypes = ImmutableList.builderWithExpectedSize((int)columns.size());
        ImmutableList.Builder tempFields = ImmutableList.builderWithExpectedSize((int)(columns.size() + 1));
        for (ColumnHandle columnHandle : columns) {
            BigQueryColumnHandle column = (BigQueryColumnHandle)columnHandle;
            tempFields.add((Object)this.typeManager.toField(column.getName(), column.getTrinoType(), column.getColumnMetadata().getComment()));
            columnNames.add((Object)column.getName());
            columnTypes.add((Object)column.getTrinoType());
        }
        ColumnMetadata pageSinkIdColumn = BigQueryMetadata.buildPageSinkIdColumn((List<String>)columnNames.build());
        tempFields.add((Object)this.typeManager.toField(pageSinkIdColumn.getName(), pageSinkIdColumn.getType(), pageSinkIdColumn.getComment()));
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        String projectId = table.asPlainTable().getRemoteTableName().getProjectId();
        String schemaName = table.asPlainTable().getRemoteTableName().getDatasetName();
        String temporaryTableName = TemporaryTables.generateTemporaryTableName((ConnectorSession)session);
        TableId temporaryTableId = this.createTable(client, projectId, schemaName, temporaryTableName, (List<Field>)tempFields.build(), Optional.empty());
        this.setRollback(() -> this.bigQueryClientFactory.create(session).dropTable(temporaryTableId));
        return new BigQueryInsertTableHandle(table.asPlainTable().getRemoteTableName(), (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), temporaryTableName, pageSinkIdColumn.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, RemoteTableName targetTable, RemoteTableName tempTable, String pageSinkIdColumnName, List<String> columnNames, Collection<Slice> fragments) {
        Closer closer = Closer.create();
        closer.register(() -> this.bigQueryClientFactory.create(session).dropTable(tempTable.toTableId()));
        try {
            BigQueryClient client = this.bigQueryClientFactory.create(session);
            RemoteTableName pageSinkTable = new RemoteTableName(targetTable.getProjectId(), targetTable.getDatasetName(), TemporaryTables.generateTemporaryTableName((ConnectorSession)session));
            this.createTable(client, pageSinkTable.getProjectId(), pageSinkTable.getDatasetName(), pageSinkTable.getTableName(), (List<Field>)ImmutableList.of((Object)this.typeManager.toField(pageSinkIdColumnName, TRINO_PAGE_SINK_ID_COLUMN_TYPE, null)), Optional.empty());
            closer.register(() -> this.bigQueryClientFactory.create(session).dropTable(pageSinkTable.toTableId()));
            InsertAllRequest.Builder batch = InsertAllRequest.newBuilder((TableId)pageSinkTable.toTableId());
            fragments.forEach(slice -> batch.addRow((Map)ImmutableMap.of((Object)pageSinkIdColumnName, (Object)slice.getLong(0))));
            client.insert(batch.build());
            String columns = columnNames.stream().map(BigQueryUtil::quote).collect(Collectors.joining(", "));
            String insertSql = String.format("INSERT INTO %s (%s) SELECT %s FROM %s temp_table WHERE EXISTS (SELECT 1 FROM %s page_sink_table WHERE page_sink_table.%s = temp_table.%s)", BigQueryUtil.quoted(targetTable), columns, columns, BigQueryUtil.quoted(tempTable), BigQueryUtil.quoted(pageSinkTable), BigQueryUtil.quote(pageSinkIdColumnName), BigQueryUtil.quote(pageSinkIdColumnName));
            client.executeUpdate(session, QueryJobConfiguration.of((String)insertSql));
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_FAILED_TO_EXECUTE_QUERY, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        BigQueryInsertTableHandle handle = (BigQueryInsertTableHandle)insertHandle;
        return this.finishInsert(session, handle.getRemoteTableName(), handle.getTemporaryRemoteTableName(), handle.getPageSinkIdColumnName(), handle.getColumnNames(), fragments);
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new BigQueryColumnHandle("$merge_row_id", (Type)BigintType.BIGINT, StandardSQLTypeName.INT64, true, Field.Mode.REQUIRED, (List<BigQueryColumnHandle>)ImmutableList.of(), null, true);
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle) {
        BigQueryTableHandle tableHandle = (BigQueryTableHandle)handle;
        Preconditions.checkArgument((boolean)tableHandle.isNamedRelation(), (String)"Unable to delete from synthetic table: %s", (Object)tableHandle);
        TupleDomain<ColumnHandle> tableConstraint = tableHandle.getConstraint();
        Optional<String> filter = BigQueryFilterQueryBuilder.buildFilter(tableConstraint);
        RemoteTableName remoteTableName = tableHandle.asPlainTable().getRemoteTableName();
        String sql = String.format("DELETE FROM %s.%s.%s WHERE %s", BigQueryUtil.quote(remoteTableName.getProjectId()), BigQueryUtil.quote(remoteTableName.getDatasetName()), BigQueryUtil.quote(remoteTableName.getTableName()), filter.orElse("true"));
        BigQueryClient client = this.bigQueryClientFactory.create(session);
        long rows = client.executeUpdate(session, QueryJobConfiguration.newBuilder((String)sql).setQuery(sql).build());
        return OptionalLong.of(rows);
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        return super.beginMerge(session, tableHandle, retryMode);
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
        super.createMaterializedView(session, viewName, definition, properties, replace, ignoreExisting);
    }

    public ConnectorAnalyzeMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> analyzeProperties) {
        return super.getStatisticsCollectionMetadata(session, tableHandle, analyzeProperties);
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> newComment) {
        BigQueryTableHandle table = (BigQueryTableHandle)tableHandle;
        BigQueryClient client = this.bigQueryClientFactory.createBigQueryClient(session);
        RemoteTableName remoteTableName = table.asPlainTable().getRemoteTableName();
        String sql = String.format("ALTER TABLE %s.%s.%s SET OPTIONS (description = ?)", BigQueryUtil.quote(remoteTableName.getProjectId()), BigQueryUtil.quote(remoteTableName.getDatasetName()), BigQueryUtil.quote(remoteTableName.getTableName()));
        client.executeUpdate(session, QueryJobConfiguration.newBuilder((String)sql).addPositionalParameter(QueryParameterValue.string((String)newComment.orElse(null))).build());
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, Optional<String> newComment) {
        BigQueryTableHandle table = (BigQueryTableHandle)tableHandle;
        BigQueryColumnHandle column = (BigQueryColumnHandle)columnHandle;
        BigQueryClient client = this.bigQueryClientFactory.createBigQueryClient(session);
        RemoteTableName remoteTableName = table.asPlainTable().getRemoteTableName();
        String sql = String.format("ALTER TABLE %s.%s.%s ALTER COLUMN %s SET OPTIONS (description = ?)", BigQueryUtil.quote(remoteTableName.getProjectId()), BigQueryUtil.quote(remoteTableName.getDatasetName()), BigQueryUtil.quote(remoteTableName.getTableName()), BigQueryUtil.quote(column.getName()));
        client.executeUpdate(session, QueryJobConfiguration.newBuilder((String)sql).addPositionalParameter(QueryParameterValue.string((String)newComment.orElse(null))).build());
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        log.debug("applyProjection(session=%s, handle=%s, projections=%s, assignments=%s)", new Object[]{session, handle, projections, assignments});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)handle;
        ImmutableList newColumns = ImmutableList.copyOf(assignments.values());
        if (bigQueryTableHandle.getProjectedColumns().isPresent() && BigQueryMetadata.containSameElements((Iterable<? extends ColumnHandle>)newColumns, (Iterable<? extends ColumnHandle>)bigQueryTableHandle.getProjectedColumns().get())) {
            return Optional.empty();
        }
        ImmutableList.Builder projectedColumns = ImmutableList.builder();
        ImmutableList.Builder assignmentList = ImmutableList.builder();
        assignments.forEach((name, column) -> {
            BigQueryColumnHandle columnHandle = (BigQueryColumnHandle)column;
            projectedColumns.add((Object)columnHandle);
            assignmentList.add((Object)new Assignment(name, column, columnHandle.getTrinoType()));
        });
        bigQueryTableHandle = bigQueryTableHandle.withProjectedColumns((List<BigQueryColumnHandle>)projectedColumns.build());
        return Optional.of(new ProjectionApplicationResult((Object)bigQueryTableHandle, projections, (List)assignmentList.build(), false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        TupleDomain remainingFilter;
        log.debug("applyFilter(session=%s, handle=%s, summary=%s, predicate=%s, columns=%s)", new Object[]{session, handle, constraint.getSummary(), constraint.predicate(), constraint.getPredicateColumns()});
        BigQueryTableHandle bigQueryTableHandle = (BigQueryTableHandle)handle;
        TupleDomain<ColumnHandle> oldDomain = bigQueryTableHandle.getConstraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (newDomain.isNone()) {
            remainingFilter = TupleDomain.all();
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            HashMap<ColumnHandle, Domain> supported = new HashMap<ColumnHandle, Domain>();
            HashMap<BigQueryColumnHandle, Domain> unsupported = new HashMap<BigQueryColumnHandle, Domain>();
            for (Map.Entry entry : domains.entrySet()) {
                BigQueryColumnHandle columnHandle = (BigQueryColumnHandle)entry.getKey();
                Domain domain = (Domain)entry.getValue();
                if (columnHandle.isPushdownSupported()) {
                    supported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
                    continue;
                }
                unsupported.put(columnHandle, domain);
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        BigQueryTableHandle updatedHandle = bigQueryTableHandle.withConstraint((TupleDomain<ColumnHandle>)newDomain);
        return Optional.of(new ConstraintApplicationResult((Object)updatedHandle, remainingFilter, constraint.getExpression(), false));
    }

    public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        if (!(handle instanceof Query.QueryHandle)) {
            return Optional.empty();
        }
        ConnectorTableHandle tableHandle = ((Query.QueryHandle)handle).getTableHandle();
        ImmutableList columnHandles = ImmutableList.copyOf(this.getColumnHandles(session, tableHandle).values());
        return Optional.of(new TableFunctionApplicationResult((Object)tableHandle, (List)columnHandles));
    }

    private String getRemoteSchemaName(BigQueryClient client, String projectId, String datasetName) {
        return client.toRemoteDataset(projectId, datasetName).map(BigQueryClient.RemoteDatabaseObject::getOnlyRemoteName).orElseThrow(() -> new SchemaNotFoundException(datasetName));
    }

    private static boolean containSameElements(Iterable<? extends ColumnHandle> first, Iterable<? extends ColumnHandle> second) {
        return ImmutableSet.copyOf(first).equals((Object)ImmutableSet.copyOf(second));
    }

    private static boolean isViewDefinitionSystemTable(SchemaTableName table) {
        return table.getTableName().endsWith(VIEW_DEFINITION_SYSTEM_TABLE_SUFFIX) && table.getTableName().length() > VIEW_DEFINITION_SYSTEM_TABLE_SUFFIX.length();
    }

    private static SchemaTableName getViewDefinitionSourceTableName(SchemaTableName table) {
        return new SchemaTableName(table.getSchemaName(), table.getTableName().substring(0, table.getTableName().length() - VIEW_DEFINITION_SYSTEM_TABLE_SUFFIX.length()));
    }

    private static SchemaTableName getSchemaTableName(BigQueryTableHandle handle) {
        return handle.isNamedRelation() ? handle.getRequiredNamedRelation().getSchemaTableName() : new SchemaTableName("_generated", "_generated_query");
    }

    private static Optional<String> getTableComment(BigQueryTableHandle handle) {
        return handle.isNamedRelation() ? handle.getRequiredNamedRelation().getComment() : Optional.empty();
    }

    private static SystemTable createSystemTable(final ConnectorTableMetadata metadata, final Function<TupleDomain<Integer>, RecordCursor> cursor) {
        return new SystemTable(){

            public SystemTable.Distribution getDistribution() {
                return SystemTable.Distribution.SINGLE_COORDINATOR;
            }

            public ConnectorTableMetadata getTableMetadata() {
                return metadata;
            }

            public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
                return (RecordCursor)cursor.apply(constraint);
            }
        };
    }

    private static ColumnMetadata buildPageSinkIdColumn(List<String> otherColumnNames) {
        String baseColumnName = "trino_page_sink_id";
        Object columnName = baseColumnName;
        int suffix = 1;
        while (otherColumnNames.contains(columnName)) {
            columnName = baseColumnName + "_" + suffix;
            ++suffix;
        }
        return new ColumnMetadata((String)columnName, TRINO_PAGE_SINK_ID_COLUMN_TYPE);
    }

    private static /* synthetic */ RecordCursor lambda$getViewDefinitionSystemTable$11(List types, Iterable propertyValues, TupleDomain constraint) {
        return new InMemoryRecordSet((Collection)types, propertyValues).cursor();
    }
}

