/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.core.ApiFuture;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.bigquery.BigQueryErrorCode;
import io.trino.plugin.bigquery.BigQueryTypeUtils;
import io.trino.plugin.bigquery.RemoteTableName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;

public class BigQueryPageSink
implements ConnectorPageSink {
    private final BigQueryWriteClient client;
    private final CreateWriteStreamRequest createWriteStreamRequest;
    private final AtomicReference<WriteStream> writeStream = new AtomicReference();
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final ConnectorPageSinkId pageSinkId;
    private final Optional<String> pageSinkIdColumnName;

    public BigQueryPageSink(BigQueryWriteClient client, RemoteTableName remoteTableName, List<String> columnNames, List<Type> columnTypes, ConnectorPageSinkId pageSinkId, Optional<String> temporaryTableName, Optional<String> pageSinkIdColumnName) {
        this.client = Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(remoteTableName, "remoteTableName is null");
        this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes must have the same size");
        this.pageSinkId = Objects.requireNonNull(pageSinkId, "pageSinkId is null");
        Objects.requireNonNull(temporaryTableName, "temporaryTableName is null");
        this.pageSinkIdColumnName = Objects.requireNonNull(pageSinkIdColumnName, "pageSinkIdColumnName is null");
        Preconditions.checkArgument((temporaryTableName.isPresent() == pageSinkIdColumnName.isPresent() ? 1 : 0) != 0, (Object)"temporaryTableName.isPresent is not equal to pageSinkIdColumn.isPresent");
        TableName tableName = temporaryTableName.map(table -> TableName.of((String)remoteTableName.getProjectId(), (String)remoteTableName.getDatasetName(), (String)table)).orElseGet(remoteTableName::toTableName);
        WriteStream stream = WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build();
        this.createWriteStreamRequest = CreateWriteStreamRequest.newBuilder().setParent(tableName.toString()).setWriteStream(stream).build();
    }

    public CompletableFuture<?> appendPage(Page page) {
        JSONArray batch = new JSONArray();
        for (int position = 0; position < page.getPositionCount(); ++position) {
            JSONObject row = new JSONObject();
            this.pageSinkIdColumnName.ifPresent(column -> row.put(column, this.pageSinkId.getId()));
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                row.put(this.columnNames.get(channel), BigQueryTypeUtils.readNativeValue(this.columnTypes.get(channel), page.getBlock(channel), position));
            }
            batch.put((Object)row);
        }
        this.insertWithCommitted(batch);
        return NOT_BLOCKED;
    }

    private void insertWithCommitted(JSONArray batch) {
        WriteStream stream = this.writeStream.updateAndGet(this::getOrCreateWriteStream);
        try (JsonStreamWriter writer = JsonStreamWriter.newBuilder((String)stream.getName(), (TableSchema)stream.getTableSchema(), (BigQueryWriteClient)this.client).build();){
            ApiFuture future = writer.append(batch);
            AppendRowsResponse response = (AppendRowsResponse)future.get();
            if (response.hasError()) {
                throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_BAD_WRITE, String.format("Response has error: %s", response.getError().getMessage()));
            }
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_BAD_WRITE, "Failed to insert rows", (Throwable)e);
        }
    }

    private WriteStream getOrCreateWriteStream(WriteStream current) {
        if (current == null) {
            return this.client.createWriteStream(this.createWriteStreamRequest);
        }
        return current;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        this.client.close();
        Slice value = Slices.allocate((int)8);
        value.setLong(0, this.pageSinkId.getId());
        return CompletableFuture.completedFuture(ImmutableList.of((Object)value));
    }

    public void abort() {
        this.client.close();
    }
}

