/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigHidden;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;

public class BigQueryRpcConfig {
    private static final int MAX_RPC_CONNECTIONS = 1024;
    private int rpcInitialChannelCount = 1;
    private int rpcMinChannelCount = 1;
    private int rpcMaxChannelCount = 1;
    private int minRpcPerChannel;
    private int maxRpcPerChannel = Integer.MAX_VALUE;
    private int retries;
    private Duration timeout = Duration.valueOf((String)"0s");
    private Duration retryDelay = Duration.valueOf((String)"0s");
    private double retryMultiplier = 1.0;

    @Min(value=1L)
    @Max(value=1024L)
    public @Min(value=1L) @Max(value=1024L) int getRpcInitialChannelCount() {
        return this.rpcInitialChannelCount;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.initial-size")
    public BigQueryRpcConfig setRpcInitialChannelCount(int rpcInitialChannelCount) {
        this.rpcInitialChannelCount = rpcInitialChannelCount;
        return this;
    }

    @Min(value=1L)
    @Max(value=1024L)
    public @Min(value=1L) @Max(value=1024L) int getRpcMinChannelCount() {
        return this.rpcMinChannelCount;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.min-size")
    public BigQueryRpcConfig setRpcMinChannelCount(int rpcMinChannelCount) {
        this.rpcMinChannelCount = rpcMinChannelCount;
        return this;
    }

    @Min(value=1L)
    @Max(value=1024L)
    public @Min(value=1L) @Max(value=1024L) int getRpcMaxChannelCount() {
        return this.rpcMaxChannelCount;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.max-size")
    public BigQueryRpcConfig setRpcMaxChannelCount(int rpcMaxChannelCount) {
        this.rpcMaxChannelCount = rpcMaxChannelCount;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMinRpcPerChannel() {
        return this.minRpcPerChannel;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.min-rpc-per-channel")
    public BigQueryRpcConfig setMinRpcPerChannel(int minRpcPerChannel) {
        this.minRpcPerChannel = minRpcPerChannel;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxRpcPerChannel() {
        return this.maxRpcPerChannel;
    }

    @ConfigHidden
    @Config(value="bigquery.channel-pool.max-rpc-per-channel")
    public BigQueryRpcConfig setMaxRpcPerChannel(int maxRpcPerChannel) {
        this.maxRpcPerChannel = maxRpcPerChannel;
        return this;
    }

    @Min(value=0L)
    @Max(value=16L)
    public @Min(value=0L) @Max(value=16L) int getRetries() {
        return this.retries;
    }

    @ConfigHidden
    @Config(value="bigquery.rpc-retries")
    public BigQueryRpcConfig setRetries(int maxRetries) {
        this.retries = maxRetries;
        return this;
    }

    @MinDuration(value="0s")
    @MaxDuration(value="1m")
    public @MinDuration(value="0s") @MaxDuration(value="1m") Duration getTimeout() {
        return this.timeout;
    }

    @ConfigHidden
    @Config(value="bigquery.rpc-timeout")
    public BigQueryRpcConfig setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @MinDuration(value="0s")
    @MaxDuration(value="30s")
    public @MinDuration(value="0s") @MaxDuration(value="30s") Duration getRetryDelay() {
        return this.retryDelay;
    }

    @ConfigHidden
    @Config(value="bigquery.rpc-retry-delay")
    public BigQueryRpcConfig setRetryDelay(Duration retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    @ConfigHidden
    @Config(value="bigquery.rpc-retry-delay-multiplier")
    public BigQueryRpcConfig setRetryMultiplier(double retryMultiplier) {
        this.retryMultiplier = retryMultiplier;
        return this;
    }

    @DecimalMin(value="1.0")
    @DecimalMax(value="2.0")
    public @DecimalMin(value="1.0") @DecimalMax(value="2.0") double getRetryMultiplier() {
        return this.retryMultiplier;
    }
}

