/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.spi.connector.ConnectorSplit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class BigQuerySplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BigQuerySplit.class);
    private static final int NO_ROWS_TO_GENERATE = -1;
    private final Mode mode;
    private final String streamName;
    private final String schemaString;
    private final List<BigQueryColumnHandle> columns;
    private final long emptyRowsToGenerate;
    private final Optional<String> filter;
    private final OptionalInt dataSize;

    @JsonCreator
    public BigQuerySplit(@JsonProperty(value="mode") Mode mode, @JsonProperty(value="streamName") String streamName, @JsonProperty(value="schemaString") String schemaString, @JsonProperty(value="columns") List<BigQueryColumnHandle> columns, @JsonProperty(value="emptyRowsToGenerate") long emptyRowsToGenerate, @JsonProperty(value="filter") Optional<String> filter, @JsonProperty(value="dataSize") OptionalInt dataSize) {
        this.mode = Objects.requireNonNull(mode, "mode is null");
        this.streamName = Objects.requireNonNull(streamName, "streamName cannot be null");
        this.schemaString = Objects.requireNonNull(schemaString, "schemaString cannot be null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns cannot be null"));
        this.emptyRowsToGenerate = emptyRowsToGenerate;
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.dataSize = Objects.requireNonNull(dataSize, "dataSize is null");
    }

    static BigQuerySplit forStream(String streamName, String schemaString, List<BigQueryColumnHandle> columns, OptionalInt dataSize) {
        return new BigQuerySplit(Mode.STORAGE, streamName, schemaString, columns, -1L, Optional.empty(), dataSize);
    }

    static BigQuerySplit forViewStream(List<BigQueryColumnHandle> columns, Optional<String> filter) {
        return new BigQuerySplit(Mode.QUERY, "", "", columns, -1L, filter, OptionalInt.empty());
    }

    static BigQuerySplit emptyProjection(long numberOfRows) {
        return new BigQuerySplit(Mode.STORAGE, "", "", (List<BigQueryColumnHandle>)ImmutableList.of(), numberOfRows, Optional.empty(), OptionalInt.of(0));
    }

    @JsonProperty
    public Mode getMode() {
        return this.mode;
    }

    @JsonProperty
    public String getStreamName() {
        return this.streamName;
    }

    @JsonProperty
    public String getSchemaString() {
        return this.schemaString;
    }

    @JsonProperty
    public List<BigQueryColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public long getEmptyRowsToGenerate() {
        return this.emptyRowsToGenerate;
    }

    @JsonProperty
    public Optional<String> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public OptionalInt getDataSize() {
        return this.dataSize;
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.streamName) + SizeOf.estimatedSizeOf((String)this.schemaString) + SizeOf.estimatedSizeOf(this.columns, BigQueryColumnHandle::getRetainedSizeInBytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQuerySplit that = (BigQuerySplit)o;
        return Objects.equals((Object)this.mode, (Object)that.mode) && Objects.equals(this.streamName, that.streamName) && Objects.equals(this.schemaString, that.schemaString) && Objects.equals(this.columns, that.columns) && Objects.equals(this.emptyRowsToGenerate, that.emptyRowsToGenerate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.streamName, this.schemaString, this.columns, this.emptyRowsToGenerate});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("streamName", (Object)this.streamName).add("schemaString", (Object)this.schemaString).add("columns", this.columns).add("emptyRowsToGenerate", this.emptyRowsToGenerate).toString();
    }

    boolean representsEmptyProjection() {
        return this.emptyRowsToGenerate != -1L;
    }

    public static enum Mode {
        STORAGE,
        QUERY;

    }
}

