/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryConnectorModule;
import io.trino.plugin.bigquery.BigQueryMetadata;
import io.trino.plugin.bigquery.BigQueryMetadataFactory;
import io.trino.plugin.bigquery.BigQueryTransactionHandle;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import java.util.Objects;

public class DefaultBigQueryMetadataFactory
implements BigQueryMetadataFactory {
    private final BigQueryClientFactory bigQueryClient;
    private final ListeningExecutorService executorService;
    private final BigQueryTypeManager typeManager;

    @Inject
    public DefaultBigQueryMetadataFactory(BigQueryClientFactory bigQueryClient, BigQueryTypeManager typeManager, @BigQueryConnectorModule.ForBigQuery ListeningExecutorService executorService) {
        this.bigQueryClient = Objects.requireNonNull(bigQueryClient, "bigQueryClient is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
    }

    @Override
    public BigQueryMetadata create(BigQueryTransactionHandle transaction) {
        return new BigQueryMetadata(this.bigQueryClient, this.typeManager, this.executorService);
    }
}

