/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.storage.v1.TableName;
import java.util.Objects;

public final class RemoteTableName {
    private final String projectId;
    private final String datasetName;
    private final String tableName;

    @JsonCreator
    public RemoteTableName(String projectId, String datasetName, String tableName) {
        this.projectId = Objects.requireNonNull(projectId, "projectId is null");
        this.datasetName = Objects.requireNonNull(datasetName, "datasetName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public RemoteTableName(TableId tableId) {
        this(tableId.getProject(), tableId.getDataset(), tableId.getTable());
    }

    public TableId toTableId() {
        return TableId.of((String)this.projectId, (String)this.datasetName, (String)this.tableName);
    }

    public TableName toTableName() {
        return TableName.of((String)this.projectId, (String)this.datasetName, (String)this.tableName);
    }

    @JsonProperty
    public String getProjectId() {
        return this.projectId;
    }

    @JsonProperty
    public String getDatasetName() {
        return this.datasetName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteTableName that = (RemoteTableName)o;
        return this.projectId.equals(that.projectId) && this.datasetName.equals(that.datasetName) && this.tableName.equals(that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.datasetName, this.tableName);
    }

    public String toString() {
        return String.format("%s.%s.%s", this.projectId, this.datasetName, this.tableName);
    }
}

