/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import jakarta.validation.constraints.AssertTrue;
import java.util.Optional;

public class StaticCredentialsConfig {
    private Optional<String> credentialsKey = Optional.empty();
    private Optional<String> credentialsFile = Optional.empty();

    @AssertTrue(message="Exactly one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified")
    public @AssertTrue(message="Exactly one of 'bigquery.credentials-key' or 'bigquery.credentials-file' must be specified") boolean isCredentialsConfigurationValid() {
        return this.credentialsKey.isEmpty() || this.credentialsFile.isEmpty();
    }

    public Optional<String> getCredentialsKey() {
        return this.credentialsKey;
    }

    @Config(value="bigquery.credentials-key")
    @ConfigDescription(value="The base64 encoded credentials key")
    @ConfigSecuritySensitive
    public StaticCredentialsConfig setCredentialsKey(String credentialsKey) {
        this.credentialsKey = Optional.ofNullable(credentialsKey);
        return this;
    }

    public Optional<@FileExists String> getCredentialsFile() {
        return this.credentialsFile;
    }

    @Config(value="bigquery.credentials-file")
    @ConfigDescription(value="The path to the JSON credentials file")
    public StaticCredentialsConfig setCredentialsFile(String credentialsFile) {
        this.credentialsFile = Optional.ofNullable(credentialsFile);
        return this;
    }
}

