/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientTelemetry;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry;
import io.trino.plugin.bigquery.BigQueryGrpcOptionsConfigurer;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import org.apache.http.client.HttpClient;

public class TracingOptionsConfigurer
implements BigQueryGrpcOptionsConfigurer {
    private final OpenTelemetry openTelemetry;
    private final GrpcInterceptorProvider grpcInterceptorProvider;

    @Inject
    public TracingOptionsConfigurer(OpenTelemetry openTelemetry) {
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        this.grpcInterceptorProvider = () -> ImmutableList.of((Object)GrpcTelemetry.create((OpenTelemetry)openTelemetry).newClientInterceptor());
    }

    @Override
    public BigQueryOptions.Builder configure(BigQueryOptions.Builder builder, ConnectorSession session) {
        return builder.setTransportOptions((TransportOptions)HttpTransportOptions.newBuilder().setHttpTransportFactory(() -> new ApacheHttpTransport((HttpClient)ApacheHttpClientTelemetry.create((OpenTelemetry)this.openTelemetry).newHttpClient())).build());
    }

    @Override
    public InstantiatingGrpcChannelProvider.Builder configure(InstantiatingGrpcChannelProvider.Builder channelBuilder, ConnectorSession session) {
        channelBuilder.setInterceptorProvider(this.grpcInterceptorProvider);
        return channelBuilder;
    }
}

