/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.MultiQuery;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementSanitizerUtil;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.AttributeKeyTemplate;
import java.util.Collection;
import java.util.Map;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST, RESPONSE>> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey((String)"db.operation");
    private static final AttributeKey<String> DB_OPERATION_NAME = AttributeKey.stringKey((String)"db.operation.name");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey((String)"db.statement");
    private static final AttributeKey<String> DB_QUERY_TEXT = AttributeKey.stringKey((String)"db.query.text");
    static final AttributeKey<String> DB_COLLECTION_NAME = AttributeKey.stringKey((String)"db.collection.name");
    private static final AttributeKey<Long> DB_OPERATION_BATCH_SIZE = AttributeKey.longKey((String)"db.operation.batch.size");
    private static final AttributeKeyTemplate<String> DB_QUERY_PARAMETER = AttributeKeyTemplate.stringKeyTemplate((String)"db.query.parameter");
    private static final String SQL_CALL = "CALL";
    private final AttributeKey<String> oldSemconvTableAttribute;
    private final boolean statementSanitizationEnabled;
    private final boolean captureQueryParameters;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST, RESPONSE> getter, AttributeKey<String> oldSemconvTableAttribute, boolean statementSanitizationEnabled, boolean captureQueryParameters) {
        super(getter);
        this.oldSemconvTableAttribute = oldSemconvTableAttribute;
        this.statementSanitizationEnabled = !captureQueryParameters && statementSanitizationEnabled;
        this.captureQueryParameters = captureQueryParameters;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String operation;
        SqlStatementInfo sanitizedStatement;
        String rawQueryText;
        boolean isBatch;
        super.onStart(attributes, parentContext, request);
        Collection<String> rawQueryTexts = ((SqlClientAttributesGetter)this.getter).getRawQueryTexts(request);
        if (rawQueryTexts.isEmpty()) {
            return;
        }
        Long batchSize = ((SqlClientAttributesGetter)this.getter).getBatchSize(request);
        boolean bl = isBatch = batchSize != null && batchSize > 1L;
        if (SemconvStability.emitOldDatabaseSemconv() && rawQueryTexts.size() == 1) {
            rawQueryText = rawQueryTexts.iterator().next();
            sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
            operation = sanitizedStatement.getOperation();
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_STATEMENT, (Object)(this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION, (Object)operation);
            if (!SQL_CALL.equals(operation)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.oldSemconvTableAttribute, (Object)sanitizedStatement.getMainIdentifier());
            }
        }
        if (SemconvStability.emitStableDatabaseSemconv()) {
            if (isBatch) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION_BATCH_SIZE, (Object)batchSize);
            }
            if (rawQueryTexts.size() == 1) {
                rawQueryText = rawQueryTexts.iterator().next();
                sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
                operation = sanitizedStatement.getOperation();
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_QUERY_TEXT, (Object)(this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText));
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION_NAME, (Object)(isBatch ? "BATCH " + operation : operation));
                if (!SQL_CALL.equals(operation)) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_COLLECTION_NAME, (Object)sanitizedStatement.getMainIdentifier());
                }
            } else {
                MultiQuery multiQuery = MultiQuery.analyze(((SqlClientAttributesGetter)this.getter).getRawQueryTexts(request), this.statementSanitizationEnabled);
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_QUERY_TEXT, (Object)SqlClientAttributesExtractor.join("; ", multiQuery.getStatements()));
                String operation2 = multiQuery.getOperation() != null ? "BATCH " + multiQuery.getOperation() : "BATCH";
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_OPERATION_NAME, (Object)operation2);
                if (!(multiQuery.getMainIdentifier() == null || multiQuery.getOperation() != null && SQL_CALL.equals(multiQuery.getOperation()))) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_COLLECTION_NAME, (Object)multiQuery.getMainIdentifier());
                }
            }
        }
        Map<String, String> queryParameters = ((SqlClientAttributesGetter)this.getter).getQueryParameters(request);
        this.setQueryParameters(attributes, isBatch, queryParameters);
    }

    private void setQueryParameters(AttributesBuilder attributes, boolean isBatch, Map<String, String> queryParameters) {
        if (this.captureQueryParameters && !isBatch && queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DB_QUERY_PARAMETER.getAttributeKey(key), (Object)value);
            }
        }
    }

    private static String join(String delimiter, Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        for (String string : collection) {
            if (builder.length() != 0) {
                builder.append(delimiter);
            }
            builder.append(string);
        }
        return builder.toString();
    }
}

