/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.bigquery.BigQueryArrowAllocatorStats;
import io.trino.plugin.bigquery.BigQueryArrowConfig;
import io.trino.plugin.bigquery.BigQuerySplit;
import java.util.Objects;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.AllocationOutcome;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class BigQueryArrowBufferAllocator {
    private static final Logger log = Logger.get(BigQueryArrowBufferAllocator.class);
    private static final long INITIAL_RESERVATION = 4096L;
    private final long maximumAllocationPerWorkerThread;
    private final BigQueryArrowAllocatorStats stats;
    private final BufferAllocator rootAllocator;

    @Inject
    public BigQueryArrowBufferAllocator(BigQueryArrowConfig config, BigQueryArrowAllocatorStats stats) {
        long estimatedMaxWorkerThreads = (long)Runtime.getRuntime().availableProcessors() * 2L;
        long maximumAllocation = Objects.requireNonNull(config, "config is null").getMaxAllocation().toBytes();
        this.maximumAllocationPerWorkerThread = maximumAllocation / estimatedMaxWorkerThreads;
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.rootAllocator = new RootAllocator((AllocationListener)stats, maximumAllocation);
    }

    public BufferAllocator newChildAllocator(BigQuerySplit split) {
        return this.rootAllocator.newChildAllocator(split.streamName(), (AllocationListener)new RetryingAllocationListener(split.streamName(), this.stats), 4096L, this.maximumAllocationPerWorkerThread);
    }

    @Managed
    @Flatten
    public BigQueryArrowAllocatorStats getStats() {
        return this.stats;
    }

    @Managed
    public long getCurrentAllocatedMemory() {
        return this.rootAllocator.getAllocatedMemory();
    }

    @Managed
    public long getPeakAllocatedMemory() {
        return this.rootAllocator.getPeakMemoryAllocation();
    }

    @Managed
    public long getCurrentMemoryHeadroom() {
        return this.rootAllocator.getHeadroom();
    }

    @Managed
    public long getChildAllocatorsCount() {
        return this.rootAllocator.getChildAllocators().size();
    }

    private static class RetryingAllocationListener
    implements AllocationListener {
        private final String name;
        private final BigQueryArrowAllocatorStats stats;

        private RetryingAllocationListener(String name, BigQueryArrowAllocatorStats stats) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.stats = Objects.requireNonNull(stats, "stats is null");
        }

        public boolean onFailedAllocation(long size, AllocationOutcome outcome) {
            this.stats.onFailedAllocation(size, outcome);
            log.warn("Failed to allocate %d bytes for allocator '%s' due to %s", new Object[]{size, this.name, outcome.getStatus()});
            outcome.getDetails().ifPresent(details -> log.warn("Allocation failure details: %s", new Object[]{details.toString()}));
            return false;
        }

        public void onPreAllocation(long size) {
            this.stats.onPreAllocation(size);
        }

        public void onAllocation(long size) {
            this.stats.onAllocation(size);
        }

        public void onRelease(long size) {
            this.stats.onRelease(size);
        }
    }
}

