/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record BigQueryColumnHandle(String name, List<String> dereferenceNames, Type trinoType, StandardSQLTypeName bigqueryType, boolean isPushdownSupported, Field.Mode mode, List<BigQueryColumnHandle> subColumns, String description, boolean hidden) implements ColumnHandle
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BigQueryColumnHandle.class);

    public BigQueryColumnHandle {
        Objects.requireNonNull(name, "name is null");
        dereferenceNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(dereferenceNames, "dereferenceNames is null"));
        Objects.requireNonNull(trinoType, "trinoType is null");
        Objects.requireNonNull(bigqueryType, "bigqueryType is null");
        Objects.requireNonNull(mode, "mode is null");
        subColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(subColumns, "subColumns is null"));
    }

    @JsonIgnore
    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.trinoType).setComment(Optional.ofNullable(this.description)).setNullable(this.mode == Field.Mode.NULLABLE).setHidden(this.hidden).build();
    }

    @JsonIgnore
    public String getQualifiedName() {
        return Joiner.on((char)'.').join((Iterable)ImmutableList.builder().add((Object)this.name).addAll(this.dereferenceNames).build());
    }

    @JsonIgnore
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.name) + SizeOf.estimatedSizeOf(this.subColumns, BigQueryColumnHandle::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.description);
    }

    @Override
    public String toString() {
        return "%s:%s".formatted(this.getQualifiedName(), this.trinoType.getDisplayName());
    }
}

