/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigHidden;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.trino.plugin.base.logging.FormatInterpolator;
import io.trino.plugin.base.logging.SessionInterpolatedValues;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"bigquery.parallelism"})
public class BigQueryConfig {
    public static final int DEFAULT_MAX_READ_ROWS_RETRIES = 3;
    public static final String VIEWS_ENABLED = "bigquery.views-enabled";
    public static final String ARROW_SERIALIZATION_ENABLED = "bigquery.arrow-serialization.enabled";
    private static final int MAX_METADATA_PARALLELISM = 32;
    private Optional<String> projectId = Optional.empty();
    private Optional<String> parentProjectId = Optional.empty();
    private boolean viewsEnabled;
    private boolean arrowSerializationEnabled = true;
    private Duration viewExpireDuration = new Duration(24.0, TimeUnit.HOURS);
    private boolean skipViewMaterialization;
    private boolean viewMaterializationWithFilter;
    private Optional<String> viewMaterializationProject = Optional.empty();
    private Optional<String> viewMaterializationDataset = Optional.empty();
    private int maxReadRowsRetries = 3;
    private int metadataPageSize = 1000;
    private boolean caseInsensitiveNameMatching;
    private Duration caseInsensitiveNameMatchingCacheTtl = new Duration(0.0, TimeUnit.MILLISECONDS);
    private Duration viewsCacheTtl = new Duration(15.0, TimeUnit.MINUTES);
    private Duration serviceCacheTtl = new Duration(3.0, TimeUnit.MINUTES);
    private Duration metadataCacheTtl = new Duration(0.0, TimeUnit.MILLISECONDS);
    @Deprecated
    private boolean isLegacyMetadataListing;
    private boolean queryResultsCacheEnabled;
    private String queryLabelName;
    private String queryLabelFormat;
    private boolean proxyEnabled;
    private boolean projectionPushDownEnabled = true;
    private int metadataParallelism = Math.min(Runtime.getRuntime().availableProcessors(), 32);
    private Optional<Integer> maxParallelism = Optional.empty();

    public Optional<String> getProjectId() {
        return this.projectId;
    }

    @Config(value="bigquery.project-id")
    @ConfigDescription(value="The Google Cloud Project ID where the data reside")
    public BigQueryConfig setProjectId(String projectId) {
        this.projectId = Optional.ofNullable(projectId);
        return this;
    }

    public Optional<String> getParentProjectId() {
        return this.parentProjectId;
    }

    @Config(value="bigquery.parent-project-id")
    @ConfigDescription(value="The Google Cloud Project ID to bill for the export")
    public BigQueryConfig setParentProjectId(String parentProjectId) {
        this.parentProjectId = Optional.ofNullable(parentProjectId);
        return this;
    }

    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    @Config(value="bigquery.views-enabled")
    @ConfigDescription(value="Enables the connector to read from views and not only tables")
    public BigQueryConfig setViewsEnabled(boolean viewsEnabled) {
        this.viewsEnabled = viewsEnabled;
        return this;
    }

    public boolean isArrowSerializationEnabled() {
        return this.arrowSerializationEnabled;
    }

    @Config(value="bigquery.arrow-serialization.enabled")
    @LegacyConfig(value={"bigquery.experimental.arrow-serialization.enabled"})
    @ConfigDescription(value="Enables Arrow serialization while reading data")
    public BigQueryConfig setArrowSerializationEnabled(boolean arrowSerializationEnabled) {
        this.arrowSerializationEnabled = arrowSerializationEnabled;
        return this;
    }

    @NotNull
    public Duration getViewExpireDuration() {
        return this.viewExpireDuration;
    }

    @Config(value="bigquery.view-expire-duration")
    public BigQueryConfig setViewExpireDuration(Duration viewExpireDuration) {
        this.viewExpireDuration = viewExpireDuration;
        return this;
    }

    public boolean isSkipViewMaterialization() {
        return this.skipViewMaterialization;
    }

    @Config(value="bigquery.skip-view-materialization")
    @ConfigDescription(value="Skip materializing views")
    public BigQueryConfig setSkipViewMaterialization(boolean skipViewMaterialization) {
        this.skipViewMaterialization = skipViewMaterialization;
        return this;
    }

    public boolean isViewMaterializationWithFilter() {
        return this.viewMaterializationWithFilter;
    }

    @Config(value="bigquery.view-materialization-with-filter")
    @ConfigDescription(value="Use filter when materializing views")
    public BigQueryConfig setViewMaterializationWithFilter(boolean viewMaterializationWithFilter) {
        this.viewMaterializationWithFilter = viewMaterializationWithFilter;
        return this;
    }

    public Optional<String> getViewMaterializationProject() {
        return this.viewMaterializationProject;
    }

    @Config(value="bigquery.view-materialization-project")
    @ConfigDescription(value="The project where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationProject(String viewMaterializationProject) {
        this.viewMaterializationProject = Optional.ofNullable(viewMaterializationProject);
        return this;
    }

    public Optional<String> getViewMaterializationDataset() {
        return this.viewMaterializationDataset;
    }

    @Config(value="bigquery.view-materialization-dataset")
    @ConfigDescription(value="The dataset where the materialized view is going to be created")
    public BigQueryConfig setViewMaterializationDataset(String viewMaterializationDataset) {
        this.viewMaterializationDataset = Optional.ofNullable(viewMaterializationDataset);
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    @Config(value="bigquery.max-read-rows-retries")
    @ConfigDescription(value="The number of retries in case of retryable server issues")
    public BigQueryConfig setMaxReadRowsRetries(int maxReadRowsRetries) {
        this.maxReadRowsRetries = maxReadRowsRetries;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMetadataPageSize() {
        return this.metadataPageSize;
    }

    @Config(value="bigquery.metadata-page-size")
    @ConfigDescription(value="The number of metadata entries retrieved per API request")
    public BigQueryConfig setMetadataPageSize(int metadataPageSize) {
        this.metadataPageSize = metadataPageSize;
        return this;
    }

    public boolean isCaseInsensitiveNameMatching() {
        return this.caseInsensitiveNameMatching;
    }

    @Config(value="bigquery.case-insensitive-name-matching")
    @ConfigDescription(value="Match dataset and table names case-insensitively")
    public BigQueryConfig setCaseInsensitiveNameMatching(boolean caseInsensitiveNameMatching) {
        this.caseInsensitiveNameMatching = caseInsensitiveNameMatching;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl;
    }

    @Config(value="bigquery.case-insensitive-name-matching.cache-ttl")
    @ConfigDescription(value="Duration for which case insensitive schema and table names are cached. Set to 0ms to disable the cache.")
    public BigQueryConfig setCaseInsensitiveNameMatchingCacheTtl(Duration caseInsensitiveNameMatchingCacheTtl) {
        this.caseInsensitiveNameMatchingCacheTtl = caseInsensitiveNameMatchingCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="0m")
    public @NotNull @MinDuration(value="0m") Duration getViewsCacheTtl() {
        return this.viewsCacheTtl;
    }

    @Config(value="bigquery.views-cache-ttl")
    @ConfigDescription(value="Duration for which the materialization of a view will be cached and reused")
    public BigQueryConfig setViewsCacheTtl(Duration viewsCacheTtl) {
        this.viewsCacheTtl = viewsCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="0m")
    public @NotNull @MinDuration(value="0m") Duration getServiceCacheTtl() {
        return this.serviceCacheTtl;
    }

    @ConfigHidden
    @Config(value="bigquery.service-cache-ttl")
    @ConfigDescription(value="Duration for which BigQuery client service instances are cached")
    public BigQueryConfig setServiceCacheTtl(Duration serviceCacheTtl) {
        this.serviceCacheTtl = serviceCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @Config(value="bigquery.metadata.cache-ttl")
    @ConfigDescription(value="Duration for which BigQuery client metadata is cached after listing")
    public BigQueryConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    public boolean isLegacyMetadataListing() {
        return this.isLegacyMetadataListing;
    }

    @Config(value="bigquery.legacy-metadata-listing")
    @ConfigHidden
    @ConfigDescription(value="Call BigQuery REST API per table when listing metadata")
    public BigQueryConfig setLegacyMetadataListing(boolean legacyMetadataListing) {
        this.isLegacyMetadataListing = legacyMetadataListing;
        return this;
    }

    public boolean isQueryResultsCacheEnabled() {
        return this.queryResultsCacheEnabled;
    }

    @Config(value="bigquery.query-results-cache.enabled")
    public BigQueryConfig setQueryResultsCacheEnabled(boolean queryResultsCacheEnabled) {
        this.queryResultsCacheEnabled = queryResultsCacheEnabled;
        return this;
    }

    public String getQueryLabelFormat() {
        return this.queryLabelFormat;
    }

    @Config(value="bigquery.job.label-format")
    @ConfigDescription(value="Adds `bigquery.job.label-name` label to the BigQuery job with provided value format")
    public BigQueryConfig setQueryLabelFormat(String queryLabelFormat) {
        this.queryLabelFormat = queryLabelFormat;
        return this;
    }

    @AssertTrue(message="Incorrect bigquery.job.label-format may consist of only letters, digits, underscores, commas, spaces, equal signs and predefined values")
    @AssertTrue(message="Incorrect bigquery.job.label-format may consist of only letters, digits, underscores, commas, spaces, equal signs and predefined values") boolean isQueryLabelFormatValid() {
        return this.queryLabelFormat == null || FormatInterpolator.hasValidPlaceholders((String)this.queryLabelFormat, (FormatInterpolator.InterpolatedValue[])SessionInterpolatedValues.values());
    }

    public String getQueryLabelName() {
        return this.queryLabelName;
    }

    @Config(value="bigquery.job.label-name")
    @ConfigDescription(value="Adds label with the given name to the BigQuery job")
    public BigQueryConfig setQueryLabelName(String queryLabelName) {
        this.queryLabelName = queryLabelName;
        return this;
    }

    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    @Config(value="bigquery.rpc-proxy.enabled")
    @ConfigDescription(value="Enables proxying of RPC and gRPC requests to BigQuery APIs")
    public BigQueryConfig setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
        return this;
    }

    public boolean isProjectionPushdownEnabled() {
        return this.projectionPushDownEnabled;
    }

    @Config(value="bigquery.projection-pushdown-enabled")
    @ConfigDescription(value="Dereference push down for ROW type")
    public BigQueryConfig setProjectionPushdownEnabled(boolean projectionPushDownEnabled) {
        this.projectionPushDownEnabled = projectionPushDownEnabled;
        return this;
    }

    @Min(value=1L)
    @Max(value=32L)
    public @Min(value=1L) @Max(value=32L) int getMetadataParallelism() {
        return this.metadataParallelism;
    }

    @ConfigDescription(value="Limits metadata enumeration calls parallelism")
    @Config(value="bigquery.metadata.parallelism")
    public BigQueryConfig setMetadataParallelism(int metadataParallelism) {
        this.metadataParallelism = metadataParallelism;
        return this;
    }

    public @NotNull Optional<@Min(value=1L) Integer> getMaxParallelism() {
        return this.maxParallelism;
    }

    @Config(value="bigquery.max-parallelism")
    @ConfigDescription(value="The max number of partitions to split the data into")
    public BigQueryConfig setMaxParallelism(Integer maxParallelism) {
        this.maxParallelism = Optional.ofNullable(maxParallelism);
        return this;
    }

    @AssertTrue(message="View expiration duration must be longer than view cache TTL")
    public @AssertTrue(message="View expiration duration must be longer than view cache TTL") boolean isValidViewExpireDuration() {
        return this.viewExpireDuration.toMillis() > this.viewsCacheTtl.toMillis();
    }

    @AssertTrue(message="bigquery.views-enabled config property must be enabled when bigquery.skip-view-materialization is enabled")
    public @AssertTrue(message="bigquery.views-enabled config property must be enabled when bigquery.skip-view-materialization is enabled") boolean isValidViewsWhenEnabledSkipViewMaterialization() {
        return !this.skipViewMaterialization || this.viewsEnabled;
    }

    @AssertTrue(message="bigquery.views-enabled config property must be enabled when bigquery.view-materialization-with-filter is enabled")
    public @AssertTrue(message="bigquery.views-enabled config property must be enabled when bigquery.view-materialization-with-filter is enabled") boolean isValidViewsEnableWhenViewMaterializationWithFilter() {
        return !this.viewMaterializationWithFilter || this.viewsEnabled;
    }

    @AssertTrue(message="bigquery.case-insensitive-name-matching config must be enabled when bigquery.case-insensitive-name-matching.cache-ttl is set")
    public @AssertTrue(message="bigquery.case-insensitive-name-matching config must be enabled when bigquery.case-insensitive-name-matching.cache-ttl is set") boolean isValidCaseInsensitiveNameMatchingCacheTtl() {
        return this.caseInsensitiveNameMatchingCacheTtl.isZero() || this.caseInsensitiveNameMatching;
    }
}

