/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.base.JdkCompatibilityChecks;
import io.trino.plugin.base.logging.FormatInterpolator;
import io.trino.plugin.base.logging.SessionInterpolatedValues;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.bigquery.BigQueryArrowAllocatorStats;
import io.trino.plugin.bigquery.BigQueryArrowBufferAllocator;
import io.trino.plugin.bigquery.BigQueryArrowConfig;
import io.trino.plugin.bigquery.BigQueryClientFactory;
import io.trino.plugin.bigquery.BigQueryConfig;
import io.trino.plugin.bigquery.BigQueryConnector;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.BigQueryLabelFactory;
import io.trino.plugin.bigquery.BigQueryMetadataFactory;
import io.trino.plugin.bigquery.BigQueryOptionsConfigurer;
import io.trino.plugin.bigquery.BigQueryPageSinkProvider;
import io.trino.plugin.bigquery.BigQueryPageSourceProvider;
import io.trino.plugin.bigquery.BigQueryProxyConfig;
import io.trino.plugin.bigquery.BigQueryReadClientFactory;
import io.trino.plugin.bigquery.BigQueryRpcConfig;
import io.trino.plugin.bigquery.BigQuerySessionProperties;
import io.trino.plugin.bigquery.BigQuerySplitManager;
import io.trino.plugin.bigquery.BigQueryTransactionManager;
import io.trino.plugin.bigquery.BigQueryTypeManager;
import io.trino.plugin.bigquery.BigQueryWriteClientFactory;
import io.trino.plugin.bigquery.CredentialsOptionsConfigurer;
import io.trino.plugin.bigquery.DefaultBigQueryCredentialsProvider;
import io.trino.plugin.bigquery.DefaultBigQueryMetadataFactory;
import io.trino.plugin.bigquery.ForBigQueryPageSource;
import io.trino.plugin.bigquery.GrpcChannelOptionsConfigurer;
import io.trino.plugin.bigquery.HeaderOptionsConfigurer;
import io.trino.plugin.bigquery.IdentityCacheMapping;
import io.trino.plugin.bigquery.ProxyOptionsConfigurer;
import io.trino.plugin.bigquery.ProxyTransportFactory;
import io.trino.plugin.bigquery.RetryOptionsConfigurer;
import io.trino.plugin.bigquery.StaticBigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.StaticCredentialsConfig;
import io.trino.plugin.bigquery.TracingOptionsConfigurer;
import io.trino.plugin.bigquery.ViewMaterializationCache;
import io.trino.plugin.bigquery.procedure.ExecuteProcedure;
import io.trino.plugin.bigquery.ptf.Query;
import io.trino.spi.NodeManager;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.procedure.Procedure;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.weakref.jmx.guice.ExportBinder;

public class BigQueryConnectorModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        this.install((Module)new ClientModule());
        this.install((Module)new StaticCredentialsModule());
    }

    public static class ClientModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            binder.bind(BigQueryReadClientFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryWriteClientFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryClientFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryTypeManager.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryConnector.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryMetadataFactory.class).to(DefaultBigQueryMetadataFactory.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryTransactionManager.class).in(Scopes.SINGLETON);
            binder.bind(BigQuerySplitManager.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryPageSourceProvider.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryPageSinkProvider.class).in(Scopes.SINGLETON);
            binder.bind(ViewMaterializationCache.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(BigQueryConfig.class);
            ConfigBinder.configBinder((Binder)binder).bindConfig(BigQueryRpcConfig.class);
            OptionalBinder.newOptionalBinder((Binder)binder, BigQueryArrowBufferAllocator.class);
            this.install(ConditionalModule.conditionalModule(BigQueryConfig.class, BigQueryConfig::isArrowSerializationEnabled, (Module)new ArrowSerializationModule()));
            Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)binder, Procedure.class).addBinding().toProvider(ExecuteProcedure.class).in(Scopes.SINGLETON);
            Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(BigQuerySessionProperties.class).in(Scopes.SINGLETON);
            Multibinder optionsConfigurers = Multibinder.newSetBinder((Binder)binder, BigQueryOptionsConfigurer.class);
            optionsConfigurers.addBinding().to(CredentialsOptionsConfigurer.class).in(Scopes.SINGLETON);
            optionsConfigurers.addBinding().to(HeaderOptionsConfigurer.class).in(Scopes.SINGLETON);
            optionsConfigurers.addBinding().to(RetryOptionsConfigurer.class).in(Scopes.SINGLETON);
            optionsConfigurers.addBinding().to(GrpcChannelOptionsConfigurer.class).in(Scopes.SINGLETON);
            optionsConfigurers.addBinding().to(TracingOptionsConfigurer.class).in(Scopes.SINGLETON);
            OptionalBinder.newOptionalBinder((Binder)binder, ProxyTransportFactory.class);
            this.install(ConditionalModule.conditionalModule(BigQueryConfig.class, BigQueryConfig::isProxyEnabled, proxyBinder -> {
                ConfigBinder.configBinder((Binder)proxyBinder).bindConfig(BigQueryProxyConfig.class);
                Multibinder.newSetBinder((Binder)proxyBinder, BigQueryOptionsConfigurer.class).addBinding().to(ProxyOptionsConfigurer.class).in(Scopes.SINGLETON);
                OptionalBinder.newOptionalBinder((Binder)binder, ProxyTransportFactory.class).setDefault().to(ProxyTransportFactory.DefaultProxyTransportFactory.class).in(Scopes.SINGLETON);
            }));
            ClosingBinder.closingBinder((Binder)binder).registerExecutor(ListeningExecutorService.class);
            ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForBigQueryPageSource.class));
        }

        @Provides
        @Singleton
        public static HeaderProvider createHeaderProvider(NodeManager nodeManager) {
            return FixedHeaderProvider.create((String[])new String[]{"user-agent", "Trino/" + nodeManager.getCurrentNode().getVersion()});
        }

        @Provides
        @Singleton
        public static BigQueryLabelFactory labelFactory(BigQueryConfig config) {
            return new BigQueryLabelFactory(config.getQueryLabelName(), (FormatInterpolator<ConnectorSession>)new FormatInterpolator(config.getQueryLabelFormat(), (FormatInterpolator.InterpolatedValue[])SessionInterpolatedValues.values()));
        }

        @Provides
        @Singleton
        public ListeningExecutorService provideListeningExecutor(BigQueryConfig config) {
            return MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(config.getMetadataParallelism(), Threads.daemonThreadsNamed((String)"big-query-%s")));
        }

        @Provides
        @Singleton
        @ForBigQueryPageSource
        public ExecutorService provideExecutor(CatalogName catalogName) {
            return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("bigquery-" + String.valueOf(catalogName) + "-%s")));
        }
    }

    public static class StaticCredentialsModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(StaticCredentialsConfig.class);
            OptionalBinder.newOptionalBinder((Binder)binder, IdentityCacheMapping.class).setDefault().to(IdentityCacheMapping.SingletonIdentityCacheMapping.class).in(Scopes.SINGLETON);
            OptionalBinder credentialsSupplierBinder = OptionalBinder.newOptionalBinder((Binder)binder, BigQueryCredentialsSupplier.class);
            credentialsSupplierBinder.setDefault().to(DefaultBigQueryCredentialsProvider.class).in(Scopes.SINGLETON);
            StaticCredentialsConfig staticCredentialsConfig = (StaticCredentialsConfig)this.buildConfigObject(StaticCredentialsConfig.class);
            if (staticCredentialsConfig.getCredentialsFile().isPresent() || staticCredentialsConfig.getCredentialsKey().isPresent()) {
                credentialsSupplierBinder.setBinding().to(StaticBigQueryCredentialsSupplier.class).in(Scopes.SINGLETON);
            }
        }
    }

    public static class ArrowSerializationModule
    extends AbstractConfigurationAwareModule {
        protected void setup(Binder binder) {
            JdkCompatibilityChecks.verifyConnectorAccessOpened((Binder)binder, (String)"bigquery", (Multimap)ImmutableMultimap.of((Object)"java.base", (Object)"java.nio"));
            JdkCompatibilityChecks.verifyConnectorUnsafeAllowed((Binder)binder, (String)"bigquery");
            ConfigBinder.configBinder((Binder)binder).bindConfig(BigQueryArrowConfig.class);
            binder.bind(BigQueryArrowBufferAllocator.class).in(Scopes.SINGLETON);
            binder.bind(BigQueryArrowAllocatorStats.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(BigQueryArrowBufferAllocator.class).withGeneratedName();
        }
    }
}

