/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;

public class BigQueryEmptyProjectionPageSource
implements ConnectorPageSource {
    private static final int MAX_RLE_PAGE_SIZE = 131072;
    private final long numberOfRows;
    private long outputRows;

    public BigQueryEmptyProjectionPageSource(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.outputRows == this.numberOfRows;
    }

    public SourcePage getNextSourcePage() {
        int positionCount = Math.toIntExact(Math.min(131072L, this.numberOfRows - this.outputRows));
        this.outputRows += (long)positionCount;
        return SourcePage.create((int)positionCount);
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public void close() {
    }
}

